/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.data;

import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.dbeaver.db.ycql.data.CasAbstractValue;
import com.dbeaver.db.ycql.data.CasListValue;
import com.dbeaver.db.ycql.data.CasMapValue;
import com.dbeaver.db.ycql.data.CasSetValue;
import com.dbeaver.db.ycql.data.YcqlContentJSON;
import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasExecutionContext;
import com.dbeaver.db.ycql.model.CasKeyspace;
import com.dbeaver.db.ycql.model.CasUserType;
import com.dbeaver.db.ycql.model.CasUserTypeAttribute;
import com.dbeaver.model.data.DBContentByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class CasUDTValue
extends CasAbstractValue
implements DBDComposite,
DBDValueCloneable {
    private static final Log log = Log.getLog(CasUDTValue.class);
    @Nullable
    private UdtValue rawValue;
    @Nullable
    private CasUserType userType;

    public CasUDTValue(@NotNull CasExecutionContext executionContext, @NotNull String keyspace, @Nullable UdtValue value) throws DBCException {
        super(executionContext, keyspace);
        this.rawValue = value;
        if (value == null) {
            this.userType = null;
        } else {
            String keyspaceName = value.getType().getKeyspace().toString();
            CasKeyspace ks = ((CasDataSource)executionContext.getDataSource()).getKeyspace(keyspaceName);
            if (ks == null) {
                throw new DBCException("UDT keyspace '" + keyspaceName + "' not found");
            }
            try {
                this.userType = ks.getUserType((DBRProgressMonitor)new VoidProgressMonitor(), (DataType)value.getType());
            }
            catch (DBException e) {
                throw new DBCException("Error reading user type for UDT", (Throwable)e);
            }
            if (this.userType == null) {
                throw new DBCException("Can't find user type for UDT value: " + String.valueOf(value.getType()));
            }
        }
    }

    public CasUDTValue(CasUDTValue value) {
        super(value);
        this.rawValue = value.rawValue;
        this.userType = value.userType;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) {
        return new CasUDTValue(this);
    }

    public UdtValue getRawValue() {
        return this.rawValue;
    }

    public boolean isNull() {
        return this.rawValue == null;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        this.rawValue = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "[NULL]";
        }
        return this.rawValue.toString();
    }

    public CasUserType getDataType() {
        return this.userType;
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        if (this.userType == null) {
            return new DBSAttributeBase[0];
        }
        try {
            List<CasUserTypeAttribute> attrs = this.userType.getAttributes((DBRProgressMonitor)new VoidProgressMonitor());
            if (attrs == null) {
                return new DBSAttributeBase[0];
            }
            DBSAttributeBase[] result = new DBSAttributeBase[attrs.size()];
            attrs.toArray(result);
            return result;
        }
        catch (DBException e) {
            log.error((Object)e);
            return new DBSAttributeBase[0];
        }
    }

    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
        if (this.rawValue == null) {
            return null;
        }
        int index = attribute.getOrdinalPosition() - 1;
        DataType type = ((CasUserTypeAttribute)attribute).getCasDataType();
        switch (type.getProtocolCode()) {
            case 1: 
            case 13: {
                return this.rawValue.getString(index);
            }
            case 20: {
                return this.rawValue.getByte(index);
            }
            case 19: {
                return this.rawValue.getShort(index);
            }
            case 9: {
                return this.rawValue.getInt(index);
            }
            case 2: 
            case 5: {
                return this.rawValue.getLong(index);
            }
            case 14: {
                return this.rawValue.getToken(index);
            }
            case 6: {
                return this.rawValue.getBigDecimal(index);
            }
            case 8: {
                return Float.valueOf(this.rawValue.getFloat(index));
            }
            case 7: {
                return this.rawValue.getDouble(index);
            }
            case 4: {
                return this.rawValue.getBoolean(index);
            }
            case 17: {
                return this.rawValue.getLocalDate(index);
            }
            case 18: {
                return this.rawValue.getLocalTime(index);
            }
            case 11: {
                return this.rawValue.getInstant(index);
            }
            case 12: 
            case 15: {
                return this.rawValue.getUuid(index);
            }
            case 16: {
                return this.rawValue.getInetAddress(index);
            }
            case 33: {
                return new CasMapValue(this.executionContext, this.keyspace, (Map)this.rawValue.getObject(index), (MapType)type);
            }
            case 32: {
                return new CasListValue((DBRProgressMonitor)new VoidProgressMonitor(), this.executionContext, this.keyspace, (List)this.rawValue.getObject(index), (ListType)type);
            }
            case 34: {
                return new CasSetValue(this.executionContext, this.keyspace, (Collection)this.rawValue.getObject(index), (SetType)type);
            }
            case 49: {
                return this.rawValue.getTupleValue(index);
            }
            case 48: {
                return new CasUDTValue(this.executionContext, this.keyspace, this.rawValue.getUdtValue(index));
            }
            case 128: {
                return new YcqlContentJSON((DBCExecutionContext)this.executionContext, (String)this.rawValue.get(index, TypeCodecs.JSONB));
            }
        }
        return new DBContentByteBuffer((DBCExecutionContext)this.executionContext, this.rawValue.getByteBuffer(index));
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) throws DBCException {
        log.error((Object)"UDT value set not implemented yet");
    }
}

