/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import java.io.IOException;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.lightcouch.CouchDbClientBase;
import org.lightcouch.CouchDbConfig;
import org.lightcouch.CouchDbProperties;

public class CouchDbClientAndroid
extends CouchDbClientBase {
    public CouchDbClientAndroid() {
    }

    public CouchDbClientAndroid(String configFileName) {
        super(new CouchDbConfig(configFileName));
    }

    public CouchDbClientAndroid(String dbName, boolean createDbIfNotExist, String protocol, String host, int port, String username, String password) {
        super(new CouchDbConfig(new CouchDbProperties(dbName, createDbIfNotExist, protocol, host, port, username, password)));
    }

    public CouchDbClientAndroid(CouchDbProperties properties) {
        super(new CouchDbConfig(properties));
    }

    @Override
    HttpClient createHttpClient(CouchDbProperties props) {
        DefaultHttpClient httpclient = null;
        try {
            SchemeRegistry schemeRegistry = this.createRegistry(props);
            BasicHttpParams params = new BasicHttpParams();
            params.setParameter("http.protocol.content-charset", (Object)"UTF-8");
            params.setParameter("http.socket.timeout", (Object)props.getSocketTimeout());
            params.setParameter("http.connection.timeout", (Object)props.getConnectionTimeout());
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
            httpclient = new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
            if (props.getProxyHost() != null) {
                HttpHost proxy = new HttpHost(props.getProxyHost(), props.getProxyPort());
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
            if (props.getUsername() != null && props.getPassword() != null) {
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(props.getHost(), props.getPort()), (Credentials)new UsernamePasswordCredentials(props.getUsername(), props.getPassword()));
                props.clearPassword();
            }
            this.registerInterceptors(httpclient);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error Creating HTTP client. ", e);
        }
        return httpclient;
    }

    @Override
    HttpContext createContext() {
        BasicHttpContext context = new BasicHttpContext();
        BasicScheme basicAuth = new BasicScheme();
        context.setAttribute("preemptive-auth", (Object)basicAuth);
        ((AbstractHttpClient)this.httpClient).addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthInterceptor(), 0);
        return context;
    }

    @Override
    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private SchemeRegistry createRegistry(CouchDbProperties properties) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        SchemeRegistry registry = new SchemeRegistry();
        if ("https".equals(properties.getProtocol())) {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            MySSLSocketFactory sf = new MySSLSocketFactory(trustStore);
            sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            registry.register(new Scheme(properties.getProtocol(), (SocketFactory)sf, properties.getPort()));
        } else {
            registry.register(new Scheme(properties.getProtocol(), (SocketFactory)PlainSocketFactory.getSocketFactory(), properties.getPort()));
        }
        return registry;
    }

    private void registerInterceptors(DefaultHttpClient httpclient) {
        httpclient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws IOException {
                if (CouchDbClientBase.log.isInfoEnabled()) {
                    RequestLine req = request.getRequestLine();
                    CouchDbClientBase.log.info((Object)("> " + req.getMethod() + URLDecoder.decode(req.getUri(), "UTF-8")));
                }
            }
        });
        httpclient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws IOException {
                if (CouchDbClientBase.log.isInfoEnabled()) {
                    CouchDbClientBase.log.info((Object)("< Status: " + response.getStatusLine().getStatusCode()));
                }
                CouchDbClientAndroid.this.validate(response);
            }
        });
    }

    private static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    authState.setAuthScheme(authScheme);
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds != null) {
                        authState.setCredentials(creds);
                    }
                }
            }
        }
    }

    private static class MySSLSocketFactory
    extends SSLSocketFactory {
        SSLContext sslContext = SSLContext.getInstance("TLS");

        public MySSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            this.sslContext.init(null, new TrustManager[]{tm}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }
}

