/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.ui;

import com.dbeaver.ee.sched.ui.ScheduleTaskDialog;
import com.dbeaver.ee.sched.ui.TaskHandlerScheduleBase;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTSchedulerDescriptor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class TaskHandlerScheduleCreate
extends TaskHandlerScheduleBase {
    @Override
    protected void execute(@NotNull ExecutionEvent event, @NotNull DBTTask task, @NotNull DBTSchedulerDescriptor descriptor, @NotNull DBTScheduler scheduler) {
        if (!this.ensureCanSchedule()) {
            return;
        }
        DBTTaskScheduleConfiguration configuration = new DBTTaskScheduleConfiguration();
        configuration.frequency = DBTTaskScheduleConfiguration.Frequency.MONTHLY;
        try {
            ArrayList warnings = new ArrayList();
            if (!scheduler.canSchedule(task, warnings)) {
                DBWorkbench.getPlatformUI().showMessageBox("Can't schedule the task", "Scheduling of tasks of type '" + task.getType().getName() + "' is unavailable.", false);
                return;
            }
            if (!CommonUtils.isEmpty(warnings)) {
                DBWorkbench.getPlatformUI().showWarningMessageBox("Scheduler warnings", String.join((CharSequence)"\n", warnings));
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Can't schedule the task", null, (Throwable)e);
            return;
        }
        ScheduleTaskDialog dialog = new ScheduleTaskDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), task, descriptor, scheduler, configuration, false);
        if (dialog.open() == 0) {
            this.refreshScheduledInfo(event);
            DBWorkbench.getPlatformUI().showNotification("Task scheduled", "Task '" + task.getName() + "' has been scheduled in " + scheduler.getSchedulerName(), false, null);
        }
    }
}

