/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc.model.team;

import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class DCTeamCreateRequest {
    private final String teamId;
    private final String name;
    private final String description;
    private final String grantor;

    private DCTeamCreateRequest(@NotNull String teamId, @Nullable String name, @Nullable String description, @NotNull String grantor) {
        this.teamId = Objects.requireNonNull(teamId, "The team id is null");
        this.name = name;
        this.description = description;
        this.grantor = Objects.requireNonNull(grantor, "The grantor is null");
    }

    @NotNull
    public String getTeamId() {
        return this.teamId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getGrantor() {
        return this.grantor;
    }

    public static Builder builder(@NotNull String teamId, @NotNull String grantor) {
        return new Builder(teamId, grantor);
    }

    public static final class Builder {
        private final String teamId;
        private final String grantor;
        private String name;
        private String description;

        private Builder(@NotNull String teamId, @NotNull String grantor) {
            this.teamId = teamId;
            this.grantor = grantor;
        }

        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public DCTeamCreateRequest build() {
            return new DCTeamCreateRequest(this.teamId, this.name, this.description, this.grantor);
        }
    }
}

