/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc.model.session;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.auth.SMSessionType;

public class DCSessionAuthRequest {
    @NotNull
    private final String authProviderId;
    @Nullable
    private final String authProviderConfigurationId;
    @NotNull
    private final Map<String, Object> userCredentials;
    @NotNull
    private final String appSessionId;
    @Nullable
    private final String previousSmSessionId;
    private final boolean forceSessionsLogout;
    @NotNull
    private final Map<String, Object> sessionParameters;
    @NotNull
    private final SMSessionType sessionType;

    private DCSessionAuthRequest(@NotNull String authProviderId, @Nullable String authProviderConfigurationId, @NotNull Map<String, Object> userCredentials, @NotNull String appSessionId, @Nullable String previousSmSessionId, boolean forceSessionsLogout, @NotNull Map<String, Object> sessionParameters, @NotNull SMSessionType sessionType) {
        this.authProviderId = Objects.requireNonNull(authProviderId, "The auth provider id is null");
        this.authProviderConfigurationId = authProviderConfigurationId;
        this.userCredentials = Objects.requireNonNull(userCredentials, "The user credentials id is null");
        this.appSessionId = appSessionId;
        this.previousSmSessionId = previousSmSessionId;
        this.forceSessionsLogout = forceSessionsLogout;
        this.sessionParameters = sessionParameters;
        this.sessionType = sessionType;
    }

    @NotNull
    public String getAuthProviderId() {
        return this.authProviderId;
    }

    @NotNull
    public Map<String, Object> getUserCredentials() {
        return this.userCredentials;
    }

    @NotNull
    public String getAppSessionId() {
        return this.appSessionId;
    }

    @NotNull
    public Map<String, Object> getSessionParameters() {
        return this.sessionParameters;
    }

    @NotNull
    public SMSessionType getSessionType() {
        return this.sessionType;
    }

    public static Builder builder(String appSessionId) {
        return new Builder(appSessionId);
    }

    public String getAuthProviderConfigurationId() {
        return this.authProviderConfigurationId;
    }

    @Nullable
    public String getPreviousSmSessionId() {
        return this.previousSmSessionId;
    }

    public boolean isForceSessionsLogout() {
        return this.forceSessionsLogout;
    }

    public static final class Builder {
        private final String appSessionId;
        private String authProviderId = "";
        private String authProviderConfigurationId;
        private String previousSmSessionId;
        private boolean forceSessionsLogout;
        private Map<String, Object> userCredentials = Collections.emptyMap();
        private Map<String, Object> sessionParameters = Collections.emptyMap();
        private boolean anonymousAuth = false;
        private SMSessionType sessionType;

        private Builder(String appSessionId) {
            this.appSessionId = appSessionId;
        }

        public Builder setAuthProviderId(String authProviderId) {
            this.authProviderId = authProviderId;
            return this;
        }

        public Builder setAuthProviderConfigurationId(String authProviderConfigurationId) {
            this.authProviderConfigurationId = authProviderConfigurationId;
            return this;
        }

        public Builder setUserCredentials(Map<String, Object> userCredentials) {
            this.userCredentials = userCredentials;
            return this;
        }

        public Builder setPreviousSmSessionId(String previousSmSessionId) {
            this.previousSmSessionId = previousSmSessionId;
            return this;
        }

        public Builder setForceSessionsLogout(boolean forceSessionsLogout) {
            this.forceSessionsLogout = forceSessionsLogout;
            return this;
        }

        public Builder setSessionParameters(Map<String, Object> sessionParameters) {
            this.sessionParameters = sessionParameters;
            return this;
        }

        public Builder setSessionType(SMSessionType sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        public DCSessionAuthRequest build() {
            return new DCSessionAuthRequest(this.authProviderId, this.authProviderConfigurationId, this.userCredentials, this.appSessionId, this.previousSmSessionId, this.forceSessionsLogout, this.sessionParameters, this.sessionType);
        }
    }
}

