/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc.model.objects;

import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.security.SMObjectType;

public class DCObjectsUpdatePermissionsRequest {
    @NotNull
    private final Set<String> objectIds;
    @NotNull
    private final SMObjectType objectType;
    @NotNull
    private final Set<String> subjectIds;
    @NotNull
    private final Set<String> permissions;

    private DCObjectsUpdatePermissionsRequest(@NotNull Set<String> objectIds, @NotNull SMObjectType objectType, @NotNull Set<String> subjectIds, @NotNull Set<String> permissions) {
        this.objectIds = objectIds;
        this.objectType = objectType;
        this.subjectIds = subjectIds;
        this.permissions = permissions;
    }

    public static Builder builder(SMObjectType objectType) {
        return new Builder(objectType);
    }

    @NotNull
    public Set<String> getObjectIds() {
        return this.objectIds;
    }

    @NotNull
    public SMObjectType getObjectType() {
        return this.objectType;
    }

    @NotNull
    public Set<String> getSubjectIds() {
        return this.subjectIds;
    }

    @NotNull
    public Set<String> getPermissions() {
        return this.permissions;
    }

    public static final class Builder {
        @NotNull
        private Set<String> objectIds = Set.of();
        @NotNull
        private SMObjectType objectType;
        @NotNull
        private Set<String> subjectIds = Set.of();
        @NotNull
        private Set<String> permissions = Set.of();

        private Builder(@NotNull SMObjectType objectType) {
            this.objectType = objectType;
        }

        public Builder setObjectIds(@NotNull Set<String> objectIds) {
            this.objectIds = objectIds;
            return this;
        }

        public Builder setObjectType(@NotNull SMObjectType objectType) {
            this.objectType = objectType;
            return this;
        }

        public Builder setSubjectIds(@NotNull Set<String> subjectIds) {
            this.subjectIds = subjectIds;
            return this;
        }

        public Builder setPermissions(@NotNull Set<String> permissions) {
            this.permissions = permissions;
            return this;
        }

        public DCObjectsUpdatePermissionsRequest build() {
            return new DCObjectsUpdatePermissionsRequest(this.objectIds, this.objectType, this.subjectIds, this.permissions);
        }
    }
}

