/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc.model.license;

import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseRole;
import com.dbeaver.lm.api.LMLicenseType;
import java.util.Date;
import java.util.List;

public class DCLicense {
    private final String licenseId;
    private final LMLicenseType licenseType;
    private final Date licenseIssueTime;
    private final Date licenseStartTime;
    private final Date licenseEndTime;
    private final long flags;
    private final String productId;
    private final String productVersion;
    private final String ownerId;
    private final String ownerCompany;
    private final String ownerName;
    private final String ownerEmail;
    private final short usersNumber;
    private final short serversNumber;
    private final List<LMLicenseRole> roles;

    private DCLicense(Builder builder) {
        LMLicense license = builder.license;
        this.licenseId = license.getLicenseId();
        this.licenseType = license.getLicenseType();
        this.licenseIssueTime = license.getLicenseIssueTime();
        this.licenseStartTime = license.getLicenseStartTime();
        this.licenseEndTime = license.getLicenseEndTime();
        this.flags = license.getFlags();
        this.productId = license.getProductId();
        this.productVersion = license.getProductVersion();
        this.ownerId = license.getOwnerId();
        this.ownerCompany = license.getOwnerCompany();
        this.ownerName = license.getOwnerName();
        this.ownerEmail = license.getOwnerEmail();
        this.usersNumber = license.getUsersNumber();
        this.serversNumber = license.getServersNumber();
        this.roles = license.getRoles();
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public LMLicenseType getLicenseType() {
        return this.licenseType;
    }

    public Date getLicenseIssueTime() {
        return this.licenseIssueTime;
    }

    public Date getLicenseStartTime() {
        return this.licenseStartTime;
    }

    public Date getLicenseEndTime() {
        return this.licenseEndTime;
    }

    public long getFlags() {
        return this.flags;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerCompany() {
        return this.ownerCompany;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public short getUsersNumber() {
        return this.usersNumber;
    }

    private short getServersNumber() {
        return this.serversNumber;
    }

    public List<LMLicenseRole> getRoles() {
        return this.roles;
    }

    public static DCLicense fromLMLicense(LMLicense license) {
        return new Builder(license).build();
    }

    public static LMLicense toLMLicense(DCLicense license) {
        LMLicense lmLicense = new LMLicense(license.getLicenseId(), license.getLicenseType(), license.getLicenseIssueTime(), license.getLicenseStartTime(), license.getLicenseEndTime(), license.getFlags(), license.getProductId(), license.getProductVersion(), license.getOwnerId(), license.getOwnerCompany(), license.getOwnerName(), license.getOwnerEmail());
        lmLicense.setRoles(license.getRoles());
        lmLicense.setUsersNumber((short)license.getRoles().stream().mapToInt(LMLicenseRole::getUsersNumber).sum());
        lmLicense.setServersNumber(license.getServersNumber());
        return lmLicense;
    }

    public static final class Builder {
        private final LMLicense license;

        public Builder(LMLicense license) {
            this.license = license;
        }

        public DCLicense build() {
            return new DCLicense(this);
        }
    }
}

