/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc.internal;

import com.dbeaver.model.auth.SMAPIToken;
import com.dbeaver.model.auth.SMClientUtils;
import com.dbeaver.model.auth.SMServerAPI;
import com.dbeaver.model.sm.permissions.SMGlobalPermission;
import com.dbeaver.model.sm.permissions.SMGlobalPermissionGrant;
import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.model.DCAdminObjectsService;
import com.dbeaver.remote.client.dc.model.DCAdminSubjectsService;
import com.dbeaver.remote.client.dc.model.DCAdminTeamsService;
import com.dbeaver.remote.client.dc.model.DCAdminUserService;
import com.dbeaver.remote.client.dc.model.DCFinishEasyConfigRequest;
import com.dbeaver.remote.client.dc.model.DCObjectsService;
import com.dbeaver.remote.client.dc.model.DCSessionsService;
import com.dbeaver.remote.client.dc.model.DCSubjectsService;
import com.dbeaver.remote.client.dc.model.DCUsersService;
import com.dbeaver.remote.client.dc.model.objects.DCObjectsSettingsAddRequest;
import com.dbeaver.remote.client.dc.model.objects.DCObjectsUpdatePermissionsRequest;
import com.dbeaver.remote.client.dc.model.session.DCSessionUpdateRequest;
import com.dbeaver.remote.client.dc.model.subjects.DCSubjectUpdatePermissionsRequest;
import com.dbeaver.remote.client.dc.model.team.DCTeamCreateRequest;
import com.dbeaver.remote.client.dc.model.team.DCTeamUpdateRequest;
import com.dbeaver.remote.client.dc.model.user.DCCreateAPITokenRequest;
import com.dbeaver.remote.client.dc.model.user.DCEnableUserUpdateRequest;
import com.dbeaver.remote.client.dc.model.user.DCUserAuthRoleUpdateRequest;
import com.dbeaver.remote.client.dc.model.user.DCUserCreateRequest;
import com.dbeaver.remote.client.dc.model.user.DCUserTeamsUpdateRequest;
import com.dbeaver.remote.client.dc.model.user.DCUserUpdateCredentialsRequest;
import com.dbeaver.remote.client.dc.model.user.DCUserUpdateParameterRequest;
import com.dbeaver.remote.client.interceptor.DCAuthInterceptor;
import com.dbeaver.remote.client.interceptor.DCTrustedServiceInterceptor;
import com.dbeaver.remote.client.interceptor.DCUserAgentInterceptor;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Interceptor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.security.SMObjectPermissionsGrant;
import org.jkiss.dbeaver.model.security.SMObjectType;
import org.jkiss.dbeaver.model.security.SMPropertyDescriptor;
import org.jkiss.dbeaver.model.security.SMSubjectType;
import org.jkiss.dbeaver.model.security.SMTeamMemberInfo;
import org.jkiss.dbeaver.model.security.exception.SMException;
import org.jkiss.dbeaver.model.security.user.SMObjectPermissions;
import org.jkiss.dbeaver.model.security.user.SMTeam;
import org.jkiss.dbeaver.model.security.user.SMUser;
import org.jkiss.dbeaver.model.security.user.SMUserFilter;
import org.jkiss.dbeaver.model.security.user.SMUserImportList;
import org.jkiss.dbeaver.model.security.user.SMUserTeam;

public class DCSecurityControllerClient
extends AbstractRemoteClient
implements DCAdminUserService,
DCUsersService,
DCAdminTeamsService,
DCSessionsService,
DCAdminSubjectsService,
DCSubjectsService,
DCAdminObjectsService,
DCObjectsService {
    @Nullable
    private final SMServerAPI serverAPI;

    public DCSecurityControllerClient(DCClientConfiguration dcClientConfiguration) {
        super(dcClientConfiguration.getApiUrl(), 0, 0, DCSecurityControllerClient.getInterceptors(dcClientConfiguration));
        this.serverAPI = dcClientConfiguration.getServerAPI();
    }

    protected void handleRequestException(Exception e) throws DBException {
        if (e instanceof SMException) {
            throw (SMException)e;
        }
        throw new SMException(e.getMessage(), (Throwable)e);
    }

    @Override
    public int countUsers(@NotNull SMUserFilter filter) throws DBException {
        return (Integer)this.executePostRequestVal("admin/users/count", filter, (Type)((Object)Integer.class));
    }

    @Override
    @NotNull
    public SMUser[] findUsers(String userNameMask) throws DBException {
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        if (userNameMask != null) {
            queryParams.put("userNameMask", userNameMask);
        }
        return (SMUser[])this.executeGetRequestVal("admin/users", queryParams, (Type)((Object)SMUser[].class));
    }

    @Override
    @NotNull
    public SMUser[] findUsers(@NotNull SMUserFilter filter) throws DBException {
        return (SMUser[])this.executePostRequestVal("admin/users/filter", filter, (Type)((Object)SMUser[].class));
    }

    @Override
    public void createUser(@NotNull DCUserCreateRequest userCreateRequest) throws DBException {
        this.executePostRequest("admin/users", userCreateRequest, (Type)((Object)Void.class));
    }

    @Override
    public void importUsers(@NotNull SMUserImportList userImportList) throws DBException {
        this.executePostRequest("admin/users/import", userImportList, (Type)((Object)Void.class));
    }

    @Override
    public void deleteUser(String userId) throws DBException {
        this.executeDeleteRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId}), (Type)((Object)Void.class));
    }

    @Override
    public void invalidateAllTokens() throws DBException {
        this.executeDeleteRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", "tokens"}), (Type)((Object)Void.class));
    }

    @Override
    public void updateUserTeams(@NotNull String userId, @NotNull DCUserTeamsUpdateRequest teamsUpdateRequest) throws DBException {
        String endpointUrl = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "teams"});
        this.executePutRequest(endpointUrl, teamsUpdateRequest, (Type)((Object)Void.class));
    }

    @Override
    public void addUserTeams(@NotNull String userId, @NotNull String[] teamIds, @NotNull String grantorId) throws DBException {
        String endpointUrl = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "teams"});
        Map<String, String> queryParams = Map.of("grantorId", grantorId);
        this.executePostRequest(endpointUrl, queryParams, teamIds, (Type)((Object)Void.class));
    }

    @Override
    public void deleteUserTeams(@NotNull String userId, @NotNull String[] teamIds) throws DBException {
        String endpointUrl = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "teams/delete"});
        this.executePostRequest(endpointUrl, teamIds, (Type)((Object)Void.class));
    }

    @NotNull
    public SMUserTeam[] getUserTeams() throws DBException {
        String endpointUrl = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"users", "teams"});
        return (SMUserTeam[])this.executeGetRequestVal(endpointUrl, (Type)((Object)SMUserTeam[].class));
    }

    @NotNull
    public SMUserTeam[] getUserTeams(@NotNull String userId) throws DBException {
        String endpointUrl = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "teams"});
        return (SMUserTeam[])this.executeGetRequestVal(endpointUrl, (Type)((Object)SMUserTeam[].class));
    }

    @Override
    @NotNull
    public SMUser getCurrentUser() throws DBException {
        return (SMUser)this.executeGetRequestVal(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"users"}), (Type)((Object)SMUser.class));
    }

    @Override
    @NotNull
    public SMUser getUserById(@NotNull String userId) throws DBException {
        return (SMUser)this.executeGetRequestVal(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId}), (Type)((Object)SMUser.class));
    }

    @Override
    @NotNull
    public Map<String, Object> getUserParameters() throws DBException {
        return (Map)this.executeGetRequestVal("users/parameters", new TypeToken<HashMap<String, Object>>(){}.getType());
    }

    @Override
    public void setUserParameter(@NotNull DCUserUpdateParameterRequest userUpdateParameterRequest) throws DBException {
        this.executePutRequest("users/parameters", userUpdateParameterRequest, (Type)((Object)Void.class));
    }

    @Override
    public void setUserParameters(@NotNull Map<String, Object> parameters) throws DBException {
        this.executePostRequest("users/parameters", Map.of(), parameters, (Type)((Object)Void.class));
    }

    @Override
    public void setUserCredentials(@NotNull DCUserUpdateCredentialsRequest updateCredentialsRequest) throws DBException {
        this.executePutRequest("users/credentials", updateCredentialsRequest, (Type)((Object)Void.class));
    }

    @Override
    public void setUserCredentials(@NotNull String userId, @NotNull DCUserUpdateCredentialsRequest updateCredentialsRequest) throws DBException {
        String endpointUrl = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "credentials"});
        this.executePutRequest(endpointUrl, updateCredentialsRequest, (Type)((Object)Void.class));
    }

    @Override
    public void deleteUserCredentials(@NotNull String userId, @NotNull String authProviderId) throws DBException {
        String endpointUrl = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "credentials"});
        Map<String, String> queryParams = Map.of("authProviderId", authProviderId);
        this.executeDeleteRequest(endpointUrl, queryParams, (Type)((Object)Void.class));
    }

    public void finishServerConfig(DCFinishEasyConfigRequest request) throws DBException {
        String endpointUrl = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"easy-config", "finish"});
        this.executePostRequest(endpointUrl, request, (Type)((Object)Void.class));
    }

    @Override
    @NotNull
    public Map<String, Object> getUserCredentials(@NotNull String userId, @NotNull String authProviderId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "credentials"});
        return this.getUserCredentials(url, Map.of("authProviderId", authProviderId));
    }

    @Override
    public Map<String, Object> getUserCredentials(@NotNull String authProviderId) throws DBException {
        Map<String, String> queryParams = Map.of("authProviderId", authProviderId);
        return this.getUserCredentials("users/credentials", queryParams);
    }

    private Map<String, Object> getUserCredentials(String url, Map<String, String> queryParams) throws DBException {
        return (Map)this.executeGetRequest(url, queryParams, new TypeToken<HashMap<String, Object>>(){}.getType());
    }

    @Override
    public String[] getUserLinkedProviders() throws DBException {
        return (String[])this.executeGetRequest("users/providers", (Type)((Object)String[].class));
    }

    @Override
    @NotNull
    public SMPropertyDescriptor[] getMetaParametersBySubjectType(@NotNull SMSubjectType subjectType) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/subjects", "metaParameters"});
        Map<String, SMSubjectType> queryParams = Map.of("subjectType", subjectType);
        return (SMPropertyDescriptor[])this.executeGetRequestVal(url, queryParams, (Type)((Object)SMPropertyDescriptor[].class));
    }

    @Override
    @NotNull
    public String[] getUserLinkedProviders(@NotNull String userId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "providers"});
        return (String[])this.executeGetRequestVal(url, (Type)((Object)String[].class));
    }

    @Override
    @NotNull
    public Set<String> getUserPermissions(@NotNull String userId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"users", userId, "permissions"});
        return (Set)this.executeGetRequestVal(url, TypeToken.getParameterized(HashSet.class, (Type[])new Type[]{String.class}).getType());
    }

    @Override
    public void updateUserMeta(@NotNull String userId, @NotNull Map<String, String> metaParameters) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "meta"});
        this.executePutRequest(url, Map.of(), metaParameters, (Type)((Object)Void.class));
    }

    @Override
    public void enableUser(@NotNull String userId, @NotNull DCEnableUserUpdateRequest userIsEnabledUpdateRequest) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "enable"});
        this.executePutRequest(url, userIsEnabledUpdateRequest, (Type)((Object)Void.class));
    }

    @Override
    public void updateUserAuthRole(@NotNull String userId, @NotNull DCUserAuthRoleUpdateRequest request) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "authRole"});
        this.executePutRequest(url, request, (Type)((Object)Void.class));
    }

    @Override
    public SMTeam[] getAllTeams() throws DBException {
        return (SMTeam[])this.executeGetRequest("admin/teams", (Type)((Object)SMTeam[].class));
    }

    @Override
    public SMTeam createTeam(DCTeamCreateRequest teamCreateRequest) throws DBException {
        return (SMTeam)this.executePostRequest("admin/teams", teamCreateRequest, (Type)((Object)SMTeam.class));
    }

    @Override
    public void updateTeam(String teamId, DCTeamUpdateRequest teamUpdateRequest) throws DBException {
        this.executePutRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/teams", teamId}), teamUpdateRequest, (Type)((Object)Void.class));
    }

    @Override
    @NotNull
    public String[] getTeamMembers(@NotNull String teamId) throws DBException {
        String url = SMClientUtils.isServerLegacy((SMServerAPI)this.serverAPI, (String)"24.0.4") ? DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/teams", teamId, "subjects"}) : DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"users", "teams", teamId, "members"});
        return (String[])this.executeGetRequestVal(url, (Type)((Object)String[].class));
    }

    @Override
    @NotNull
    public List<SMTeamMemberInfo> getTeamMembersInfo(@NotNull String teamId) throws DBException {
        return (List)this.executeGetRequestVal(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/teams", teamId, "members"}), TypeToken.getParameterized(List.class, (Type[])new Type[]{SMTeamMemberInfo.class}).getType());
    }

    @Override
    public void setUserTeamRole(@NotNull String userId, @NotNull String teamId, @Nullable String teamRole) throws DBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        if (teamRole != null) {
            params.put("teamRole", teamRole);
        }
        this.executePutRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/teams", teamId, "role"}), params, (Type)((Object)Void.class));
    }

    @Override
    public boolean hasAccessToUsers(@NotNull String teamRole, @NotNull Set<String> userIds) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"users", "access"});
        Map<String, String> params = Map.of("teamRole", teamRole);
        return (Boolean)this.executePostRequestVal(url, params, userIds, (Type)((Object)Boolean.class));
    }

    @Override
    @Nullable
    public SMTeam findTeam(@NotNull String teamId) throws DBException {
        return (SMTeam)this.executeGetRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/teams", teamId}), (Type)((Object)SMTeam.class));
    }

    @Override
    public void deleteTeam(@NotNull String teamId, boolean force) throws DBException {
        this.executeDeleteRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/teams", teamId}), Map.of("force", force), (Type)((Object)Void.class));
    }

    @Override
    public void updateSession(@NotNull String sessionId, @NotNull DCSessionUpdateRequest sessionUpdateRequest) throws DBException {
        this.executePutRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"sessions", sessionId}), sessionUpdateRequest, (Type)((Object)Void.class));
    }

    @Override
    public boolean isSessionPersisted(@NotNull String sessionId) throws DBException {
        return (Boolean)this.executeGetRequestVal(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"sessions", sessionId, "persistence"}), (Type)((Object)Boolean.class));
    }

    @Override
    public void setSubjectPermissions(@NotNull String subjectId, @NotNull DCSubjectUpdatePermissionsRequest subjectUpdatePermissionsRequest) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/subjects", subjectId, "permissions"});
        this.executePutRequest(url, subjectUpdatePermissionsRequest, (Type)((Object)Void.class));
    }

    @Override
    public void setGlobalSubjectPermissions(@NotNull String subjectId, @NotNull List<SMGlobalPermission> permissions, @NotNull String grantorId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/subjects", subjectId, "permissions/global"});
        Map<String, String> parameters = Map.of("grantorId", grantorId);
        this.executePutRequest(url, parameters, permissions, (Type)((Object)Void.class));
    }

    @Override
    public void setGlobalDefaultPermissions(@NotNull List<SMGlobalPermission> permissions, @NotNull String grantorId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/subjects", "permissions/global"});
        Map<String, String> parameters = Map.of("grantorId", grantorId);
        this.executePutRequest(url, parameters, permissions, (Type)((Object)Void.class));
    }

    @Override
    @NotNull
    public List<SMGlobalPermission> getGlobalDefaultPermissions() throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/subjects", "permissions/global"});
        return (List)this.executeGetRequestVal(url, TypeToken.getParameterized(List.class, (Type[])new Type[]{SMGlobalPermission.class}).getType());
    }

    @Override
    @NotNull
    public List<SMGlobalPermissionGrant> getGrantedGlobalPermissions(@NotNull String subjectId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/subjects", subjectId, "permissions/global/grants"});
        return (List)this.executeGetRequestVal(url, TypeToken.getParameterized(List.class, (Type[])new Type[]{SMGlobalPermissionGrant.class}).getType());
    }

    @Override
    @NotNull
    public Set<String> getSubjectPermissions(String subjectId) throws DBException {
        String url = DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"subjects", subjectId, "permissions"});
        return (Set)this.executeGetRequestVal(url, TypeToken.getParameterized(HashSet.class, (Type[])new Type[]{String.class}).getType());
    }

    @Override
    @NotNull
    public List<SMObjectPermissionsGrant> getObjectPermissionGrants(@NotNull String objectId, @NotNull SMObjectType objectType) throws DBException {
        Map<String, SMObjectType> queryParams = Map.of("objectType", objectType);
        return (List)this.executeGetRequestVal(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"objects", objectId, "grants"}), queryParams, TypeToken.getParameterized(List.class, (Type[])new Type[]{SMObjectPermissionsGrant.class}).getType());
    }

    @Override
    public void deleteAllObjectPermissions(@NotNull String objectId, @NotNull SMObjectType objectType) throws DBException {
        Map<String, SMObjectType> queryParams = Map.of("objectType", objectType);
        this.executeDeleteRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"objects", objectId}), queryParams, (Type)((Object)Void.class));
    }

    @Override
    public boolean validateObjectAccess(@NotNull String projectId, @NotNull String objectId, @NotNull SMObjectType objectType) throws DBException {
        Map<String, SMObjectType> queryParams = Map.of("projectId", projectId, "objectType", objectType);
        return (Boolean)this.executeGetRequestVal(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"objects", objectId, "validate"}), queryParams, (Type)((Object)Boolean.class));
    }

    @Override
    @NotNull
    public Map<String, Object> getObjectSettings(@NotNull String objectId, @NotNull SMObjectType objectType, @Nullable String settingId) throws DBException {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("objectType", objectType);
        if (settingId != null) {
            queryParams.put("settingId", settingId);
        }
        return (Map)this.executeGetRequestVal(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"objects", objectId, "settings"}), queryParams, new TypeToken<HashMap<String, Object>>(){}.getType());
    }

    @Override
    public void setObjectSettings(@NotNull DCObjectsSettingsAddRequest request) throws DBException {
        this.executePostRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"objects", "settings"}), request, (Type)((Object)Void.class));
    }

    @Override
    public void deleteObjectSettings(@NotNull String objectId, @NotNull SMObjectType objectType, @Nullable Set<String> settingIds) throws DBException {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("objectType", objectType);
        if (settingIds != null) {
            queryParams.put("settingIds", settingIds);
        }
        this.executeDeleteRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"objects", objectId, "settings"}), queryParams, (Type)((Object)Void.class));
    }

    @Override
    public void deleteAllSubjectObjectPermissions(@NotNull String subjectId, @NotNull SMObjectType objectType) throws DBException {
        Map<String, SMObjectType> queryParams = Map.of("subjectId", subjectId, "objectType", objectType);
        this.executeDeleteRequest("admin/objects/grants", queryParams, (Type)((Object)Void.class));
    }

    @Override
    public List<SMObjectPermissionsGrant> getSubjectObjectPermissionGrants(@NotNull String subjectId, @NotNull SMObjectType objectType) throws DBException {
        Map<String, SMObjectType> queryParams = Map.of("subjectId", subjectId, "objectType", objectType);
        return (List)this.executeGetRequest("admin/objects/grants", queryParams, TypeToken.getParameterized(List.class, (Type[])new Type[]{SMObjectPermissionsGrant.class}).getType());
    }

    @Override
    public void deleteObjectPermissions(@NotNull Set<String> objectIds, @NotNull SMObjectType objectType, @NotNull Set<String> subjectIds, @NotNull Set<String> permissions) throws DBException {
        Map<String, Set<String>> queryParams = Map.of("objectIds", objectIds, "objectType", objectType, "subjectIds", subjectIds, "permissions", permissions);
        this.executeDeleteRequest("admin/objects", queryParams, (Type)((Object)Void.class));
    }

    @Override
    public void addObjectPermissions(@NotNull Set<String> objectIds, @NotNull SMObjectType objectType, @NotNull Set<String> subjectIds, @NotNull Set<String> permissions) throws DBException {
        Map<String, Set<String>> queryParams = Map.of("objectIds", objectIds, "objectType", objectType, "subjectIds", subjectIds, "permissions", permissions);
        this.executePostRequest("admin/objects", queryParams, (Type)((Object)Void.class));
    }

    @Override
    @NotNull
    public SMObjectPermissions getObjectPermissions(@NotNull String subjectId, @NotNull String objectId, @NotNull SMObjectType objectType) throws DBException {
        Map<String, SMObjectType> queryParams = Map.of("subjectId", subjectId, "objectType", objectType);
        return (SMObjectPermissions)this.executeGetRequestVal(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"objects", objectId}), queryParams, (Type)((Object)SMObjectPermissions.class));
    }

    @Override
    public void setObjectPermissions(@NotNull DCObjectsUpdatePermissionsRequest request) throws DBException {
        this.executePostRequest("objects", request, (Type)((Object)Void.class));
    }

    @Override
    public List<SMObjectPermissions> getAllAvailableObjectsPermissions(@NotNull SMObjectType objectType) throws DBException {
        Map<String, SMObjectType> queryParams = Map.of("objectType", objectType);
        TypeToken parameterized = TypeToken.getParameterized(List.class, (Type[])new Type[]{SMObjectPermissions.class});
        return (List)this.executeGetRequest("objects", queryParams, parameterized.getType());
    }

    @Override
    public List<SMAPIToken> getAPITokens() throws DBException {
        TypeToken parameterized = TypeToken.getParameterized(List.class, (Type[])new Type[]{SMAPIToken.class});
        return (List)this.executeGetRequest("users/tokens", parameterized.getType());
    }

    @Override
    public SMAPIToken createAPIToken(@NotNull DCCreateAPITokenRequest request) throws DBException {
        return (SMAPIToken)this.executePutRequest("users/tokens", Map.of(), request, (Type)((Object)SMAPIToken.class));
    }

    @Override
    public void blockUserByBruteForceProtection(@NotNull String userId) throws DBException {
        this.executePostRequest(DCSecurityControllerClient.buildEndpointUrl((String[])new String[]{"admin/users", userId, "bruteForceDisable"}), Map.of(), (Type)((Object)Void.class));
    }

    @Override
    public void deleteAPIToken(@NotNull String tokenName) throws DBException {
        this.executeDeleteRequest("users/tokens", Map.of("tokenName", tokenName), (Type)((Object)Void.class));
    }

    @Override
    public void lockSubjectByBruteForceProtection(@NotNull String projectId, @NotNull String objectId, @NotNull SMObjectType objectType, @NotNull String subjectId) throws DBException {
        this.executePostRequest("admin/objects/lock", Map.of("projectId", projectId, "objectId", objectId, "objectType", objectType, "subjectId", subjectId), (Type)((Object)Void.class));
    }

    private static List<Interceptor> getInterceptors(DCClientConfiguration dcClientConfiguration) {
        if (dcClientConfiguration.isUseCertificate()) {
            return List.of(new DCAuthInterceptor(dcClientConfiguration.getRefreshSMSessionFunction(), dcClientConfiguration.getCredentialsProvider()), new DCUserAgentInterceptor(), new DCTrustedServiceInterceptor(dcClientConfiguration.getDcCertificate()));
        }
        return List.of(new DCAuthInterceptor(dcClientConfiguration.getRefreshSMSessionFunction(), dcClientConfiguration.getCredentialsProvider()), new DCUserAgentInterceptor());
    }
}

