/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc.internal;

import com.dbeaver.model.DBDCSecretControllerClient;
import com.dbeaver.model.auth.SMClientUtils;
import com.dbeaver.model.auth.SMServerAPI;
import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.BodyConverter;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.json.DCClientUtils;
import com.dbeaver.remote.client.interceptor.DCAuthInterceptor;
import com.dbeaver.remote.client.interceptor.DCTrustedServiceInterceptor;
import com.dbeaver.remote.client.interceptor.DCUserAgentInterceptor;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Interceptor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.secret.DBSSecretObject;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.utils.CommonUtils;

public class DCSecretControllerClient
extends AbstractRemoteClient
implements DBSSecretController,
DBDCSecretControllerClient {
    public static final Type MAP_STRING_STRING = new TypeToken<Map<String, String>>(){}.getType();
    private final SMServerAPI serverAPI;

    public DCSecretControllerClient(DCClientConfiguration dcClientConfiguration) {
        super(dcClientConfiguration.getApiUrl(), DCSecretControllerClient.getInterceptors(dcClientConfiguration));
        this.gson = DCClientUtils.buildDCGson();
        this.serverAPI = dcClientConfiguration.getServerAPI();
    }

    private static List<Interceptor> getInterceptors(DCClientConfiguration dcClientConfiguration) {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        interceptors.add((Interceptor)new DCAuthInterceptor(dcClientConfiguration.getRefreshSMSessionFunction(), dcClientConfiguration.getCredentialsProvider()));
        interceptors.add((Interceptor)new DCUserAgentInterceptor());
        if (dcClientConfiguration.isUseCertificate()) {
            interceptors.add((Interceptor)new DCTrustedServiceInterceptor(dcClientConfiguration.getDcCertificate()));
        }
        return interceptors;
    }

    @NotNull
    public List<DBSSecretValue> discoverCurrentUserSecrets(@NotNull DBSSecretObject secretObject) throws DBException {
        if (SMClientUtils.isServerLegacy((SMServerAPI)this.serverAPI, (String)"23.3.5")) {
            return List.of();
        }
        return (List)this.executePostRequestVal(DCSecretControllerClient.buildEndpointUrl((String[])new String[]{"secrets", "shared/discover"}), secretObject, TypeToken.getParameterized(List.class, (Type[])new Type[]{DBSSecretValue.class}).getType());
    }

    @NotNull
    public List<DBSSecretValue> listAllSharedSecrets(@NotNull DBSSecretObject secretObject) throws DBException {
        if (SMClientUtils.isServerLegacy((SMServerAPI)this.serverAPI, (String)"23.3.5")) {
            return List.of();
        }
        return (List)this.executePostRequestVal(DCSecretControllerClient.buildEndpointUrl((String[])new String[]{"secrets", "shared/all"}), secretObject, TypeToken.getParameterized(List.class, (Type[])new Type[]{DBSSecretValue.class}).getType());
    }

    public void setSubjectSecretValue(@NotNull String subjectId, @NotNull DBSSecretObject secretObject, @NotNull DBSSecretValue secretValue) throws DBException {
        LinkedHashMap requestParams = new LinkedHashMap((Map)this.gson.fromJson(this.gson.toJson((Object)secretObject), MAP_STRING_STRING));
        this.executePostRequest(DCSecretControllerClient.buildEndpointUrl((String[])new String[]{"secrets/shared", subjectId}), requestParams, secretValue, Void.TYPE);
    }

    @Nullable
    public String getPrivateSecretValue(@NotNull String secretId) throws DBException {
        String url = DCSecretControllerClient.buildEndpointUrl((String[])new String[]{"secrets", "value"});
        String secretIValue = (String)this.executeGetRequest(url, Map.of("secretId", secretId), (Type)((Object)String.class));
        if (CommonUtils.isEmpty((String)secretIValue)) {
            return null;
        }
        return secretIValue;
    }

    public void setPrivateSecretValue(@NotNull String secretId, @Nullable String secretValue) throws DBException {
        String url = DCSecretControllerClient.buildEndpointUrl((String[])new String[]{"secrets", "value"});
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("secretId", secretId);
        this.executePutRequest(url, params, CommonUtils.notEmpty((String)secretValue), BodyConverter.TEXT_PLAIN, (Type)((Object)String.class));
    }

    public void setPrivateSecretValue(@NotNull DBSSecretObject secretObject, @NotNull DBSSecretValue secretValue) throws DBException {
        if (SMClientUtils.isServerLegacy((SMServerAPI)this.serverAPI, (String)"23.3.4")) {
            this.setPrivateSecretValue(secretValue.getId(), secretValue.getValue());
            return;
        }
        LinkedHashMap requestParams = new LinkedHashMap((Map)this.gson.fromJson(this.gson.toJson((Object)secretObject), MAP_STRING_STRING));
        this.executePostRequest(DCSecretControllerClient.buildEndpointUrl((String[])new String[]{"secrets", "value"}), requestParams, secretValue, (Type)((Object)Void.class));
    }

    public void flushChanges() throws DBException {
    }

    public void deleteProjectSecrets(@NotNull String projectId) throws DBException {
        if (SMClientUtils.isServerLegacy((SMServerAPI)this.serverAPI, (String)"23.3.5")) {
            return;
        }
        Map<String, String> params = Map.of("projectId", projectId);
        this.executeDeleteRequest(DCSecretControllerClient.buildEndpointUrl((String[])new String[]{"secrets", "shared/projects"}), params, (Type)((Object)Void.class));
    }

    public void deleteSubjectSecrets(@NotNull String subjectId) throws DBException {
        if (SMClientUtils.isServerLegacy((SMServerAPI)this.serverAPI, (String)"23.3.5")) {
            return;
        }
        Map<String, String> params = Map.of("subjectId", subjectId);
        this.executeDeleteRequest(DCSecretControllerClient.buildEndpointUrl((String[])new String[]{"secrets", "shared/subjects"}), params, (Type)((Object)Void.class));
    }

    public void deleteObjectSecrets(@NotNull DBSSecretObject secretObject) throws DBException {
        if (SMClientUtils.isServerLegacy((SMServerAPI)this.serverAPI, (String)"23.3.5")) {
            return;
        }
        this.executePostRequest(DCSecretControllerClient.buildEndpointUrl((String[])new String[]{"secrets", "shared/all/delete"}), secretObject, Void.TYPE);
    }
}

