/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc.internal;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.model.DCLicenseService;
import com.dbeaver.remote.client.dc.model.license.DCLicense;
import com.dbeaver.remote.client.dc.model.license.DCLicenseImportRequest;
import com.dbeaver.remote.client.interceptor.ApplicationInstanceInterceptor;
import com.dbeaver.remote.client.interceptor.DCAuthInterceptor;
import com.dbeaver.remote.client.interceptor.DCTrustedServiceInterceptor;
import com.dbeaver.remote.client.interceptor.DCUserAgentInterceptor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class DCLicenseClient
extends AbstractRemoteClient
implements DCLicenseService {
    private static final String LICENSES = "licenses";

    public DCLicenseClient(DCClientConfiguration dcClientConfiguration) {
        super(dcClientConfiguration.getApiUrl(), List.of(new DCTrustedServiceInterceptor(dcClientConfiguration.getDcCertificate()), new DCAuthInterceptor(dcClientConfiguration.getRefreshSMSessionFunction(), dcClientConfiguration.getCredentialsProvider()), new DCUserAgentInterceptor(), new ApplicationInstanceInterceptor(dcClientConfiguration.getApplicationId())));
    }

    @Override
    public DCLicense getActiveProductLicense(boolean validate) throws LMException {
        try {
            String url = DCLicenseClient.buildEndpointUrl((String[])new String[]{LICENSES, "active"});
            return (DCLicense)this.executeGetRequest(url, Map.of("validate", validate), (Type)((Object)DCLicense.class));
        }
        catch (Exception e) {
            throw new LMException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getActiveEncodedLicense() throws LMException {
        try {
            String url = DCLicenseClient.buildEndpointUrl((String[])new String[]{LICENSES, "encoded"});
            return (String)this.executeGetRequest(url, Map.of(), (Type)((Object)String.class));
        }
        catch (Exception e) {
            throw new LMException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NotNull
    public DCLicense[] getAllProductLicenses() throws LMException {
        try {
            return (DCLicense[])this.executeGetRequestVal(LICENSES, (Type)((Object)DCLicense[].class));
        }
        catch (Exception e) {
            throw new LMException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @NotNull
    public DCLicense importProductLicense(@NotNull DCLicenseImportRequest request) throws LMException {
        try {
            return (DCLicense)this.executePostRequestVal(LICENSES, request, (Type)((Object)DCLicense.class));
        }
        catch (Exception e) {
            throw new LMException("Error importing license", (Throwable)e);
        }
    }

    @Override
    public boolean invalidateLicense() throws LMException {
        try {
            String url = DCLicenseClient.buildEndpointUrl((String[])new String[]{LICENSES, "invalidate"});
            return (Boolean)this.executeGetRequestVal(url, (Type)((Object)Boolean.class));
        }
        catch (Exception e) {
            throw new LMException("Error reading active license status", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public String getActiveLicenseStatus() throws LMException {
        try {
            String url = DCLicenseClient.buildEndpointUrl((String[])new String[]{LICENSES, "status"});
            return (String)this.executeGetRequest(url, (Type)((Object)String.class));
        }
        catch (Exception e) {
            throw new LMException("Error invalidating license", (Throwable)e);
        }
    }

    public LMProduct getActiveProduct() throws LMException {
        try {
            String url = DCLicenseClient.buildEndpointUrl((String[])new String[]{LICENSES, "product"});
            return (LMProduct)this.executeGetRequest(url, (Type)((Object)LMProduct.class));
        }
        catch (Exception e) {
            throw new LMException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void deleteLicense(@NotNull String licenseId) throws LMException {
        try {
            this.executeDeleteRequest(LICENSES, Map.of("licenseId", licenseId), (Type)((Object)Void.class));
        }
        catch (Exception e) {
            throw new LMException(e.getMessage(), (Throwable)e);
        }
    }
}

