/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc;

import com.dbeaver.model.auth.SMAPIToken;
import com.dbeaver.model.auth.SMAPITokenController;
import com.dbeaver.model.auth.SMClientUtils;
import com.dbeaver.model.auth.SMControllerRemote;
import com.dbeaver.model.auth.SMInternalProcessController;
import com.dbeaver.model.auth.SMServerAPI;
import com.dbeaver.model.security.SMConnectBruteForceValidator;
import com.dbeaver.model.sm.SMAdminControllerPro;
import com.dbeaver.model.sm.permissions.SMGlobalPermission;
import com.dbeaver.model.sm.permissions.SMGlobalPermissionGrant;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.internal.DCAuthClient;
import com.dbeaver.remote.client.dc.internal.DCSecurityControllerClient;
import com.dbeaver.remote.client.dc.model.DCEasyConfigService;
import com.dbeaver.remote.client.dc.model.DCFinishEasyConfigRequest;
import com.dbeaver.remote.client.dc.model.objects.DCObjectsSettingsAddRequest;
import com.dbeaver.remote.client.dc.model.objects.DCObjectsUpdatePermissionsRequest;
import com.dbeaver.remote.client.dc.model.session.DCSessionAuthRequest;
import com.dbeaver.remote.client.dc.model.session.DCSessionUpdateRequest;
import com.dbeaver.remote.client.dc.model.subjects.DCSubjectUpdatePermissionsRequest;
import com.dbeaver.remote.client.dc.model.team.DCTeamCreateRequest;
import com.dbeaver.remote.client.dc.model.team.DCTeamUpdateRequest;
import com.dbeaver.remote.client.dc.model.user.DCCreateAPITokenRequest;
import com.dbeaver.remote.client.dc.model.user.DCEnableUserUpdateRequest;
import com.dbeaver.remote.client.dc.model.user.DCUserAuthRoleUpdateRequest;
import com.dbeaver.remote.client.dc.model.user.DCUserCreateRequest;
import com.dbeaver.remote.client.dc.model.user.DCUserTeamsUpdateRequest;
import com.dbeaver.remote.client.dc.model.user.DCUserUpdateCredentialsRequest;
import com.dbeaver.remote.client.dc.model.user.DCUserUpdateParameterRequest;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPConnectionInformation;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMCredentials;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMSessionType;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.security.SMAuthProviderDescriptor;
import org.jkiss.dbeaver.model.security.SMObjectPermissionsGrant;
import org.jkiss.dbeaver.model.security.SMObjectType;
import org.jkiss.dbeaver.model.security.SMPropertyDescriptor;
import org.jkiss.dbeaver.model.security.SMSubjectType;
import org.jkiss.dbeaver.model.security.SMTeamMemberInfo;
import org.jkiss.dbeaver.model.security.SMTokens;
import org.jkiss.dbeaver.model.security.exception.SMException;
import org.jkiss.dbeaver.model.security.user.SMAuthPermissions;
import org.jkiss.dbeaver.model.security.user.SMObjectPermissions;
import org.jkiss.dbeaver.model.security.user.SMTeam;
import org.jkiss.dbeaver.model.security.user.SMUser;
import org.jkiss.dbeaver.model.security.user.SMUserFilter;
import org.jkiss.dbeaver.model.security.user.SMUserImportList;
import org.jkiss.dbeaver.model.security.user.SMUserTeam;

public class DCRemoteSecurityController
implements SMAdminControllerPro,
SMControllerRemote,
DCEasyConfigService,
SMAPITokenController,
SMInternalProcessController,
SMConnectBruteForceValidator {
    private static final Cache<String, SMAuthPermissions> tokenPermissionsCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Cache<String, SMObjectPermissions> objectPermissionsCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final DCSecurityControllerClient dcClient;
    private final DCAuthClient dcAuthClient;
    private final SMCredentialsProvider credentialsProvider;
    private final SMServerAPI serverAPI;

    public DCRemoteSecurityController(DCClientConfiguration dcClientConfiguration) {
        this.dcClient = new DCSecurityControllerClient(dcClientConfiguration);
        this.dcAuthClient = new DCAuthClient(dcClientConfiguration);
        this.credentialsProvider = dcClientConfiguration.getCredentialsProvider();
        this.serverAPI = dcClientConfiguration.getServerAPI();
    }

    public Map<String, Object> getUserCredentials(String userId, String authProviderId) throws DBException {
        return this.dcClient.getUserCredentials(userId, authProviderId);
    }

    @NotNull
    public Map<String, Object> getCurrentUserCredentials(@NotNull String authProviderId) throws DBException {
        return this.dcClient.getUserCredentials(authProviderId);
    }

    public void createUser(@NotNull String userId, @NotNull Map<String, String> metaParameters, boolean enabled, String authRole) throws DBException {
        this.dcClient.createUser(DCUserCreateRequest.builder(userId, metaParameters, authRole).setEnabled(enabled).build());
    }

    public void importUsers(@NotNull SMUserImportList userImportList) throws DBException {
        this.dcClient.importUsers(userImportList);
    }

    public void deleteUser(String userId) throws DBException {
        this.dcClient.deleteUser(userId);
    }

    public void invalidateAllTokens() throws DBException {
        this.dcClient.invalidateAllTokens();
    }

    public void setUserTeams(String userId, String[] teamIds, String grantorId) throws DBException {
        this.dcClient.updateUserTeams(userId, DCUserTeamsUpdateRequest.builder().setTeamIds(Arrays.asList(teamIds)).build());
    }

    public void addUserTeams(@NotNull String userId, @NotNull String[] teamIds, @NotNull String grantorId) throws DBException {
        this.dcClient.addUserTeams(userId, teamIds, grantorId);
    }

    public void deleteUserTeams(@NotNull String userId, @NotNull String[] teamIds) throws DBException {
        this.dcClient.deleteUserTeams(userId, teamIds);
    }

    public void setUserTeamRole(@NotNull String userId, @NotNull String teamId, @Nullable String teamRole) throws DBException {
        this.dcClient.setUserTeamRole(userId, teamId, teamRole);
    }

    @NotNull
    public SMUserTeam[] getUserTeams(String userId) throws DBException {
        return this.dcClient.getUserTeams(userId);
    }

    @NotNull
    public SMUserTeam[] getCurrentUserTeams() throws DBException {
        return this.dcClient.getUserTeams();
    }

    @NotNull
    public SMUser getCurrentUser() throws DBException {
        return this.dcClient.getCurrentUser();
    }

    public SMUser getUserById(String userId) throws DBException {
        return this.dcClient.getUserById(userId);
    }

    @NotNull
    public Map<String, Object> getCurrentUserParameters() throws DBException {
        return this.dcClient.getUserParameters();
    }

    public void setCurrentUserParameter(@NotNull String name, Object value) throws DBException {
        this.dcClient.setUserParameter(DCUserUpdateParameterRequest.builder().setName(name).setValue(value).build());
    }

    public void setCurrentUserParameters(@NotNull Map<String, Object> parameters) throws DBException {
        this.dcClient.setUserParameters(parameters);
    }

    public void enableUser(@NotNull String userId, boolean enabled, @Nullable String disabledBy, @Nullable String disableReason) throws DBException {
        this.dcClient.enableUser(userId, DCEnableUserUpdateRequest.builder(enabled).disabledBy(disabledBy).disableReason(disableReason).build());
    }

    public void setUserAuthRole(@NotNull String userId, @Nullable String authRole) throws DBException {
        Objects.requireNonNull(authRole, "auth role is null");
        this.dcClient.updateUserAuthRole(userId, new DCUserAuthRoleUpdateRequest(authRole));
    }

    public void setCurrentUserCredentials(@NotNull String authProviderId, @NotNull Map<String, Object> credentials) throws DBException {
        this.dcClient.setUserCredentials(DCUserUpdateCredentialsRequest.builder(authProviderId).setCredentials(credentials).build());
    }

    public void setUserCredentials(@NotNull String userId, @NotNull String authProviderId, @NotNull Map<String, Object> credentials) throws DBException {
        this.dcClient.setUserCredentials(userId, DCUserUpdateCredentialsRequest.builder(authProviderId).setCredentials(credentials).build());
    }

    public void deleteUserCredentials(@NotNull String userId, @NotNull String authProviderId) throws DBException {
        this.dcClient.deleteUserCredentials(userId, authProviderId);
    }

    @NotNull
    public String[] getCurrentUserLinkedProviders() throws DBException {
        return this.dcClient.getUserLinkedProviders();
    }

    public String[] getUserLinkedProviders(@NotNull String userId) throws DBException {
        return this.dcClient.getUserLinkedProviders(userId);
    }

    @NotNull
    public SMPropertyDescriptor[] getMetaParametersBySubjectType(SMSubjectType subjectType) throws DBException {
        return this.dcClient.getMetaParametersBySubjectType(subjectType);
    }

    @NotNull
    public Set<String> getUserPermissions(String userId) throws DBException {
        return this.dcClient.getUserPermissions(userId);
    }

    public boolean isSessionPersisted(@NotNull String id) throws DBException {
        return this.dcClient.isSessionPersisted(id);
    }

    @NotNull
    public SMAuthInfo authenticateAnonymousUser(@NotNull String appSessionId, @NotNull Map<String, Object> sessionParameters, @NotNull SMSessionType sessionType) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    @NotNull
    public SMAuthInfo getAuthStatus(@NotNull String authId) throws DBException {
        return this.dcAuthClient.getAuthStatus(authId);
    }

    @Nullable
    public SMAuthInfo restoreUserSession(@NotNull String appSessionId) throws DBException {
        return this.dcAuthClient.restoreUserSession(appSessionId);
    }

    public void logout() throws DBException {
        this.dcAuthClient.logout();
    }

    public SMTokens refreshSession(@NotNull String refreshToken) throws DBException {
        return this.dcAuthClient.refreshSession(refreshToken);
    }

    @NotNull
    public SMAuthInfo authenticate(@NotNull String appSessionId, @Nullable String previousSmSessionId, @NotNull Map<String, Object> sessionParameters, @NotNull SMSessionType sessionType, @NotNull String authProviderId, @Nullable String authProviderConfigurationId, @NotNull Map<String, Object> userCredentials, boolean forceSessionsLogout) throws DBException {
        return this.dcAuthClient.authenticate(DCSessionAuthRequest.builder(appSessionId).setSessionParameters(sessionParameters).setSessionType(sessionType).setAuthProviderId(authProviderId).setAuthProviderConfigurationId(authProviderConfigurationId).setUserCredentials(userCredentials).setPreviousSmSessionId(previousSmSessionId).setForceSessionsLogout(forceSessionsLogout).build());
    }

    public void updateSession(@NotNull String sessionId, Map<String, Object> parameters) throws DBException {
        this.dcClient.updateSession(sessionId, DCSessionUpdateRequest.builder().setParameters(parameters).build());
    }

    public void setSubjectPermissions(String subjectId, List<String> permissionIds, String grantorId) throws DBException {
        this.dcClient.setSubjectPermissions(subjectId, DCSubjectUpdatePermissionsRequest.builder().setPermissionIds(permissionIds).build());
    }

    public void setGlobalSubjectPermissions(@NotNull String subjectId, @NotNull List<SMGlobalPermission> permissions, @NotNull String grantorId) throws DBException {
        this.dcClient.setGlobalSubjectPermissions(subjectId, permissions, grantorId);
    }

    @NotNull
    public List<SMGlobalPermissionGrant> getGrantedGlobalPermissions(@NotNull String subjectId) throws DBException {
        return this.dcClient.getGrantedGlobalPermissions(subjectId);
    }

    public void setGlobalDefaultPermissions(@NotNull List<SMGlobalPermission> permissions, @NotNull String grantorId) throws DBException {
        this.dcClient.setGlobalDefaultPermissions(permissions, grantorId);
    }

    @NotNull
    public List<SMGlobalPermission> getGlobalDefaultPermissions() throws DBException {
        return this.dcClient.getGlobalDefaultPermissions();
    }

    public void setObjectPermissions(@NotNull Set<String> objectIds, @NotNull SMObjectType objectType, @NotNull Set<String> subjectIds, @NotNull Set<String> permissions, @NotNull String grantor) throws DBException {
        this.dcClient.setObjectPermissions(DCObjectsUpdatePermissionsRequest.builder(objectType).setObjectIds(objectIds).setSubjectIds(subjectIds).setPermissions(permissions).build());
    }

    public void deleteAllObjectPermissions(@NotNull String objectId, @NotNull SMObjectType objectType) throws DBException {
        this.dcClient.deleteAllObjectPermissions(objectId, objectType);
    }

    public boolean hasAccessToUsers(@NotNull String teamRole, @NotNull Set<String> userIds) throws DBException {
        return this.dcClient.hasAccessToUsers(teamRole, userIds);
    }

    public void deleteAllSubjectObjectPermissions(@NotNull String subjectId, @NotNull SMObjectType objectType) throws DBException {
        this.dcClient.deleteAllSubjectObjectPermissions(subjectId, objectType);
    }

    @NotNull
    public SMObjectPermissions getObjectPermissions(@NotNull String subjectId, @NotNull String objectId, @NotNull SMObjectType objectType) throws DBException {
        try {
            String cacheKey = String.join((CharSequence)"_", List.of(subjectId, objectId, objectType.name(), this.credentialsProvider.getActiveUserCredentials() == null ? "" : this.credentialsProvider.getActiveUserCredentials().getSmAccessToken()));
            return (SMObjectPermissions)objectPermissionsCache.get((Object)cacheKey, () -> this.dcClient.getObjectPermissions(subjectId, objectId, objectType));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DBException) {
                throw (DBException)e.getCause();
            }
            throw new DBException("Error during permission read", (Throwable)e);
        }
    }

    @NotNull
    public List<SMObjectPermissionsGrant> getObjectPermissionGrants(@NotNull String objectId, @NotNull SMObjectType smObjectType) throws DBException {
        return this.dcClient.getObjectPermissionGrants(objectId, smObjectType);
    }

    public List<SMObjectPermissionsGrant> getSubjectObjectPermissionGrants(@NotNull String subjectId, @NotNull SMObjectType smObjectType) throws DBException {
        return this.dcClient.getSubjectObjectPermissionGrants(subjectId, smObjectType);
    }

    public void addObjectPermissions(@NotNull Set<String> objectIds, @NotNull SMObjectType objectType, @NotNull Set<String> subjectIds, @NotNull Set<String> permissions, @NotNull String grantor) throws DBException {
        this.dcClient.addObjectPermissions(objectIds, objectType, subjectIds, permissions);
    }

    public void deleteObjectPermissions(@NotNull Set<String> objectIds, @NotNull SMObjectType objectType, @NotNull Set<String> subjectIds, @NotNull Set<String> permissions) throws DBException {
        this.dcClient.deleteObjectPermissions(objectIds, objectType, subjectIds, permissions);
    }

    @NotNull
    public Map<String, Object> getObjectSettings(@NotNull String objectId, @NotNull SMObjectType objectType, @Nullable String settingId) throws DBException {
        return this.dcClient.getObjectSettings(objectId, objectType, settingId);
    }

    public void setObjectSettings(@NotNull String objectId, @NotNull SMObjectType objectType, @NotNull Map<String, Object> settings) throws DBException {
        this.dcClient.setObjectSettings(new DCObjectsSettingsAddRequest(objectId, objectType, settings));
    }

    public void deleteObjectSettings(@NotNull String objectId, @NotNull SMObjectType objectType, @Nullable Set<String> settingIds) throws DBException {
        this.dcClient.deleteObjectSettings(objectId, objectType, settingIds);
    }

    @NotNull
    public List<SMTeamMemberInfo> getTeamMembersInfo(@NotNull String teamId) throws DBException {
        return this.dcClient.getTeamMembersInfo(teamId);
    }

    @NotNull
    public Set<String> getSubjectPermissions(String subjectId) throws DBException {
        return this.dcClient.getSubjectPermissions(subjectId);
    }

    public SMAuthPermissions getTokenPermissions() throws DBException {
        SMCredentials activeUserCredentials = this.credentialsProvider.getActiveUserCredentials();
        if (activeUserCredentials == null || activeUserCredentials.getSmAccessToken() == null) {
            throw new SMException("User not authenticated");
        }
        try {
            String smToken = activeUserCredentials.getSmAccessToken();
            return (SMAuthPermissions)tokenPermissionsCache.get((Object)smToken, this.dcAuthClient::currentAuthInfo);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DBException) {
                throw (DBException)e.getCause();
            }
            throw new DBException("Error during permission read", (Throwable)e);
        }
    }

    @NotNull
    public SMAuthProviderDescriptor[] getAvailableAuthProviders() throws DBException {
        return this.dcAuthClient.getAvailableAuthProviders();
    }

    @NotNull
    public List<SMObjectPermissions> getAllAvailableObjectsPermissions(@NotNull SMObjectType objectType) throws DBException {
        return this.dcClient.getAllAvailableObjectsPermissions(objectType);
    }

    @NotNull
    public int countUsers(@NotNull SMUserFilter filter) throws DBException {
        return this.dcClient.countUsers(filter);
    }

    @NotNull
    public SMUser[] findUsers(String userNameMask) throws DBException {
        return this.dcClient.findUsers(userNameMask);
    }

    @NotNull
    public SMUser[] findUsers(@NotNull SMUserFilter filter) throws DBException {
        return this.dcClient.findUsers(filter);
    }

    public void setSubjectMetas(@NotNull String subjectId, @NotNull Map<String, String> metaParameters) throws DBException {
        this.dcClient.updateUserMeta(subjectId, metaParameters);
    }

    @NotNull
    public SMTeam[] readAllTeams() throws DBException {
        return this.dcClient.getAllTeams();
    }

    public SMTeam findTeam(String teamId) throws DBException {
        return this.dcClient.findTeam(teamId);
    }

    @NotNull
    public String[] getTeamMembers(String teamId) throws DBException {
        return this.dcClient.getTeamMembers(teamId);
    }

    public SMTeam createTeam(@NotNull String teamId, @Nullable String name, @Nullable String description, @NotNull String grantor) throws DBException {
        return this.dcClient.createTeam(DCTeamCreateRequest.builder(teamId, grantor).setName(name).setDescription(description).build());
    }

    public void updateTeam(@NotNull String teamId, @Nullable String name, @Nullable String description) throws DBException {
        this.dcClient.updateTeam(teamId, DCTeamUpdateRequest.builder().setName(name).setDescription(description).build());
    }

    public void deleteTeam(String teamId, boolean force) throws DBException {
        this.dcClient.deleteTeam(teamId, force);
    }

    public String ping() throws DBException {
        return this.dcAuthClient.ping();
    }

    public SMServerAPI getServerAPI() throws DBException {
        return this.dcAuthClient.getServerAPI();
    }

    @Override
    public void finishSecurityServiceConfiguration(@NotNull DCFinishEasyConfigRequest request) throws DBException {
        this.dcClient.finishServerConfig(request);
    }

    @NotNull
    public List<SMAPIToken> getCurrentUserAPITokens() throws DBException {
        return this.dcClient.getAPITokens();
    }

    @NotNull
    public SMAPIToken createAPIToken(@NotNull String tokenName, @Nullable Integer period) throws DBException {
        return this.dcClient.createAPIToken(new DCCreateAPITokenRequest(tokenName, period));
    }

    public void deleteAPIToken(@NotNull String tokenName) throws DBException {
        this.dcClient.deleteAPIToken(tokenName);
    }

    @NotNull
    public DBPConnectionInformation getInternalDatabaseInformation() throws DBException {
        return this.dcAuthClient.getInternalDatabaseInformation();
    }

    public void blockUserByBruteForceProtection(@NotNull String userId) throws DBException {
        this.dcClient.blockUserByBruteForceProtection(userId);
    }

    public void lockSubjectByBruteForceProtection(@NotNull String projectId, @NotNull String objectId, @NotNull SMObjectType objectType, @NotNull String subjectId) throws DBException {
        if (SMClientUtils.isServerLegacy((SMServerAPI)this.serverAPI, (String)"25.1.4")) {
            return;
        }
        this.dcClient.lockSubjectByBruteForceProtection(projectId, objectId, objectType, subjectId);
    }

    public boolean validateCurrentUserDataSourceConnectErrorAttempts(@NotNull String projectId, @NotNull String dataSourceId) throws DBException {
        if (SMClientUtils.isServerLegacy((SMServerAPI)this.serverAPI, (String)"25.1.4")) {
            return true;
        }
        return this.dcClient.validateObjectAccess(projectId, dataSourceId, SMObjectType.datasource);
    }
}

