/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc;

import com.dbeaver.model.auth.SMServerAPI;
import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.remote.client.AbstractRemoteClientConfiguration;
import com.dbeaver.remote.client.RefreshSMSessionFunction;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;

public class DCClientConfiguration
extends AbstractRemoteClientConfiguration {
    private final boolean useCertificate;
    @Nullable
    private final SMServerAPI serverAPI;

    private DCClientConfiguration(@NotNull String apiUrl, @NotNull SMCredentialsProvider credentialsProvider, @Nullable RefreshSMSessionFunction refreshSMSessionFunction, @Nullable String dcCertificate, @Nullable String applicationId, boolean useCertificate, @Nullable SMServerAPI serverAPI, int initRetryRequestDuration) {
        super(apiUrl, credentialsProvider, refreshSMSessionFunction, dcCertificate, applicationId, initRetryRequestDuration);
        this.useCertificate = useCertificate;
        this.serverAPI = serverAPI;
    }

    public boolean isUseCertificate() {
        return this.useCertificate;
    }

    @Nullable
    public SMServerAPI getServerAPI() {
        return this.serverAPI;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SMSessionRemote sessionRemote) {
        return (Builder)((Builder)((Builder)new Builder().setCredentialsProvider(sessionRemote.getRemoteCredentialsProvider())).setRefreshSMSessionFunction(() -> ((SMCredentialsProvider)sessionRemote.getRemoteCredentialsProvider()).refreshSMSession())).setServerAPI(sessionRemote.getServerApi()).setApiUrl(sessionRemote.getRemoteServiceURL());
    }

    public static final class Builder
    extends AbstractRemoteClientConfiguration.AbstractBuilder<Builder, DCClientConfiguration> {
        private boolean useCertificate = false;
        private SMServerAPI serverAPI = null;

        private Builder() {
        }

        public Builder setUseCertificate(boolean useCertificate) {
            this.useCertificate = useCertificate;
            return this;
        }

        public Builder setServerAPI(@Nullable SMServerAPI serverAPI) {
            this.serverAPI = serverAPI;
            return this;
        }

        public DCClientConfiguration build() {
            return new DCClientConfiguration(this.apiUrl, this.credentialsProvider, this.refreshSMSessionFunction, this.dcCertificate, this.applicationId, this.useCertificate, this.serverAPI, this.initRetryRequestDuration);
        }

        protected Builder getThis() {
            return this;
        }
    }
}

