/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce.meta;

import com.dbeaver.jdbc.salesforce.SalesForceConnection;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.IDescribeSObjectResult;
import com.sforce.ws.ConnectionException;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.jkiss.utils.ArrayUtils;

public abstract class ObjectElementInfo {
    private static final Logger log = Logger.getLogger(ObjectElementInfo.class.getName());
    final IDescribeSObjectResult sobject;

    public ObjectElementInfo(IDescribeSObjectResult sobject) {
        this.sobject = sobject;
    }

    public String getObjectName() {
        return this.sobject.getName();
    }

    public abstract String getName();

    public abstract String getLabel();

    public abstract FieldType getDataType();

    public abstract int getLength();

    public abstract int getByteLength();

    public abstract int getDigits();

    public abstract boolean isNillable();

    public abstract boolean isAutoIncrement();

    public abstract String getReferenceName();

    public abstract String[] getReferenceTo();

    public String getReferenceTableName() {
        Object[] referenceTo = this.getReferenceTo();
        return ArrayUtils.isEmpty((Object[])referenceTo) ? null : referenceTo[0];
    }

    public abstract boolean isSimple();

    public IDescribeSObjectResult getReferencedTable(SalesForceConnection connection) throws SQLException, ConnectionException {
        String refTableName = this.getReferenceTableName();
        if (refTableName == null) {
            return null;
        }
        IDescribeSObjectResult tableInfo = connection.getMetaData().getTableInfo(refTableName);
        if (tableInfo == null) {
            log.warning("Table name '" + refTableName + "' not found");
        }
        return tableInfo;
    }
}

