/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce;

import com.dbeaver.jdbc.model.AbstractJdbcConnection;
import com.dbeaver.jdbc.salesforce.SalesForceDatabaseMetaData;
import com.dbeaver.jdbc.salesforce.SalesForceQueryStatement;
import com.dbeaver.jdbc.salesforce.SalesforceOAuthFlow;
import com.dbeaver.jdbc.salesforce.oauth.SalesforceClientCredentialsHandler;
import com.dbeaver.jdbc.salesforce.oauth.SalesforceOAuthCodeHandler;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectorConfig;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.oauth.IOAuthHandler;

public class SalesForceConnection
extends AbstractJdbcConnection {
    private static final Logger log = Logger.getLogger(SalesForceConnection.class.getName());
    private final SalesForceDatabaseMetaData metadata;
    private PartnerConnection partnerConnection;

    public SalesForceConnection(@NotNull String url, @NotNull Properties properties) throws SQLException {
        this.metadata = new SalesForceDatabaseMetaData(this, url);
        this.connect(url, properties);
    }

    PartnerConnection getPartnerConnection() {
        return this.partnerConnection;
    }

    private void connect(String url, Properties properties) throws SQLException {
        Matcher urlMatcher = Pattern.compile("jdbc:dbeaver:salesforce:(.*)").matcher(url);
        if (!urlMatcher.matches()) {
            throw new SQLException("Invalid URL: " + url);
        }
        String hostName = urlMatcher.group(1).trim();
        if (CommonUtils.isEmpty((String)hostName)) {
            hostName = "login.salesforce.com";
        }
        String useOAuth = properties.getProperty("useOAuth");
        ConnectorConfig config = new ConnectorConfig();
        if (!CommonUtils.isEmpty((String)useOAuth) && "true".equals(useOAuth)) {
            String authToken;
            Map oauthResult;
            IOAuthHandler oAuthHandler = SalesForceConnection.getOAuthHandler(properties, hostName);
            try {
                oauthResult = oAuthHandler.authorize();
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            config.setManualLogin(true);
            String oauthFlowType = properties.getProperty("oauth_flow_type");
            if (SalesforceOAuthFlow.OAUTH2_CLIENT_CREDENTIALS.getName().equals(oauthFlowType)) {
                authToken = (String)oauthResult.get("token");
                config.setRequestHeader("Authorization", "Bearer " + authToken);
            } else {
                authToken = (String)oauthResult.get("auth-token");
            }
            config.setSessionId(authToken);
            config.setAuthEndpoint((String)oauthResult.get("service_endpoint"));
            config.setServiceEndpoint((String)oauthResult.get("service_endpoint"));
        } else {
            String user = properties.getProperty("user");
            if (CommonUtils.isEmpty((String)user)) {
                throw new SQLException("User name is missing");
            }
            Object password = properties.getProperty("password");
            if (CommonUtils.isEmpty((String)password)) {
                throw new SQLException("Password is missing");
            }
            String authToken = properties.getProperty("auth-token");
            if (!CommonUtils.isEmpty((String)authToken)) {
                password = (String)password + authToken;
            }
            config.setUsername(user);
            config.setPassword((String)password);
            config.setAuthEndpoint(String.format("https://%s/services/Soap/u/%s", hostName, "58.0"));
        }
        try {
            config.setRequestHeader("User-Agent", "DBeaver Salesforce JDBC Driver");
            this.partnerConnection = new PartnerConnection(config);
        }
        catch (Exception e) {
            throw new SQLException("Error opening SalesForce connection", e);
        }
    }

    @NotNull
    private static IOAuthHandler getOAuthHandler(Properties properties, String hostName) throws SQLException {
        if (properties.getProperty("oauth_flow_type") == null) {
            properties.setProperty("oauth_flow_type", SalesforceOAuthFlow.OAUTH2_CODE.getName());
        }
        if (SalesforceOAuthFlow.OAUTH2_CODE.getName().equals(properties.getProperty("oauth_flow_type"))) {
            SalesforceOAuthCodeHandler oAuthHandler = new SalesforceOAuthCodeHandler(properties.getProperty("client_id"), properties.getProperty("client_secret"), String.format("https://%s/services/oauth2/authorize", hostName), String.format("https://%s/services/oauth2/token", hostName), IOUtils.findFreePort((int)55555, (int)55559));
            oAuthHandler.setCallbackEndpoint("/Callback");
            return oAuthHandler;
        }
        if (SalesforceOAuthFlow.OAUTH2_CLIENT_CREDENTIALS.getName().equals(properties.getProperty("oauth_flow_type"))) {
            return new SalesforceClientCredentialsHandler(properties.getProperty("client_id"), properties.getProperty("client_secret"), String.format("https://%s/services/oauth2/token", hostName));
        }
        throw new SQLException("Invalid OAuth flow type: " + properties.getProperty("oauth_flow_type"));
    }

    public SalesForceDatabaseMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLException("Unsupported result set type: " + resultSetType);
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Unsupported result set concurrency: " + resultSetType);
        }
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw new SQLException("Unsupported result set holdability: " + resultSetType);
        }
        return new SalesForceQueryStatement(this);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLException("Unsupported result set type: " + resultSetType);
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Unsupported result set concurrency: " + resultSetType);
        }
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw new SQLException("Unsupported result set holdability: " + resultSetType);
        }
        return new SalesForceQueryStatement(this, sql);
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.partnerConnection = null;
    }

    public boolean isClosed() throws SQLException {
        return this.partnerConnection == null;
    }

    public boolean getAutoCommit() throws SQLException {
        return true;
    }
}

