/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.model;

import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.dbeaver.db.cassandra.model.CasTable;
import com.dbeaver.db.cassandra.model.CasTableColumn;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;

public class CasTableKey
implements DBSTableConstraint,
DBSEntityReferrer {
    public static final DBSEntityConstraintType PARTITION_KEY = new DBSEntityConstraintType("prtkey", "PARTITION KEY", "Partition Key", false, false, false, false);
    private static final Log log = Log.getLog(CasTableKey.class);
    private final CasTable table;
    private final List<KeyColumn> columns;
    private final DBSEntityConstraintType type;

    public CasTableKey(DBRProgressMonitor monitor, CasTable table, List<ColumnMetadata> columns, DBSEntityConstraintType type) throws DBException {
        this.table = table;
        this.columns = new ArrayList<KeyColumn>();
        for (ColumnMetadata cmd : columns) {
            CasTableColumn column = table.getAttribute(monitor, cmd.getName().toString());
            if (column == null) {
                log.error((Object)("Column '" + String.valueOf(cmd.getName()) + "' not found"));
                continue;
            }
            this.columns.add(new KeyColumn(column));
        }
        this.type = type;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.type.getName();
    }

    @Property(viewable=true, editable=true, order=2)
    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return this.type;
    }

    @NotNull
    public CasTable getParentObject() {
        return this.table;
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.table.getDataSource();
    }

    public boolean isPersisted() {
        return true;
    }

    public List<KeyColumn> getAttributeReferences(@Nullable DBRProgressMonitor monitor) throws DBException {
        return this.columns;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return this.getName();
    }

    public class KeyColumn
    implements DBSObject,
    DBSEntityAttributeRef {
        private final CasTableColumn column;

        public KeyColumn(CasTableColumn column) {
            this.column = column;
        }

        @NotNull
        public DBSEntityAttribute getAttribute() {
            return this.column;
        }

        public DBSObject getParentObject() {
            return CasTableKey.this;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return CasTableKey.this.getDataSource();
        }

        @Property(viewable=true, editable=true, order=1)
        @NotNull
        public String getName() {
            return this.column.getName();
        }

        public boolean isPersisted() {
            return true;
        }

        public String getDescription() {
            return null;
        }
    }
}

