/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.data.handlers;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.type.VectorType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.dbeaver.db.cassandra.data.CasVectorValue;
import com.dbeaver.db.cassandra.data.handlers.CasComplexValueHandler;
import com.dbeaver.db.cassandra.exec.CasPreparedStatement;
import com.dbeaver.db.cassandra.exec.CasSession;
import com.dbeaver.db.cassandra.model.CasDataSource;
import com.dbeaver.db.cassandra.model.CasExecutionContext;
import com.dbeaver.db.cassandra.model.CasTypedObject;
import java.util.Arrays;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasVectorValueHandler
extends CasComplexValueHandler {
    public static final CasVectorValueHandler INSTANCE = new CasVectorValueHandler();

    @NotNull
    public Class<CasVectorValue> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return CasVectorValue.class;
    }

    public CasVectorValue getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        CasDataSource dataSource = (CasDataSource)session.getDataSource();
        if (object == null) {
            return new CasVectorValue((CasExecutionContext)session.getExecutionContext(), dataSource.getDefaultKeyspaceName(), null, (VectorType)((CasTypedObject)type).getCasDataType());
        }
        if (object instanceof CasVectorValue) {
            return copy ? new CasVectorValue((CasVectorValue)((Object)object)) : (CasVectorValue)((Object)object);
        }
        if (object instanceof String) {
            String vectorString = (String)object;
            if (vectorString.startsWith("[") && vectorString.endsWith("]")) {
                List<String> elements = Arrays.stream(vectorString.substring(1, vectorString.length() - 1).split(",")).map(String::trim).toList();
                VectorType casDataType = (VectorType)((CasTypedObject)type).getCasDataType();
                if (casDataType.getDimensions() != elements.size()) {
                    throw new DBCException("Invalid vector size for %s, expected size %d actual %d  : ".formatted(vectorString, casDataType.getDimensions(), elements.size()));
                }
                TypeCodec objectTypeCodec = CodecRegistry.DEFAULT.codecFor(casDataType.getElementType());
                CqlVector vector = CqlVector.from((String)vectorString, (TypeCodec)objectTypeCodec);
                return new CasVectorValue((CasExecutionContext)session.getExecutionContext(), dataSource.getDefaultKeyspaceName(), (CqlVector<? extends Number>)vector, casDataType);
            }
            throw new DBCException("Invalid vector format for: " + String.valueOf(object));
        }
        throw new DBCException("Unsupported vector type: " + object.getClass().getName());
    }

    @Override
    protected void bindParameter(CasSession session, CasPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        CasVectorValue casVector = (CasVectorValue)((Object)value);
        statement.updateBoundStatement((BoundStatement)statement.getBoundStatement().setVector(paramIndex, casVector.makeVector(), CasVectorValue.getElementClass(casVector.getElementType())));
    }
}

