/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql.exec;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.dbeaver.db.cosmos.nosql.DCosmosContainer;
import com.dbeaver.db.cosmos.nosql.DCosmosNoSQLDataSource;
import com.dbeaver.db.cosmos.nosql.DCosmosSession;
import com.dbeaver.db.cosmos.nosql.exec.DCosmosBaseStatement;
import com.dbeaver.db.cosmos.nosql.model.DCosmosResultIterable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import reactor.core.publisher.Flux;

public class DCosmosSelectStatement
extends DCosmosBaseStatement {
    private static final Log log = Log.getLog(DCosmosSelectStatement.class);
    @NotNull
    private final DCosmosNoSQLDataSource dataSource;
    @NotNull
    private final DCosmosContainer container;
    @NotNull
    private final String query;
    @Nullable
    private DCosmosResultIterable resultSet;

    public DCosmosSelectStatement(@NotNull DCosmosSession session, @NotNull DCosmosNoSQLDataSource dataSource, @NotNull DCosmosContainer container, @NotNull String query) {
        super(session);
        this.dataSource = dataSource;
        this.query = query;
        this.container = container;
    }

    @Override
    public DCosmosContainer getSourceEntity() {
        return this.container;
    }

    @Nullable
    public String getQueryString() {
        return this.query;
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            CosmosAsyncContainer cosmosContainer = this.dataSource.getClient().getDatabase(this.container.getParentObject().getName()).getContainer(this.container.getName());
            CosmosQueryRequestOptions options = new CosmosQueryRequestOptions().setMaxBufferedItemCount(this.getResultsFetchSize()).setMaxDegreeOfParallelism(1);
            CosmosPagedFlux objects = cosmosContainer.queryItems(this.query, options, Object.class);
            this.resultSet = new DCosmosResultIterable(this);
            this.resultSet.subscribe((Flux<FeedResponse<Object>>)objects.byPage(this.getResultsFetchSize()));
            return true;
        }
        catch (Exception e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    @Nullable
    public DBCResultSet openResultSet() throws DBCException {
        return this.resultSet;
    }

    @Override
    public long getUpdateRowCount() {
        return 0L;
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return new Throwable[0];
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void close() throws DBException {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
                this.resultSet = null;
            }
        }
        finally {
            super.close();
        }
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (this.resultSet != null) {
            this.resultSet.cancelBlock(monitor, blockThread);
        }
    }
}

