/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql;

import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.impl.sql.StandardSQLDialectQueryGenerator;

public class DCosmosQueryGenerator
extends StandardSQLDialectQueryGenerator {
    private static final Log log = Log.getLog(DCosmosQueryGenerator.class);

    @Nullable
    public String getConstraintCondition(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, @Nullable String conditionTable, boolean inlineCriteria) {
        DBCLogicalOperator operator = constraint.getOperator();
        if (operator == null) {
            return super.getConstraintCondition(dataSource, constraint, conditionTable, inlineCriteria);
        }
        return switch (operator) {
            case DBCLogicalOperator.IS_NOT_NULL -> "!= null";
            case DBCLogicalOperator.IS_NULL -> "= null";
            default -> super.getConstraintCondition(dataSource, constraint, conditionTable, inlineCriteria);
        };
    }

    public void appendOrderString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, boolean subQuery, @NotNull StringBuilder query) {
        StringJoiner orderJoiner = new StringJoiner(", ");
        for (DBDAttributeConstraint co : filter.getOrderConstraints()) {
            orderJoiner.add(this.getConstraintAttributeName(dataSource, conditionTable, co, subQuery, false) + (co.isOrderDescending() ? " DESC" : ""));
        }
        query.append(orderJoiner);
    }

    @NotNull
    public String getConstraintAttributeName(@NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull DBDAttributeConstraint constraint, boolean subQuery, boolean includeContainerName) {
        return "c." + constraint.getAttributeName();
    }
}

