/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.aws;

import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.model.auth.SMSessionAuthCredentials;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSPreferences;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthCredentialsWithComplexProperties;
import org.jkiss.dbeaver.model.auth.AuthProperty;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceAuth;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithWebIdentityCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;

public class AuthModelAWSCredentials
extends AuthModelDatabaseNativeCredentials
implements SMSessionAuthCredentials,
DBAAuthCredentialsWithComplexProperties {
    private static final Log log = Log.getLog(AuthModelAWSCredentials.class);
    private static final String ROLE_SESSION_NAME = "dbeaver";
    public static final String AWS_AUTH_CONTEXT_TYPE = "aws";
    private static final Pattern AWS_CLI_LOGIN_OUTPUT = Pattern.compile("Attempting to automatically open the SSO authorization page in your default browser.\nIf the browser does not open or you wish to use a different device to authorize this request, open the following URL:\n\n^(.*?)$\n\nThen enter the code:\n\n^(.*?)$", 9);
    private String region;
    private String awsServerEndpoint;
    private String profileName;
    private String pluginName;
    private boolean defaultAwsCredentials;
    private boolean sessionCredentials;
    private transient boolean usePasswordCredentials;
    @SecureProperty
    private String awsAccessKey;
    @SecureProperty
    private String awsSecretKey;
    @SecureProperty
    private String awsSessionToken;
    private transient AwsCredentialsProvider awsCredentialsProvider;
    private String secretName;
    private boolean ssoOverCli;
    private boolean crossAccountAccess;
    private String awsAssumeAccountId;
    private String awsAssumeRoleName;
    private String awsExternalId;
    private transient Map<String, ?> attributes = Collections.emptyMap();

    public AuthModelAWSCredentials() {
    }

    public AuthModelAWSCredentials(AuthModelAWSCredentials source) {
        this.region = source.region;
        this.profileName = source.profileName;
        this.pluginName = source.pluginName;
        this.awsServerEndpoint = source.awsServerEndpoint;
        this.sessionCredentials = source.sessionCredentials;
        this.defaultAwsCredentials = source.defaultAwsCredentials;
        this.awsAccessKey = source.awsAccessKey;
        this.awsSecretKey = source.awsSecretKey;
        this.awsSessionToken = source.awsSessionToken;
        this.ssoOverCli = source.ssoOverCli;
        this.crossAccountAccess = source.crossAccountAccess;
        this.awsAssumeAccountId = source.awsAssumeAccountId;
        this.awsAssumeRoleName = source.awsAssumeRoleName;
        this.awsExternalId = source.awsExternalId;
        this.secretName = source.secretName;
        this.attributes = new LinkedHashMap(source.attributes);
        this.awsCredentialsProvider = source.awsCredentialsProvider;
    }

    @Property(hidden=true)
    public String getUserPassword() {
        return super.getUserPassword();
    }

    @Property(hidden=true)
    @AuthProperty(authContextType="aws")
    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Property(hidden=true)
    @AuthProperty(authContextType="aws")
    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    @Property
    public String getAwsServerEndpoint() {
        return this.awsServerEndpoint;
    }

    public void setAwsServerEndpoint(String awsServerEndpoint) {
        this.awsServerEndpoint = awsServerEndpoint;
    }

    @Property(order=2, nonSecuredProperty=true, required=true)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @Property(nonSecuredProperty=true)
    @AuthProperty(authContextType="aws")
    public boolean isDefaultAwsCredentials() {
        return this.defaultAwsCredentials;
    }

    public void setDefaultAwsCredentials(boolean defaultAwsCredentials) {
        this.defaultAwsCredentials = defaultAwsCredentials;
    }

    @Property(nonSecuredProperty=true)
    public boolean isSessionCredentials() {
        return this.sessionCredentials;
    }

    public void setSessionCredentials(boolean sessionCredentials) {
        this.sessionCredentials = sessionCredentials;
    }

    @Property(order=3)
    @AuthProperty(authContextType="aws")
    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        this.awsCredentialsProvider = null;
    }

    @Property(order=4, password=true, keyName="iam.aws_secret_key")
    @AuthProperty(authContextType="aws")
    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
        this.awsCredentialsProvider = null;
    }

    @Property(order=5, password=true, keyName="iam.aws_session_token")
    @AuthProperty(authContextType="aws")
    public String getAwsSessionToken() {
        return this.awsSessionToken;
    }

    public void setAwsSessionToken(String awsSessionToken) {
        this.awsSessionToken = awsSessionToken;
        this.awsCredentialsProvider = null;
    }

    public AwsCredentialsProvider getAwsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }

    public void setAwsCredentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.awsAccessKey = null;
        this.awsSecretKey = null;
        this.awsSessionToken = null;
    }

    public boolean isSsoOverCli() {
        return this.ssoOverCli;
    }

    public void setSsoOverCli(boolean ssoOverCli) {
        this.ssoOverCli = ssoOverCli;
    }

    @Property(order=0x7FFFFFFE, nonSecuredProperty=true)
    public boolean isCrossAccountAccess() {
        return this.crossAccountAccess;
    }

    public void setCrossAccountAccess(boolean crossAccountAccess) {
        this.crossAccountAccess = crossAccountAccess;
    }

    @Property(order=6, nonSecuredProperty=true)
    public String getAwsAssumeAccountId() {
        return this.awsAssumeAccountId;
    }

    void setAwsAssumeAccountId(String awsAssumeAccountId) {
        this.awsAssumeAccountId = awsAssumeAccountId;
    }

    @Property(order=7, nonSecuredProperty=true)
    public String getAwsAssumeRoleName() {
        return this.awsAssumeRoleName;
    }

    @Property(order=8, nonSecuredProperty=true)
    public String getAwsExternalId() {
        return this.awsExternalId;
    }

    public void setAwsExternalId(String awsExternalId) {
        this.awsExternalId = awsExternalId;
    }

    public void setAwsAssumeRoleName(String awsAssumeRoleName) {
        this.awsAssumeRoleName = awsAssumeRoleName;
    }

    public AwsCredentialsProvider getAuthCredentialsProvider(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getAuthCredentialsProvider(monitor, null);
    }

    @Property(order=9, nonSecuredProperty=true)
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public AwsCredentialsProvider getAuthCredentialsProvider(@NotNull DBRProgressMonitor monitor, @Nullable DBPConnectionConfiguration configuration) throws DBException {
        return this.getAuthCredentialsProvider(monitor, configuration, this.region);
    }

    public AwsCredentialsProvider getAuthCredentialsProvider(@NotNull DBRProgressMonitor monitor, @Nullable DBPConnectionConfiguration configuration, @Nullable String region) throws DBException {
        AwsCredentialsProvider credentialsProvider = this.resolveCredentialsProvider(monitor, configuration);
        if (this.ssoOverCli) {
            try {
                credentialsProvider.resolveCredentials();
            }
            catch (Throwable throwable) {
                this.loginSSO(monitor);
            }
        }
        credentialsProvider = this.assumeAccountRole(monitor, credentialsProvider, region, null);
        return credentialsProvider;
    }

    public AwsCredentialsProvider assumeAccountRole(@NotNull DBRProgressMonitor monitor, @NotNull AwsCredentialsProvider credentialsProvider, @Nullable String region, @Nullable String jwtToken) throws DBException {
        if (this.crossAccountAccess) {
            if (CommonUtils.isEmpty((String)this.awsAssumeAccountId)) {
                throw new DBCException("AWS account ID must be specified for 3rd party account access");
            }
            if (CommonUtils.isEmpty((String)this.awsAssumeRoleName)) {
                throw new DBCException("AWS IAM role name must be specified when 3rd party IAM account is specified");
            }
        }
        if (!CommonUtils.isEmpty((String)this.awsAssumeRoleName)) {
            if (CommonUtils.isEmpty((String)region)) {
                throw new DBCException("AWS region must be specified when assume role name is specified");
            }
            monitor.subTask("Assume AWS role");
            Throwable throwable = null;
            Object var6_7 = null;
            try (StsClient stsClient = AWSIAMUtils.createStsClient(credentialsProvider, Region.of((String)region));){
                Object roleArn;
                if (this.awsAssumeRoleName.startsWith(this.getRoleArnPrefix(region))) {
                    roleArn = this.awsAssumeRoleName;
                } else {
                    String accId;
                    String string = accId = this.crossAccountAccess ? this.awsAssumeAccountId : null;
                    if (accId == null) {
                        accId = stsClient.getCallerIdentity().account();
                    }
                    roleArn = this.getRoleArnPrefix(region) + accId + ":role/" + this.awsAssumeRoleName;
                }
                if (jwtToken != null) {
                    AssumeRoleWithWebIdentityRequest arRequest = (AssumeRoleWithWebIdentityRequest)AssumeRoleWithWebIdentityRequest.builder().roleArn((String)roleArn).webIdentityToken(jwtToken).roleSessionName(ROLE_SESSION_NAME).build();
                    credentialsProvider = ((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)StsAssumeRoleWithWebIdentityCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(arRequest).build();
                } else {
                    AssumeRoleRequest.Builder arRequestBuilder = AssumeRoleRequest.builder().roleArn((String)roleArn).roleSessionName(ROLE_SESSION_NAME);
                    if (!CommonUtils.isEmpty((String)this.awsExternalId)) {
                        arRequestBuilder.externalId(this.awsExternalId);
                    }
                    AssumeRoleRequest arRequest = (AssumeRoleRequest)arRequestBuilder.build();
                    credentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(arRequest).build();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return credentialsProvider;
    }

    public void updateCredentialsFromComplexProperties(@NotNull Map<String, ?> complexProperties) {
        Object useSecretManager;
        Object authTypeValue = complexProperties.get("authType");
        if (authTypeValue != null) {
            this.setDefaultAwsCredentials("Default credentials".equals(authTypeValue));
            this.setSessionCredentials("Session credentials".equals(authTypeValue));
            this.setUsePasswordCredentials("User name/password".equals(authTypeValue));
        }
        if ((useSecretManager = complexProperties.get("useSecretManager")) != null && !CommonUtils.toBoolean(useSecretManager)) {
            this.setSecretName(null);
            complexProperties.remove("secretName");
        }
    }

    public boolean isUsePasswordCredentials() {
        return this.usePasswordCredentials;
    }

    public void setUsePasswordCredentials(boolean usePasswordCredentials) {
        this.usePasswordCredentials = usePasswordCredentials;
    }

    @NotNull
    private String getRoleArnPrefix(@NotNull String region) {
        return "arn:" + AWSIAMUtils.getArnPartition(region) + ":iam::";
    }

    private synchronized AwsCredentialsProvider resolveCredentialsProvider(@NotNull DBRProgressMonitor monitor, @Nullable DBPConnectionConfiguration configuration) throws DBException {
        DefaultCredentialsProvider credentialsProvider;
        if (this.awsCredentialsProvider != null) {
            return this.awsCredentialsProvider;
        }
        if (!CommonUtils.isEmpty((String)this.profileName)) {
            monitor.subTask("Read AWS profiles");
            if (CommonUtils.isEmpty((String)this.profileName)) {
                throw new DBCException("AWS profile name must be specified");
            }
            credentialsProvider = ProfileCredentialsProvider.builder().profileName(this.profileName).build();
        } else if (this.defaultAwsCredentials) {
            credentialsProvider = DefaultCredentialsProvider.builder().reuseLastProviderEnabled(Boolean.valueOf(false)).build();
        } else {
            if (this.sessionCredentials && CommonUtils.isEmpty((String)this.awsAccessKey) && !SMAuthUtils.updateSessionCredentialsFromSession((DBRProgressMonitor)monitor, (String)AWS_AUTH_CONTEXT_TYPE, (String)"AWS", (SMSessionAuthCredentials)this)) {
                throw new DBCException("AWS session credentials are missing");
            }
            String accessKey = this.awsAccessKey;
            String secretKey = this.awsSecretKey;
            String sessionToken = this.awsSessionToken;
            if (configuration != null) {
                if (CommonUtils.isEmpty((String)accessKey)) {
                    accessKey = configuration.getUserName();
                }
                if (CommonUtils.isEmpty((String)secretKey)) {
                    secretKey = configuration.getUserPassword();
                }
            }
            if (CommonUtils.isEmpty((String)accessKey) || CommonUtils.isEmpty((String)secretKey)) {
                DBPAuthInfo authInfo;
                monitor.subTask("Acquire secret credentials in interactive mode");
                try {
                    authInfo = DBWorkbench.getPlatformUI().promptUserCredentials("Enter access key and secret key", null, "Access Key", accessKey, "Secret Key", secretKey, false, false);
                }
                catch (Exception e) {
                    authInfo = null;
                    log.error((Object)e);
                }
                if (authInfo != null) {
                    accessKey = authInfo.getUserName();
                    secretKey = authInfo.getUserPassword();
                }
                if (CommonUtils.isEmpty((String)accessKey) || CommonUtils.isEmpty((String)secretKey)) {
                    throw new DBCException("AWS access key and secret key must be specified");
                }
            }
            Object awsCredentials = CommonUtils.isEmpty((String)sessionToken) ? AwsBasicCredentials.create((String)accessKey, (String)secretKey) : AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)sessionToken);
            credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        }
        this.awsCredentialsProvider = credentialsProvider;
        return credentialsProvider;
    }

    private void loginSSO(@NotNull DBRProgressMonitor monitor) throws DBCException {
        monitor.subTask("Perform SSO login using AWS CLI");
        this.executeCLI(monitor, CliCommand.LOGIN);
        monitor.subTask("SSO login finished");
    }

    private void logoutSSO(@NotNull DBRProgressMonitor monitor) throws DBCException {
        monitor.subTask("Perform SSO logout using AWS CLI");
        this.executeCLI(monitor, CliCommand.LOGOUT);
        monitor.subTask("SSO logout finished");
    }

    private void executeCLI(@NotNull DBRProgressMonitor monitor, @NotNull CliCommand command) throws DBCException {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            try {
                this.executeCLI(monitor, command, future);
            }
            catch (IOException iOException) {
                throw new DBCException("Unexpected error while running AWS CLI");
            }
        }
        finally {
            future.complete(null);
        }
    }

    private void executeCLI(@NotNull DBRProgressMonitor monitor, @NotNull CliCommand command, @NotNull CompletableFuture<Void> future) throws DBCException, IOException {
        BufferedReader reader;
        Process process;
        List<String> args = this.buildCliArgs(command);
        log.debug((Object)("Perform " + String.valueOf((Object)command) + " using AWS CLI - " + String.valueOf(args)));
        try {
            process = new ProcessBuilder(new String[0]).command(args).start();
        }
        catch (Exception e) {
            throw new DBCException("Can't start AWS CLI. Is it installed on the local machine?", (Throwable)e);
        }
        UIServiceAuth service = (UIServiceAuth)DBWorkbench.getService(UIServiceAuth.class);
        if (service != null && command == CliCommand.LOGIN) {
            try {
                String lines = process.inputReader().lines().limit(8L).collect(Collectors.joining("\n"));
                Matcher matcher = AWS_CLI_LOGIN_OUTPUT.matcher(lines);
                if (matcher.find()) {
                    URI url = URI.create(matcher.group(1));
                    String code = matcher.group(2);
                    service.showCodePopup(url, code, future);
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to retrieve SSO information from the CLI", (Throwable)e);
            }
        }
        while (process.isAlive()) {
            if (monitor.isCanceled() || future.isCancelled()) {
                process.destroy();
                throw new DBCException("AWS SSO initialization has been canceled");
            }
            RuntimeUtils.pause((int)50);
        }
        int status = process.exitValue();
        if (status == 0) {
            return;
        }
        Throwable throwable = null;
        Object var9_14 = null;
        try {
            reader = process.inputReader();
            try {
                String output = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                if (!output.isEmpty()) {
                    log.debug((Object)("AWS SSO login info message:\n" + output));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var9_14 = null;
        try {
            reader = process.errorReader();
            try {
                String error = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                if (!error.isEmpty()) {
                    throw new DBCException("AWS SSO login failed: " + error);
                }
                throw new DBCException("AWS SSO login failed with status code " + status);
            }
            catch (Throwable throwable3) {
                if (reader != null) {
                    reader.close();
                }
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @NotNull
    private List<String> buildCliArgs(@NotNull CliCommand command) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(AuthModelAWSCredentials.getAwsCliExecutablePath());
        args.add("sso");
        args.add(command.name);
        if (!CommonUtils.isEmpty((String)this.profileName)) {
            args.add("--profile");
            args.add(this.profileName);
        }
        return args;
    }

    public boolean refreshSession(DBRProgressMonitor monitor, DBPDataSourceContainer dataSource) throws DBException {
        if (this.sessionCredentials) {
            SMAuthUtils.updateSessionCredentialsFromSession((DBRProgressMonitor)monitor, (String)AWS_AUTH_CONTEXT_TYPE, (String)"AWS", (SMSessionAuthCredentials)this);
            return true;
        }
        boolean isSSO = this.ssoOverCli;
        if (!isSSO && this.awsCredentialsProvider instanceof ProfileCredentialsProvider) {
            try {
                this.awsCredentialsProvider.resolveCredentials();
            }
            catch (Exception e) {
                if (AWSIAMUtils.isTokenExpiredError(e)) {
                    isSSO = true;
                }
                throw e;
            }
        }
        if (!isSSO) {
            return false;
        }
        this.awsCredentialsProvider = null;
        this.loginSSO(monitor);
        return true;
    }

    public boolean closeSession(DBRProgressMonitor monitor) throws DBCException {
        if (!this.ssoOverCli) {
            return false;
        }
        this.logoutSSO(monitor);
        return true;
    }

    @NotNull
    public static String getAwsCliExecutablePath() {
        String executable = AuthModelAWSPreferences.getPreferences().getString("aws.cli.executable");
        return CommonUtils.isEmpty((String)executable) ? AWS_AUTH_CONTEXT_TYPE : executable;
    }

    public Map<String, ?> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, ?> attributes) {
        this.attributes = attributes;
    }

    public Object getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    void resetSettings() {
        this.sessionCredentials = false;
        this.defaultAwsCredentials = false;
        this.profileName = null;
        this.awsAccessKey = null;
        this.awsSecretKey = null;
        this.awsSessionToken = null;
        this.secretName = null;
        this.pluginName = null;
        this.awsAssumeAccountId = null;
        this.awsAssumeRoleName = null;
    }

    private static enum CliCommand {
        LOGIN("login"),
        LOGOUT("logout");

        private final String name;

        private CliCommand(String name) {
            this.name = name;
        }
    }
}

