/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iam.model.PolicyVersion;

public class ListPolicyVersionsIterable
implements SdkIterable<ListPolicyVersionsResponse> {
    private final IamClient client;
    private final ListPolicyVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPolicyVersionsIterable(IamClient client, ListPolicyVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPolicyVersionsResponseFetcher();
    }

    public Iterator<ListPolicyVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PolicyVersion> versions() {
        Function<ListPolicyVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.versions() != null) {
                return response.versions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPolicyVersionsResponseFetcher
    implements SyncPageFetcher<ListPolicyVersionsResponse> {
        private ListPolicyVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyVersionsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListPolicyVersionsResponse nextPage(ListPolicyVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyVersionsIterable.this.client.listPolicyVersions(ListPolicyVersionsIterable.this.firstRequest);
            }
            return ListPolicyVersionsIterable.this.client.listPolicyVersions((ListPolicyVersionsRequest)((Object)ListPolicyVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

