/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.exec;

import com.dbeaver.db.google.bigtable.BigTableSQL;
import com.dbeaver.db.google.bigtable.exec.BigTableBaseStatement;
import com.dbeaver.db.google.bigtable.exec.BigTableResultSet;
import com.dbeaver.db.google.bigtable.exec.BigTableSession;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.utils.CommonUtils;

public class BigTableSQLStatement
extends BigTableBaseStatement {
    private static final Log log = Log.getLog(BigTableSQLStatement.class);
    private final String queryText;
    protected long offset;
    protected long limit;
    private BigTableResultSet resultSet;
    private String tableName;

    public BigTableSQLStatement(BigTableSession session, String queryText) {
        super(session);
        this.queryText = queryText;
    }

    public String getQueryString() {
        return this.queryText;
    }

    @Override
    public BigTableResultSet executeWithResults() throws DBCException {
        try {
            Query query = this.createSelectQuery(this.queryText.trim());
            ServerStream rows = ((BigTableSession)this.getSession()).getExecutionContext().getOwnerInstance().getDataClient().readRows(query);
            return new BigTableResultSet(this, (ServerStream<Row>)rows);
        }
        catch (Exception e) {
            if (e instanceof DBCException) {
                throw (DBCException)e;
            }
            throw new DBCException(CommonUtils.getRootCause((Throwable)e), (DBCExecutionContext)((BigTableSession)this.getSession()).getExecutionContext());
        }
    }

    public boolean executeStatement() throws DBCException {
        this.resultSet = this.executeWithResults();
        return true;
    }

    private Query createSelectQuery(String query) throws Exception {
        Statement statement = SQLSemanticProcessor.parseQuery((String)query);
        if (statement instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)statement;
            return this.parseSelect(select);
        }
        throw new DBCException("Only SELECT SQL queries supported");
    }

    private Query parseSelect(PlainSelect select) throws DBCException {
        Limit sLimit;
        Filters.ChainFilter filter;
        Expression where;
        if (!(select.getFromItem() instanceof Table)) {
            throw new DBCException("FROM keyword missing");
        }
        if (!CommonUtils.isEmpty((Collection)select.getJoins())) {
            throw new DBCException("JOINs are not supported");
        }
        if (select.getHaving() != null) {
            throw new DBCException("HAVING is not supported");
        }
        this.tableName = ((Table)select.getFromItem()).getName();
        Query query = Query.create((String)DBUtils.getUnQuotedIdentifier((DBPDataSource)((BigTableSession)this.getSession()).getDataSource(), (String)this.tableName));
        List selectItems = select.getSelectItems();
        if (!CommonUtils.isEmpty((Collection)selectItems)) {
            ArrayList<String> attrNames = new ArrayList<String>();
            for (SelectItem item : selectItems) {
                Expression expression = item.getExpression();
                if (expression instanceof AllColumns) break;
                Expression expr = item.getExpression();
                if (expr instanceof Column) {
                    String attrName = DBUtils.getUnQuotedIdentifier((String)((Column)expr).getFullyQualifiedName(), (String)"\"");
                    attrNames.add(attrName);
                    continue;
                }
                throw new DBCException("Unsupported select expression: " + String.valueOf(expr));
            }
            CommonUtils.isEmpty(attrNames);
        }
        if ((where = select.getWhere()) != null && BigTableSQL.parseExpression(filter = Filters.FILTERS.chain(), where)) {
            query.filter((Filters.Filter)filter);
        }
        if ((sLimit = select.getLimit()) != null) {
            try {
                if (sLimit.getOffset() != null) {
                    throw new DBCException("Results offset is not supported");
                }
                if (sLimit.getRowCount() != null) {
                    this.limit = Long.parseLong(sLimit.getRowCount().toString());
                }
                query.limit((long)((int)this.limit));
            }
            catch (NumberFormatException e) {
                throw new DBCException("Bad LIMIT clause", (Throwable)e);
            }
        }
        return query;
    }

    public BigTableResultSet openResultSet() throws DBCException {
        return this.resultSet;
    }

    public long getUpdateRowCount() {
        return -1L;
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBException("Mongo query cancel not implemented");
        }
        blockThread.interrupt();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public String getEntityName() {
        return this.tableName;
    }
}

