/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure.sql;

import com.azure.resourcemanager.cosmos.CosmosManager;
import com.azure.resourcemanager.cosmos.models.CosmosDBAccount;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountConnectionString;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKind;
import com.dbeaver.cloud.azure.AzureCloudAbstractInstance;
import com.dbeaver.cloud.azure.AzureCloudService;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.sql.AzureCloudCosmosDBInstance;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AzureCloudCosmosCassandraDBInstance
extends AzureCloudCosmosDBInstance {
    private static final Log log = Log.getLog(AzureCloudCosmosCassandraDBInstance.class);
    private static final Pattern CONNECTION_REGEX = Pattern.compile("HostName=([^;]*);.*");
    private static final String datacenter = "@dbeaver-cas.net.datacenter@";
    private final CosmosDBAccount instance;

    protected AzureCloudCosmosCassandraDBInstance(@NotNull AzureCloudSession session, @NotNull CosmosDBAccount cosmosDBAccount) {
        super(session, cosmosDBAccount);
        this.instance = cosmosDBAccount;
    }

    @NotNull
    public static List<AzureCloudAbstractInstance> list(@NotNull DBRProgressMonitor monitor, @NotNull AzureCloudSession session) throws DBException {
        AuthModelAzureCredentials credentials = session.getCredentials();
        CosmosManager manager = (CosmosManager)credentials.authenticateWithToken(monitor, (AuthModelAzureCredentials.AzureScopes)AuthModelAzureCredentials.Resource.MANAGEMENT, CosmosManager::authenticate);
        return manager.databaseAccounts().list().stream().filter(instance -> instance.kind().equals((Object)DatabaseAccountKind.GLOBAL_DOCUMENT_DB)).filter(instance -> instance.capabilities().stream().anyMatch(it -> it.name().equals("EnableCassandra"))).map(server -> new AzureCloudCosmosCassandraDBInstance(session, (CosmosDBAccount)server)).collect(Collectors.toList());
    }

    @Override
    protected void setDataSourceConfiguration(@NotNull DBPConnectionConfiguration configuration) throws DBException {
        configuration.setUserName(this.instance.name());
        try {
            Matcher matcher = CONNECTION_REGEX.matcher(((DatabaseAccountConnectionString)this.instance.listConnectionStrings().connectionStrings().get(4)).connectionString());
            if (matcher.matches()) {
                configuration.setHostName(matcher.group(1));
            }
        }
        catch (Exception exception) {
            configuration.setHostName(this.instance.name() + ".cassandra.cosmos.azure.com");
        }
        configuration.setHostPort("10350");
        configuration.setProviderProperty(datacenter, this.instance.regionName());
        try {
            configuration.setUserPassword(this.instance.listKeys().primaryMasterKey());
        }
        catch (Exception exception) {
            log.warn((Object)"Connection read-only");
            configuration.setUserPassword(this.instance.listReadOnlyKeys().primaryReadonlyMasterKey());
        }
    }

    @Override
    @NotNull
    protected AzureCloudService getCloudService() {
        return AzureCloudService.COSMOS_CASSANDRA;
    }
}

