/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure;

import com.dbeaver.cloud.azure.AzureCloud;
import com.dbeaver.cloud.azure.AzureCloudZone;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.time.LocalDateTime;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AzureCloudSession
implements CPCloudSession<AzureCloudZone>,
DBACredentialsProvider {
    private final SMSession parentSession;
    private final SMSessionContext sessionContext;
    private final AzureCloud cloud;
    private final AuthModelAzureCredentials credentials;
    private AzureCloudZone[] zones;

    public AzureCloudSession(@Nullable SMSession parentSession, @NotNull SMSessionContext sessionContext, @NotNull AzureCloud cloud, @NotNull AuthModelAzureCredentials credentials) {
        this.parentSession = parentSession;
        this.sessionContext = sessionContext;
        this.cloud = cloud;
        this.credentials = credentials;
    }

    @NotNull
    public AzureCloud getCloud() {
        return this.cloud;
    }

    @NotNull
    public AzureCloudZone[] getDefaultZones() {
        return this.zones;
    }

    public void setDefaultZones(@NotNull AzureCloudZone[] zones) {
        this.zones = zones;
    }

    public void closeSession() {
        this.sessionContext.removeSession((SMSession)this);
    }

    @NotNull
    public SMAuthSpace getSessionSpace() {
        return this.cloud;
    }

    @NotNull
    public SMSessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Nullable
    public SMSessionPrincipal getSessionPrincipal() {
        return this.parentSession.getSessionPrincipal();
    }

    @NotNull
    public String getSessionId() {
        return this.parentSession.getSessionId();
    }

    @NotNull
    public LocalDateTime getSessionStart() {
        return this.parentSession.getSessionStart();
    }

    public void close() {
        this.closeSession();
    }

    public boolean provideAuthParameters(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSourceContainer, @NotNull DBPConnectionConfiguration configuration) throws DBException {
        configuration.setRuntimeAttribute("azure.ad.credentials", (Object)this.credentials);
        return true;
    }

    @NotNull
    public String getAuthContextType() {
        return "azure";
    }

    @NotNull
    public AuthModelAzureCredentials getCredentials() {
        return this.credentials;
    }
}

