/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure;

import com.dbeaver.cloud.azure.AzureCloud;
import com.dbeaver.cloud.azure.AzureCloudAbstractInstance;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.AzureCloudUtils;
import com.dbeaver.cloud.azure.AzureCloudZone;
import com.dbeaver.cloud.azure.sql.AzureCloudCosmosCassandraDBInstance;
import com.dbeaver.cloud.azure.sql.AzureCloudCosmosDBInstance;
import com.dbeaver.cloud.azure.sql.AzureCloudCosmosNoSQLInstance;
import com.dbeaver.cloud.azure.sql.AzureCloudMySQLFlexibleInstance;
import com.dbeaver.cloud.azure.sql.AzureCloudMySQLInstance;
import com.dbeaver.cloud.azure.sql.AzureCloudPostgresFlexibleInstance;
import com.dbeaver.cloud.azure.sql.AzureCloudPostgresInstance;
import com.dbeaver.cloud.azure.sql.AzureCloudSQLServerInstance;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudExplorer;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.cloud.model.services.CPDatabaseNode;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AzureCloudExplorer
implements CPCloudExplorer<AzureCloudZone> {
    private final AzureCloud cloud;
    private final AzureCloudSession session;

    public AzureCloudExplorer(@NotNull AzureCloud cloud, @NotNull AzureCloudSession session) {
        this.cloud = cloud;
        this.session = session;
    }

    @NotNull
    public CPCloud<?, ?> getCloud() {
        return this.cloud;
    }

    @NotNull
    public CPDatabaseFolder[] getRootFolders(@NotNull DBRProgressMonitor monitor) {
        return new CPDatabaseFolder[0];
    }

    @NotNull
    public CPDatabaseNode[] getDatabaseInstances(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @Nullable CPDatabaseFolder category) throws DBException {
        List instances = switch (serviceID) {
            case "sqlserver" -> AzureCloudSQLServerInstance.list(monitor, this.session);
            case "postgresql" -> AzureCloudPostgresInstance.list(monitor, this.session);
            case "postgresql-flexible" -> AzureCloudPostgresFlexibleInstance.list(monitor, this.session);
            case "mysql" -> AzureCloudMySQLInstance.list(monitor, this.session);
            case "cosmos-mongo" -> AzureCloudCosmosDBInstance.list(monitor, this.session);
            case "cosmos-cassandra" -> AzureCloudCosmosCassandraDBInstance.list(monitor, this.session);
            case "mysql-flexible" -> AzureCloudMySQLFlexibleInstance.list(monitor, this.session);
            case "cosmos-nosql" -> AzureCloudCosmosNoSQLInstance.list(monitor, this.session);
            default -> List.of();
        };
        return (CPDatabaseNode[])instances.toArray(CPDatabaseNode[]::new);
    }

    @Nullable
    public AzureCloudAbstractInstance getDatabaseInstance(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @Nullable CPDatabaseFolder category, @NotNull AzureCloudZone zone, @NotNull String instanceId) throws DBException {
        return switch (serviceID) {
            case "sqlserver" -> AzureCloudSQLServerInstance.get(monitor, this.session, instanceId);
            case "postgresql" -> {
                if (AzureCloudUtils.containsValueFromIdByName(instanceId, "flexibleServers")) {
                    yield AzureCloudPostgresFlexibleInstance.get(monitor, this.session, instanceId);
                }
                yield AzureCloudPostgresInstance.get(monitor, this.session, instanceId);
            }
            case "postgresql-flexible" -> AzureCloudPostgresFlexibleInstance.get(monitor, this.session, instanceId);
            case "mysql" -> {
                if (AzureCloudUtils.containsValueFromIdByName(instanceId, "flexibleServers")) {
                    yield AzureCloudMySQLFlexibleInstance.get(monitor, this.session, instanceId);
                }
                yield AzureCloudMySQLInstance.get(monitor, this.session, instanceId);
            }
            case "cosmos-nosql" -> AzureCloudCosmosNoSQLInstance.get(monitor, this.session, instanceId);
            default -> null;
        };
    }

    public void refreshSession(@NotNull CPCloudSession<AzureCloudZone> cloudSession) {
    }
}

