/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.workspace.tasks;

import com.dbeaver.remote.client.tm.model.TMTaskInfoService;
import com.dbeaver.remote.client.tm.model.TMTaskRun;
import com.dbeaver.remote.client.tm.model.TMTaskRuns;
import com.dbeaver.remote.workspace.DesktopWorkspaceRemote;
import com.dbeaver.team.workspace.tasks.TeamTaskImpl;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.app.BaseProjectImpl;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskFolderImpl;
import org.jkiss.dbeaver.registry.task.TaskImpl;
import org.jkiss.dbeaver.registry.task.TaskManagerImpl;
import org.jkiss.dbeaver.registry.task.TaskRunJob;

public class TeamTaskManagerImpl
extends TaskManagerImpl {
    private static final Log log = Log.getLog(TeamTaskManagerImpl.class);
    private volatile Map<String, TMTaskRun[]> runs;

    public TeamTaskManagerImpl(@NotNull BaseProjectImpl projectMetadata, @NotNull Path statisticsFolder) {
        super(projectMetadata, statisticsFolder);
    }

    @NotNull
    protected TaskImpl createTask(@NotNull DBTTaskType taskType, @NotNull String id, @NotNull String label, @Nullable String description, @NotNull Date createTime, @NotNull Date updateTime, @Nullable TaskFolderImpl taskFolder, @NotNull Map<String, Object> properties) {
        TeamTaskImpl task = new TeamTaskImpl(this.getProject(), taskType, id, label, description, createTime, updateTime, (DBTTaskFolder)taskFolder, this);
        task.setProperties(properties);
        return task;
    }

    protected void cancelJobIfNeeded(@NotNull TaskRunJob job) {
        Duration elapsedTime = job.getElapsedTime();
        Duration maxExecutionTime = job.getTask().getMaxExecutionTime();
        if (maxExecutionTime.isPositive() && elapsedTime.compareTo(maxExecutionTime) > 0) {
            job.cancelByTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected DBTTaskRun[] getTaskRuns(@NotNull TeamTaskImpl task) {
        if (this.runs == null) {
            TeamTaskManagerImpl teamTaskManagerImpl = this;
            synchronized (teamTaskManagerImpl) {
                if (this.runs == null) {
                    try {
                        this.runs = Arrays.stream(this.getClient().getAllTaskRuns(this.getProject().getId())).collect(Collectors.toMap(TMTaskRuns::getTaskId, TMTaskRuns::getRuns));
                    }
                    catch (DBException e) {
                        log.error((Object)("Error retrieving task runs from remote for project " + this.getProject().getId()), (Throwable)e);
                        this.runs = new HashMap<String, TMTaskRun[]>();
                    }
                }
            }
        }
        return (DBTTaskRun[])this.runs.computeIfAbsent(task.getId(), x -> new TMTaskRun[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateTaskRuns(String taskId) {
        TeamTaskManagerImpl teamTaskManagerImpl = this;
        synchronized (teamTaskManagerImpl) {
            TMTaskRun[] taskRuns;
            this.runs.remove(taskId);
            try {
                taskRuns = this.getClient().getAllTaskRuns(this.getProject().getId(), taskId);
            }
            catch (DBException e) {
                log.error((Object)("Error retrieving task runs from remote for project " + this.getProject().getId() + " task '" + taskId), (Throwable)e);
                taskRuns = new TMTaskRun[]{};
            }
            this.runs.put(taskId, taskRuns);
        }
    }

    @NotNull
    protected TMTaskInfoService getClient() {
        DesktopWorkspaceRemote workspace = (DesktopWorkspaceRemote)this.getProject().getWorkspace();
        return Objects.requireNonNull(workspace.getTaskInfoService(), "Task info client not found");
    }
}

