/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.workspace.events;

import com.dbeaver.team.ui.internal.TeamMessages;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.websocket.WSEventHandler;
import org.jkiss.dbeaver.model.websocket.event.WSEventController;
import org.jkiss.dbeaver.model.websocket.event.permissions.WSSubjectPermissionEvent;
import org.jkiss.dbeaver.ui.UIUtils;

public class EventHandlerSubjectPermissionEvent
implements WSEventHandler<WSSubjectPermissionEvent> {
    private static final Log log = Log.getLog(EventHandlerSubjectPermissionEvent.class);

    public void handleEvent(@NotNull WSSubjectPermissionEvent event) {
        log.debug((Object)(event.getTopicId() + " event handled"));
        UIUtils.syncExec(() -> {
            UIUtils.showMessageBox(null, (String)TeamMessages.event_handler_permission_changed_warning_title, (String)TeamMessages.event_handler_permission_changed_warning_message, (int)8);
            EventHandlerSubjectPermissionEvent.cancelEventHandlerJobs();
            PlatformUI.getWorkbench().restart();
        });
    }

    private static void cancelEventHandlerJobs() {
        Job[] jobArray = Job.getJobManager().find(WSEventController.JOB_EVENT_HANDLER_FAMILY);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            job.cancel();
            try {
                job.join(100L, null);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn((Object)"Interrupted while waiting for CloudBeaver job to finish", (Throwable)e);
            }
            ++n2;
        }
    }
}

