/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.workspace.events;

import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.team.application.TeamWorkbenchAdvisor;
import com.dbeaver.team.workspace.TeamWorkspaceImpl;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.websocket.WSEventHandler;
import org.jkiss.dbeaver.model.websocket.event.session.WSAbstractSessionEvent;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class EventHandlerSessionUpdate
implements WSEventHandler<WSAbstractSessionEvent> {
    private static final Log log = Log.getLog(EventHandlerSessionUpdate.class);
    private static final AtomicBoolean REFRESH_IN_PROGRESS = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(@NotNull WSAbstractSessionEvent event) {
        log.debug((Object)(event.getId() + ":" + event.getTopicId() + " event handled"));
        if ("cb_session_expired".equals(event.getId())) {
            TeamWorkbenchAdvisor.notifyUserSessionClosedAndRestart();
            return;
        }
        if (!"cb_access_token_expired".equals(event.getId())) {
            return;
        }
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        SMSession workspaceSession = workspace.getWorkspaceSession();
        if (workspaceSession == null) {
            return;
        }
        SMSessionRemote sessionRemote = (SMSessionRemote)DBUtils.getAdapter(SMSessionRemote.class, (Object)workspaceSession);
        if (sessionRemote == null) {
            return;
        }
        if (REFRESH_IN_PROGRESS.get()) {
            log.debug((Object)"Refresh already in progress, skip event");
            return;
        }
        AtomicBoolean atomicBoolean = REFRESH_IN_PROGRESS;
        synchronized (atomicBoolean) {
            REFRESH_IN_PROGRESS.set(true);
            TeamWorkspaceImpl teamWorkspace = (TeamWorkspaceImpl)((Object)DBUtils.getAdapter(TeamWorkspaceImpl.class, (Object)workspace));
            if (teamWorkspace != null) {
                teamWorkspace.getEventClient().setPauseConnection(true);
            }
            log.debug((Object)"Remote session refresh initiated by event");
            try {
                sessionRemote.getRemoteCredentialsProvider().refreshSMSession();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to refresh remote session", e);
            }
            if (teamWorkspace != null) {
                teamWorkspace.getEventClient().setPauseConnection(false);
            }
            REFRESH_IN_PROGRESS.set(false);
        }
    }
}

