/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.workspace.events;

import com.dbeaver.remote.workspace.RemoteProjectImpl;
import com.dbeaver.team.ui.internal.TeamMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.websocket.WSEventHandler;
import org.jkiss.dbeaver.model.websocket.event.resource.WSResourceUpdatedEvent;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;

public class EventHandlerResourceUpdate
implements WSEventHandler<WSResourceUpdatedEvent> {
    private static final Log log = Log.getLog(EventHandlerResourceUpdate.class);

    public void handleEvent(@NotNull WSResourceUpdatedEvent event) {
        RemoteProjectImpl rcpProject;
        block33: {
            block32: {
                log.debug((Object)(event.getTopicId() + " event handled"));
                DBPProject project = DBWorkbench.getPlatform().getWorkspace().getProjectById(event.getProjectId());
                if (!(project instanceof RemoteProjectImpl)) break block32;
                rcpProject = (RemoteProjectImpl)project;
                if (project.isOpen() && rcpProject.getRootResource() != null) break block33;
            }
            return;
        }
        switch (event.getId()) {
            case "cb_rm_resource_created": {
                IFolder parentFolder;
                Path resPath;
                Path resFolderPath = resPath = new Path(event.getResourcePath());
                if (resFolderPath.segmentCount() > 0) {
                    resFolderPath = resFolderPath.removeLastSegments(1);
                }
                if ((parentFolder = rcpProject.getRootResource().getFolder((IPath)resFolderPath)) == null) break;
                try {
                    rcpProject.addNewResourceToCache((IPath)resPath);
                }
                catch (DBException e) {
                    log.error((Object)("Error adding new resource '" + String.valueOf(resPath) + "' to cache"), (Throwable)e);
                    break;
                }
                try {
                    IFolder folder;
                    parentFolder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    IContainer root = rcpProject.getRootResource();
                    if (root == null || (folder = root.getFolder((IPath)resPath)) == null) break;
                    this.refreshResourceNode((DBPProject)rcpProject, (IResource)folder);
                }
                catch (CoreException | DBException e) {
                    log.error((Object)("Folder '" + String.valueOf(parentFolder.getFullPath()) + "' in project '" + rcpProject.getName() + "' refresh failed"), e);
                }
                break;
            }
            case "cb_rm_resource_updated": {
                IResource member = rcpProject.getRootResource().findMember((IPath)new Path(event.getResourcePath()));
                if (!(member instanceof IFile)) break;
                IPath relPath = member.getFullPath().makeRelativeTo(rcpProject.getRootResource().getFullPath());
                try {
                    rcpProject.updateResourceCache(relPath, member);
                }
                catch (DBException e) {
                    log.error((Object)("Error updating resource '" + String.valueOf(relPath) + "' cache"), (Throwable)e);
                    break;
                }
                try {
                    member.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    this.refreshResourceNode((DBPProject)rcpProject, member);
                    SQLEditorUtils.EditorsCollection editors = SQLEditorUtils.findResourceEditors((IResource)member);
                    if (editors == null) break;
                    editors.validateEditorInputState();
                    DBPDataSourceContainer fileDsContainer = EditorUtils.getFileDataSource((IFile)((IFile)member));
                    editors.setDataSourceForSqlEditors(fileDsContainer);
                    DBeaverNotifications.showNotification((String)"te.refresh.resources", (String)"Resource was updated", (String)("Resource '" + event.getResourcePath() + "' was changed remotely"), (DBPMessageType)DBPMessageType.INFORMATION, null);
                }
                catch (CoreException | DBException e) {
                    log.error((Object)("Error updating resource '" + String.valueOf(relPath) + "'"), e);
                }
                break;
            }
            case "cb_rm_resource_deleted": {
                IResource folder;
                Path resPath;
                Path resFolderPath = resPath = new Path(event.getResourcePath());
                if (resFolderPath.segmentCount() > 0) {
                    resFolderPath = resFolderPath.removeLastSegments(1);
                }
                if ((folder = rcpProject.getRootResource().findMember((IPath)resFolderPath)) == null) break;
                IResource member = rcpProject.getRootResource().findMember((IPath)new Path(event.getResourcePath()));
                SQLEditorUtils.EditorsCollection editors = SQLEditorUtils.findResourceEditors((IResource)member);
                if (member instanceof IFile && editors != null && !editors.isEmpty()) {
                    UIUtils.asyncExec(() -> EventHandlerResourceUpdate.lambda$0((IPath)resPath, editors));
                }
                try {
                    rcpProject.removeResourceFromCache((IPath)resPath);
                }
                catch (Exception e) {
                    log.error((Object)("Error removing resource '" + String.valueOf(resPath) + "'"), (Throwable)e);
                }
                try {
                    folder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    log.error((Object)("Folder '" + String.valueOf(folder.getFullPath()) + "' in project '" + rcpProject.getName() + "' refresh failed"), (Throwable)e);
                }
                break;
            }
        }
    }

    private void refreshResourceNode(DBPProject project, IResource member) throws DBException {
        DBNModel navigatorModel = project.getNavigatorModel();
        if (navigatorModel == null) {
            return;
        }
        DBNProject projectNode = NavigatorResources.getProjectNode((DBNRoot)navigatorModel.getRoot(), (IProject)member.getProject());
        DBNResource fileNode = NavigatorResources.findResource((DBNNode)projectNode, (IResource)member);
        if (fileNode != null) {
            fileNode.refreshNode((DBRProgressMonitor)new VoidProgressMonitor(), (Object)this);
            fileNode.refreshResourceState((Object)member);
        }
    }

    private static /* synthetic */ void lambda$0(IPath iPath, SQLEditorUtils.EditorsCollection editorsCollection) {
        UIUtils.showMessageBox((Shell)UIUtils.getActiveWorkbenchShell(), (String)TeamMessages.event_handler_resource_deleted_warning_title, (String)NLS.bind((String)TeamMessages.event_handler_resource_deleted_warning_message, (Object)iPath), (int)8);
        editorsCollection.closeNoSave();
    }
}

