/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.workspace.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistryCache;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.websocket.WSEventHandler;
import org.jkiss.dbeaver.model.websocket.event.datasource.WSDataSourceEvent;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.utils.CommonUtils;

public class EventHandlerDataSourceUpdate
implements WSEventHandler<WSDataSourceEvent> {
    private static final Log log = Log.getLog(EventHandlerDataSourceUpdate.class);

    public void handleEvent(@NotNull WSDataSourceEvent event) {
        LinkedHashSet<String> refreshDataSources;
        DBPDataSourceRegistry registry;
        block18: {
            log.debug((Object)(event.getTopicId() + " event handled"));
            DBPProject project = DBWorkbench.getPlatform().getWorkspace().getProjectById(event.getProjectId());
            if (project == null || !project.isOpen()) {
                return;
            }
            registry = project.getDataSourceRegistry();
            refreshDataSources = new LinkedHashSet<String>();
            List dataSourceIds = event.getDataSourceIds();
            if (CommonUtils.isEmpty((Collection)dataSourceIds)) break block18;
            for (String dsId : dataSourceIds) {
                switch (event.getId()) {
                    case "cb_datasource_updated": 
                    case "cb_datasource_created": {
                        refreshDataSources.add(dsId);
                        break;
                    }
                    case "cb_datasource_deleted": {
                        DBPDataSourceContainer dataSource = registry.getDataSource(dsId);
                        if (dataSource == null) break;
                        if (registry instanceof DBPDataSourceRegistryCache) {
                            ((DBPDataSourceRegistryCache)registry).removeDataSourceFromList(dataSource);
                        }
                        if (!dataSource.isConnected()) break;
                        DBeaverNotifications.showNotification((String)"te.refresh.datasource.removed", (String)"Connection was deleted", (String)("Connection '" + dataSource.getName() + "' was deleted remotely"), (DBPMessageType)DBPMessageType.INFORMATION, null);
                        break;
                    }
                }
            }
        }
        if (!refreshDataSources.isEmpty()) {
            registry.refreshConfig(refreshDataSources);
            boolean isShowNotification = false;
            ArrayList<String> dsNames = new ArrayList<String>();
            for (String dsId : refreshDataSources) {
                DBPDataSourceContainer ds = registry.getDataSource(dsId);
                if (ds == null) continue;
                dsNames.add(ds.getName());
                if (isShowNotification) continue;
                isShowNotification = ds.isConnected();
            }
            if (!dsNames.isEmpty() && isShowNotification) {
                DBeaverNotifications.showNotification((String)"te.refresh.datasource.changed", (String)"Connection configuration changed", (String)("The following connections configuration was changed remotely:\n" + String.join((CharSequence)", ", dsNames)), (DBPMessageType)DBPMessageType.INFORMATION, null);
            }
        }
    }
}

