/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui.tasks;

import com.dbeaver.remote.client.tm.model.TMTaskInfoService;
import com.dbeaver.remote.client.tm.model.TMTaskOutputFile;
import com.dbeaver.remote.client.tm.model.TMTaskRun;
import com.dbeaver.remote.workspace.DesktopWorkspaceRemote;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.utils.ByteNumberFormat;

public class ViewTaskFilesDialog
extends BaseDialog {
    private final Log log = Log.getLog(ViewTaskFilesDialog.class);
    private final ByteNumberFormat SIZE_FORMAT = new ByteNumberFormat();
    private final DBTTask task;
    private final TMTaskRun taskRun;
    private CheckboxTreeViewer viewer;

    public ViewTaskFilesDialog(@NotNull Shell shell, @NotNull DBTTask task, @NotNull TMTaskRun taskRun) {
        super(shell, "Task run files", null);
        this.task = task;
        this.taskRun = taskRun;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        UIUtils.createControlLabel((Composite)composite, (String)"Select files you want to download");
        this.viewer = new CheckboxTreeViewer(composite, 67616);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(300, 300).create());
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        });
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this.viewer, 16384);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TMTaskOutputFile file = (TMTaskOutputFile)element;
                return file.getFileName();
            }
        });
        column.getColumn().setText("Name");
        column = new TreeViewerColumn((TreeViewer)this.viewer, 131072);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TMTaskOutputFile file = (TMTaskOutputFile)element;
                return ViewTaskFilesDialog.this.SIZE_FORMAT.format(file.getFileSize());
            }
        });
        column.getColumn().setText("Size");
        this.viewer.setInput((Object)this.taskRun.getOutputFiles());
        this.viewer.addSelectionChangedListener(event -> {
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(this.viewer.getCheckedElements().length > 0);
            }
        });
        UIUtils.asyncExec(() -> UIUtils.packColumns((Tree)this.viewer.getTree(), (boolean)true, (float[])new float[]{0.75f, 0.25f}));
        return composite;
    }

    protected void okPressed() {
        String directory = DialogUtils.openDirectoryDialog((Shell)this.getShell(), (String)"Choose target directory", null);
        if (directory != null) {
            Path path = Path.of(directory, new String[0]);
            Object[] elements = this.viewer.getCheckedElements();
            TMTaskInfoService client = this.getInfoService();
            if (Files.notExists(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.log.error((Object)"Error creating output directories", (Throwable)e);
                }
            }
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                TMTaskOutputFile file = (TMTaskOutputFile)element;
                try {
                    Throwable throwable = null;
                    Object var11_14 = null;
                    try (InputStream is = client.readTaskOutputFile(this.task.getProject().getId(), this.task.getId(), this.taskRun.getId(), file.getFileName());){
                        Files.copy(is, path.resolve(file.getFileName()), new CopyOption[0]);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Error downloading output file", (Throwable)e);
                }
                ++n2;
            }
            ShellUtils.launchProgram((String)directory);
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Download", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    @NotNull
    private TMTaskInfoService getInfoService() {
        DesktopWorkspaceRemote workspace = (DesktopWorkspaceRemote)this.task.getProject().getWorkspace();
        return Objects.requireNonNull(workspace.getTaskInfoService(), "Task info client not found");
    }
}

