/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui;

import com.dbeaver.team.ui.internal.TeamMessages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.statushandlers.StatusManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class WizardProjectsImportToTEPage
extends WizardDataTransferPage {
    private static final String STORE_DIRECTORIES = "STORE_DIRECTORIES";
    private static final String STORE_ARCHIVES = "STORE_ARCHIVES";
    private static final String STORE_ARCHIVE_SELECTED = "STORE_ARCHIVE_SELECTED";
    @Nullable
    private ILeveledImportStructureProvider structureProvider;
    @Nullable
    private Combo directoryPathField;
    @Nullable
    private CheckboxTreeViewer projectsList;
    @NotNull
    private final List<ProjectRecord> displayedProjects = new ArrayList<ProjectRecord>();
    @NotNull
    private static String previouslyBrowsedDirectory = "";
    @NotNull
    private static String previouslyBrowsedArchive = "";
    @Nullable
    private Button projectFromDirectoryRadio;
    @Nullable
    private Button projectFromArchiveRadio;
    @Nullable
    private Combo archivePathField;
    @Nullable
    private Button browseButton;
    @Nullable
    private Button browseArchivesButton;
    @Nullable
    private Text newProjectNameText;
    @Nullable
    private Text newProjectDescriptionText;
    @Nullable
    private Button importSecretsCheckbox;
    @Nullable
    private String lastPath;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    @Nullable
    private String initialPath;
    @Nullable
    private String statusMessage = null;
    private boolean isUpdatingProjectsList;

    public WizardProjectsImportToTEPage() {
        this("wizardExternalProjectsPage", null, null);
    }

    public WizardProjectsImportToTEPage(@NotNull String pageName) {
        this(pageName, null, null);
    }

    public WizardProjectsImportToTEPage(@NotNull String pageName, @Nullable String initialPath, @Nullable IStructuredSelection currentSelection) {
        super(pageName);
        if (initialPath != null) {
            this.initialPath = initialPath;
        } else if (currentSelection != null) {
            Object firstElement = currentSelection.getFirstElement();
            if (firstElement instanceof File) {
                this.initialPath = ((File)firstElement).getAbsolutePath();
            } else if (firstElement instanceof IResource) {
                this.initialPath = ((IResource)firstElement).getLocation().toFile().getAbsolutePath();
            } else if (firstElement instanceof String && new File((String)firstElement).exists()) {
                this.initialPath = new File((String)firstElement).getAbsolutePath();
            }
        }
        this.setPageComplete(false);
        this.setTitle(TeamMessages.import_project_wizard_title);
        this.setDescription(TeamMessages.import_project_wizard_description);
    }

    public void createControl(@NotNull Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
        this.createOptionsGroup(workArea);
        this.createTargetProjectGroup(workArea);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createTargetProjectGroup(@NotNull Composite workArea) {
        Group targetProjectGroup = new Group(workArea, 0);
        targetProjectGroup.setFont(workArea.getFont());
        targetProjectGroup.setText(TeamMessages.import_project_wizard_target_project_label);
        targetProjectGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        targetProjectGroup.setLayout((Layout)new GridLayout(1, false));
        Composite projectNameGroup = UIUtils.createComposite((Composite)targetProjectGroup, (int)2);
        projectNameGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        this.newProjectNameText = UIUtils.createLabelText((Composite)projectNameGroup, (String)TeamMessages.import_project_wizard_new_project_name_label, (String)"");
        this.newProjectDescriptionText = UIUtils.createLabelText((Composite)projectNameGroup, (String)TeamMessages.import_project_wizard_new_project_description_label, (String)"");
        this.newProjectNameText.addModifyListener(e -> {
            if (this.projectsList != null) {
                this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
                if (this.getMessage().equals(TeamMessages.import_project_wizard_name_not_set_error_message)) {
                    this.setMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
                }
            }
        });
    }

    protected void createOptionsGroupButtons(@NotNull Group optionsGroup) {
        this.importSecretsCheckbox = new Button((Composite)optionsGroup, 32);
        this.importSecretsCheckbox.setText(TeamMessages.import_project_wizard_import_secrets_label);
        this.importSecretsCheckbox.setToolTipText(TeamMessages.import_project_wizard_import_secrets_tooltip);
        this.importSecretsCheckbox.setLayoutData((Object)new GridData(768));
        this.importSecretsCheckbox.setSelection(false);
    }

    private void createProjectsList(@NotNull Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText(TeamMessages.import_project_wizard_source_project_label + " ");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        Composite listComposite = new Composite(workArea, 0);
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(listComposite, 2052);
        this.projectsList.setUseHashlookup(true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return WizardProjectsImportToTEPage.this.displayedProjects.toArray();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.addCheckStateListener(event -> {
            if (event.getChecked()) {
                ProjectRecord element = (ProjectRecord)event.getElement();
                if (element.isInvalid) {
                    this.projectsList.setChecked((Object)element, false);
                } else if (this.newProjectNameText != null) {
                    String currentNewProjectName = this.newProjectNameText.getText();
                    String currentlySelectedProjectName = Arrays.stream(this.projectsList.getCheckedElements()).filter(p -> p != element).findFirst().map(p -> {
                        String string;
                        if (p instanceof ProjectRecord) {
                            ProjectRecord r = (ProjectRecord)p;
                            string = r.projectName;
                        } else {
                            string = "";
                        }
                        return string;
                    }).orElse("");
                    if (CommonUtils.isEmpty((String)currentNewProjectName) || currentlySelectedProjectName.equalsIgnoreCase(currentNewProjectName)) {
                        this.newProjectNameText.setText(element.getProjectName());
                    }
                    this.projectsList.setCheckedElements(new Object[]{element});
                }
            }
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(listComposite);
    }

    private void createSelectionButtons(@NotNull Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText(DataTransferMessages.DataTransfer_refresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardProjectsImportToTEPage.this.projectFromDirectoryRadio != null && WizardProjectsImportToTEPage.this.directoryPathField != null && WizardProjectsImportToTEPage.this.projectFromDirectoryRadio.getSelection()) {
                    WizardProjectsImportToTEPage.this.updateProjectsListAndPreventFocusLostHandling(WizardProjectsImportToTEPage.this.directoryPathField.getText().trim(), true);
                } else if (WizardProjectsImportToTEPage.this.archivePathField != null) {
                    WizardProjectsImportToTEPage.this.updateProjectsListAndPreventFocusLostHandling(WizardProjectsImportToTEPage.this.archivePathField.getText().trim(), true);
                }
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    private void createProjectsRoot(@NotNull Composite workArea) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        Composite projectGroup = new Composite(workArea, 0);
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(projectGroup, 16);
        this.projectFromDirectoryRadio.setText(DataTransferMessages.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Combo(projectGroup, 2048);
        this.browseButton = new Button(projectGroup, 8);
        this.createBrowsePathControls(this.directoryPathField, this.browseButton);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportToTEPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.projectFromArchiveRadio = new Button(projectGroup, 16);
        this.projectFromArchiveRadio.setText(DataTransferMessages.WizardProjectsImportPage_ArchiveSelectTitle);
        this.archivePathField = new Combo(projectGroup, 2048);
        this.browseArchivesButton = new Button(projectGroup, 8);
        this.createBrowsePathControls(this.archivePathField, this.browseArchivesButton);
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportToTEPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportToTEPage.this.directoryRadioSelected();
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportToTEPage.this.archiveRadioSelected();
            }
        });
    }

    private void createBrowsePathControls(final @NotNull Combo pathField, @NotNull Button browseButton) {
        GridData pathData = new GridData(768);
        pathData.widthHint = new PixelConverter((Control)pathField).convertWidthInCharsToPixels(25);
        pathField.setLayoutData((Object)pathData);
        browseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(browseButton);
        pathField.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
                this.updateProjectsList(pathField.getText().trim());
            }
        });
        pathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!WizardProjectsImportToTEPage.this.isUpdatingProjectsList) {
                    WizardProjectsImportToTEPage.this.updateProjectsList(pathField.getText().trim());
                }
            }
        });
        pathField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportToTEPage.this.updateProjectsList(pathField.getText().trim());
            }
        });
    }

    private void archiveRadioSelected() {
        if (this.projectFromArchiveRadio != null && this.projectFromArchiveRadio.getSelection()) {
            if (this.directoryPathField != null) {
                this.directoryPathField.setEnabled(false);
            }
            if (this.browseButton != null) {
                this.browseButton.setEnabled(false);
            }
            if (this.browseArchivesButton != null) {
                this.browseArchivesButton.setEnabled(true);
            }
            if (this.archivePathField != null) {
                this.archivePathField.setEnabled(true);
                if (this.archivePathField.getItemCount() > 0 && this.archivePathField.getText().isEmpty()) {
                    this.archivePathField.setText(this.archivePathField.getItem(0));
                }
                this.updateProjectsList(this.archivePathField.getText());
                this.archivePathField.setFocus();
            }
        }
    }

    private void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio != null && this.projectFromDirectoryRadio.getSelection()) {
            if (this.browseButton != null) {
                this.browseButton.setEnabled(true);
            }
            if (this.archivePathField != null) {
                this.archivePathField.setEnabled(false);
            }
            if (this.browseArchivesButton != null) {
                this.browseArchivesButton.setEnabled(false);
            }
            if (this.directoryPathField != null) {
                this.directoryPathField.setEnabled(true);
                if (this.directoryPathField.getItemCount() > 0 && this.directoryPathField.getText().isEmpty()) {
                    this.directoryPathField.setText(this.directoryPathField.getItem(0));
                }
                this.updateProjectsList(this.directoryPathField.getText());
                this.directoryPathField.setFocus();
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.projectFromDirectoryRadio != null && this.projectFromDirectoryRadio.getSelection() && this.directoryPathField != null) {
            this.directoryPathField.setFocus();
        }
        if (visible && this.projectFromArchiveRadio != null && this.projectFromArchiveRadio.getSelection() && this.archivePathField != null) {
            this.archivePathField.setFocus();
        }
    }

    private void updateProjectsList(@Nullable String path) {
        this.updateProjectsListAndPreventFocusLostHandling(path, false);
    }

    private void updateProjectsListAndPreventFocusLostHandling(@Nullable String path, boolean forceUpdate) {
        this.isUpdatingProjectsList = true;
        try {
            this.updateProjectsList(path, forceUpdate);
        }
        finally {
            this.isUpdatingProjectsList = false;
        }
    }

    private void updateProjectsList(@Nullable String path, boolean forceUpdate) {
        if (path == null || path.isEmpty()) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
            this.displayedProjects.clear();
            if (this.projectsList != null) {
                this.projectsList.refresh(true);
                this.projectsList.setCheckedElements((Object[])new ProjectRecord[0]);
            }
            this.setPageComplete(false);
            this.lastPath = path;
            return;
        }
        File directory = new File(path);
        if (path.equals(this.lastPath) && !forceUpdate) {
            return;
        }
        if (this.projectFromDirectoryRadio != null) {
            boolean dirSelected = this.projectFromDirectoryRadio.getSelection();
            try {
                this.getContainer().run(true, true, monitor -> {
                    monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_SearchingMessage, 100);
                    this.displayedProjects.clear();
                    monitor.worked(10);
                    if (dirSelected) {
                        this.structureProvider = null;
                    } else if (ArchiveFileManipulations.isTarFile((String)path)) {
                        TarFile sourceTarFile = this.getSpecifiedTarSourceFile(path);
                        if (sourceTarFile != null) {
                            this.structureProvider = new TarLeveledStructureProvider(sourceTarFile);
                        }
                    } else if (ArchiveFileManipulations.isZipFile((String)path)) {
                        ZipFile sourceFile = this.getSpecifiedZipSourceFile(path);
                        if (sourceFile != null) {
                            this.structureProvider = new ZipLeveledStructureProvider(sourceFile);
                        }
                    } else {
                        this.structureProvider = null;
                    }
                    monitor.worked(50);
                    monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                    if (dirSelected && directory.isDirectory()) {
                        WizardProjectsImportToTEPage.collectProjectFilesFromDirectory(this.displayedProjects, directory, new HashSet<String>(), monitor);
                    } else if (this.structureProvider != null) {
                        WizardProjectsImportToTEPage.collectProjectFilesFromProvider(this.structureProvider, this.displayedProjects, this.structureProvider.getRoot(), 0, monitor);
                    }
                    monitor.done();
                });
            }
            catch (InvocationTargetException e) {
                IDEWorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.lastPath = path;
        this.updateProjectsAndStatus();
    }

    public void dispose() {
        super.dispose();
        if (this.structureProvider != null) {
            try {
                this.structureProvider.close();
            }
            catch (Exception exception) {}
        }
    }

    private void updateProjectsAndStatus() {
        if (this.projectsList == null) {
            return;
        }
        this.projectsList.refresh(true);
        for (ProjectRecord project : this.displayedProjects) {
            if (!project.isInvalid) continue;
            this.projectsList.setGrayed((Object)project, true);
        }
        Optional<ProjectRecord> firstValidProject = this.displayedProjects.stream().filter(p -> !p.isInvalid).findFirst();
        firstValidProject.ifPresent(projectRecord -> {
            boolean bl = this.projectsList.setChecked(projectRecord, true);
        });
        this.updateStatus();
    }

    public boolean updateStatus() {
        this.statusMessage = null;
        if (this.newProjectNameText == null) {
            return false;
        }
        String newProjectName = this.newProjectNameText.getText();
        String projectNameError = this.validateNewProjectName(newProjectName);
        boolean projectAlreadyExists = this.isProjectInWorkspacePath(newProjectName) || this.isProjectInWorkspace(newProjectName);
        boolean displayInvalidWarning = this.displayedProjects.stream().anyMatch(p -> p.isInvalid);
        if (projectNameError != null) {
            this.setStatusMessage(projectNameError, 3);
        } else if (projectAlreadyExists) {
            this.setStatusMessage(TeamMessages.import_project_wizard_project_exists_error_message, 3);
        } else if (displayInvalidWarning) {
            this.setStatusMessage(DataTransferMessages.WizardProjectsImportPage_projectsInvalid, 2);
        } else if (this.getSelectedProject().isEmpty()) {
            this.setStatusMessage(TeamMessages.import_project_wizard_no_project_selected_error_message, 3);
        } else {
            this.setStatusMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription, 0);
        }
        boolean isOk = this.getSelectedProject().isPresent() && projectNameError == null && !projectAlreadyExists;
        this.setPageComplete(isOk);
        if (this.displayedProjects.isEmpty()) {
            this.setStatusMessage(DataTransferMessages.WizardProjectsImportPage_noProjectsToImport, 2);
        }
        return isOk;
    }

    private void setStatusMessage(@NotNull String message, int type) {
        this.statusMessage = message;
        this.setMessage(message, type);
    }

    @Nullable
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Nullable
    private String validateNewProjectName(@Nullable String newProjectName) {
        if (CommonUtils.isEmpty((String)newProjectName)) {
            return TeamMessages.import_project_wizard_name_not_set_error_message;
        }
        try {
            GeneralUtils.validateResourceName((String)newProjectName);
            return null;
        }
        catch (DBException ex) {
            return "Invalid project name: " + ex.getMessage();
        }
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.isEmpty()) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        if (this.archivePathField != null) {
            this.archivePathField.setFocus();
        }
        return null;
    }

    private TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.isEmpty()) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (TarException tarException) {
            this.displayErrorDialog(DataTransferMessages.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        if (this.archivePathField != null) {
            this.archivePathField.setFocus();
        }
        return null;
    }

    static boolean collectProjectFilesFromDirectory(@NotNull Collection<ProjectRecord> projectDescrFiles, @NotNull File directory, @NotNull Set<String> directoriesVisited, @NotNull IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        try {
            if (!directoriesVisited.add(directory.getCanonicalPath())) {
                return false;
            }
        }
        catch (IOException exception) {
            StatusManager.getManager().handle(StatusUtil.newError((Throwable)exception));
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents != null) {
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    if (!file.getName().equals(".metadata")) {
                        WizardProjectsImportToTEPage.collectProjectFilesFromDirectory(projectDescrFiles, file, directoriesVisited, monitor);
                    }
                } else if (file.getName().equals(".project") && file.isFile()) {
                    projectDescrFiles.add(new ProjectRecord(file));
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private static boolean collectProjectFilesFromProvider(@NotNull ILeveledImportStructureProvider structureProvider, @NotNull Collection<ProjectRecord> files, @NotNull Object entry, int level, @NotNull IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)structureProvider.getLabel(entry)));
        List children = structureProvider.getChildren(entry);
        if (children != null) {
            for (Object child : children) {
                if (structureProvider.isFolder(child)) {
                    WizardProjectsImportToTEPage.collectProjectFilesFromProvider(structureProvider, files, child, level + 1, monitor);
                    continue;
                }
                String elementLabel = structureProvider.getLabel(child);
                if (!elementLabel.equals(".project")) continue;
                files.add(new ProjectRecord(structureProvider, child, entry, level));
            }
        }
        return true;
    }

    protected void handleLocationDirectoryButtonPressed() {
        if (this.directoryPathField == null) {
            return;
        }
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell(), 0x10000000);
        dialog.setMessage(DataTransferMessages.WizardProjectsImportPage_SelectDialogTitle);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.isEmpty()) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.isEmpty()) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(IPath.fromOSString((String)dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
        }
    }

    protected void handleLocationArchiveButtonPressed() {
        if (this.archivePathField == null) {
            return;
        }
        FileDialog dialog = new FileDialog(this.archivePathField.getShell(), 0x10000000);
        dialog.setFilterExtensions(FILE_IMPORT_MASK);
        dialog.setText(DataTransferMessages.WizardProjectsImportPage_SelectArchiveDialogTitle);
        String fileName = this.archivePathField.getText().trim();
        if (fileName.isEmpty()) {
            fileName = previouslyBrowsedArchive;
        }
        if (fileName.isEmpty()) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(fileName).getParentFile();
            if (path != null && path.exists()) {
                dialog.setFilterPath(path.toString());
            }
        }
        String selectedArchive = dialog.open();
        if (selectedArchive != null) {
            previouslyBrowsedArchive = selectedArchive;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList(selectedArchive);
        }
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
    }

    private boolean isProjectInWorkspacePath(@NotNull String projectName) {
        IPath wsPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IPath localProjectPath = wsPath.append(projectName);
        return localProjectPath.toFile().exists();
    }

    private boolean isProjectInWorkspace(@Nullable String projectName) {
        IProject[] workspaceProjects;
        if (projectName == null) {
            return false;
        }
        IProject[] iProjectArray = workspaceProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        int n = workspaceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject workspaceProject = iProjectArray[n2];
            if (projectName.equalsIgnoreCase(workspaceProject.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.directoryPathField != null && this.archivePathField != null) {
            this.restoreFromHistory(settings, STORE_DIRECTORIES, this.directoryPathField);
            this.restoreFromHistory(settings, STORE_ARCHIVES, this.archivePathField);
        }
        if (this.initialPath == null && settings != null && this.projectFromDirectoryRadio != null && this.projectFromArchiveRadio != null) {
            boolean archiveSelected = settings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!archiveSelected);
            this.projectFromArchiveRadio.setSelection(archiveSelected);
            if (archiveSelected) {
                this.archiveRadioSelected();
            } else {
                this.directoryRadioSelected();
            }
        } else if (this.initialPath != null && this.projectFromDirectoryRadio != null && this.projectFromArchiveRadio != null) {
            boolean dir = new File(this.initialPath).isDirectory();
            this.projectFromDirectoryRadio.setSelection(dir);
            this.projectFromArchiveRadio.setSelection(!dir);
            if (dir && this.directoryPathField != null) {
                this.directoryPathField.setText(this.initialPath);
                this.directoryPathField.setSelection(new Point(this.initialPath.length(), this.initialPath.length()));
                this.directoryRadioSelected();
            } else if (this.archivePathField != null) {
                this.archivePathField.setText(this.initialPath);
                this.archivePathField.setSelection(new Point(this.initialPath.length(), this.initialPath.length()));
                this.archiveRadioSelected();
            }
        }
    }

    private void restoreFromHistory(@NotNull IDialogSettings settings, @NotNull String key, @NotNull Combo combo) {
        String[] sourceNames = settings.getArray(key);
        if (sourceNames == null) {
            return;
        }
        String[] stringArray = sourceNames;
        int n = sourceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceName = stringArray[n2];
            combo.add(sourceName);
            ++n2;
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.directoryPathField != null) {
                this.saveInHistory(settings, STORE_DIRECTORIES, this.directoryPathField.getText());
            }
            if (this.archivePathField != null) {
                this.saveInHistory(settings, STORE_ARCHIVES, this.archivePathField.getText());
            }
            if (this.projectFromArchiveRadio != null) {
                settings.put(STORE_ARCHIVE_SELECTED, this.projectFromArchiveRadio.getSelection());
            }
        }
    }

    private void saveInHistory(@NotNull IDialogSettings settings, @NotNull String key, @NotNull String value) {
        String[] sourceNames = settings.getArray(key);
        if (sourceNames == null) {
            sourceNames = new String[]{};
        }
        sourceNames = this.addToHistory(sourceNames, value);
        settings.put(key, sourceNames);
    }

    public void handleEvent(Event event) {
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    @NotNull
    public ProjectImportParameters getImportParameters() {
        return new ProjectImportParameters(this.structureProvider, this.getSelectedProject().orElse(null), this.newProjectNameText == null ? "" : this.newProjectNameText.getText(), this.newProjectDescriptionText == null ? "" : this.newProjectDescriptionText.getText(), this.importSecretsCheckbox != null && this.importSecretsCheckbox.getSelection());
    }

    @NotNull
    public Optional<ProjectRecord> getSelectedProject() {
        Optional<ProjectRecord> optional;
        Object object;
        if (this.projectsList == null) {
            return Optional.empty();
        }
        Object[] currentProjectItems = this.projectsList.getCheckedElements();
        if (currentProjectItems.length > 0 && (object = currentProjectItems[0]) instanceof ProjectRecord) {
            ProjectRecord p = (ProjectRecord)object;
            optional = Optional.of(p);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public record ProjectImportParameters(@Nullable ILeveledImportStructureProvider structureProvider, @Nullable ProjectRecord project, @NotNull String newProjectName, @NotNull String newProjectDescription, boolean importSecrets) {
    }

    private final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ProjectLabelProvider() {
        }

        public String getText(@NotNull Object element) {
            return ((ProjectRecord)element).getProjectLabel();
        }

        public Color getBackground(@Nullable Object element) {
            return null;
        }

        public Color getForeground(@NotNull Object element) {
            ProjectRecord projectRecord = (ProjectRecord)element;
            if (projectRecord.isInvalid) {
                return WizardProjectsImportToTEPage.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }
    }

    public static class ProjectRecord {
        @Nullable
        File projectSystemFile;
        @Nullable
        Object projectArchiveFile;
        @Nullable
        String projectName;
        @Nullable
        Object parent;
        int level;
        boolean isInvalid = false;
        IProjectDescription description;
        ILeveledImportStructureProvider structureProvider;

        ProjectRecord(@NotNull File file) {
            this.projectSystemFile = file;
            this.initialize();
        }

        ProjectRecord(@NotNull ILeveledImportStructureProvider structureProvider, @NotNull Object file, @NotNull Object parent, int level) {
            this.structureProvider = structureProvider;
            this.projectArchiveFile = file;
            this.parent = parent;
            this.level = level;
            this.initialize();
        }

        private void initialize() {
            try {
                IProjectDescription originalDescription = this.findOriginalProjectDescription();
                if (originalDescription != null) {
                    this.description = originalDescription;
                    this.projectName = originalDescription.getName();
                    this.isInvalid = !this.isLocalDBeaverProject(originalDescription);
                } else {
                    this.isInvalid = true;
                }
                if (CommonUtils.isEmpty((String)this.projectName)) {
                    this.projectName = this.recoverProjectName();
                }
            }
            catch (IOException | CoreException throwable) {
                this.projectName = DataTransferMessages.WizardProjectsImportPage_invalidProjectName;
                this.isInvalid = true;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String recoverProjectName() {
            if (this.projectSystemFile != null) {
                IPath path = IPath.fromOSString((String)this.projectSystemFile.getPath());
                return path.segment(path.segmentCount() - 2);
            }
            if (this.projectArchiveFile == null) throw new UnsupportedOperationException("Unsupported kind of project entry");
            Object object = this.projectArchiveFile;
            if (object instanceof ZipEntry) {
                ZipEntry zipEntry = (ZipEntry)object;
                IPath path = IPath.fromOSString((String)zipEntry.getName());
                return path.segment(path.segmentCount() - 2);
            }
            Object object2 = this.projectArchiveFile;
            if (!(object2 instanceof TarEntry)) throw new UnsupportedOperationException("Unsupported archive kind");
            TarEntry tarEntry = (TarEntry)object2;
            IPath path = IPath.fromOSString((String)tarEntry.getName());
            return path.segment(path.segmentCount() - 2);
        }

        @Nullable
        private IProjectDescription findOriginalProjectDescription() throws CoreException, IOException {
            IProjectDescription orignalDescription;
            if (this.projectSystemFile != null) {
                orignalDescription = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription(IPath.fromOSString((String)this.projectSystemFile.getPath()));
            } else if (this.projectArchiveFile != null) {
                Throwable throwable = null;
                Object var3_4 = null;
                try (InputStream stream = this.structureProvider.getContents(this.projectArchiveFile);){
                    if (stream != null) {
                        orignalDescription = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription(stream);
                    }
                    orignalDescription = null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            } else {
                orignalDescription = null;
            }
            return orignalDescription;
        }

        private boolean isLocalDBeaverProject(IProjectDescription projectDescription) {
            Set<String> natureIds = Set.of(projectDescription.getNatureIds());
            return natureIds.contains("org.jkiss.dbeaver.DBeaverNature") && !natureIds.contains("com.dbeaver.DBeaverRemote");
        }

        @Nullable
        public String getProjectName() {
            return this.projectName;
        }

        public boolean isInvalidProject() {
            return this.isInvalid;
        }

        public String getProjectLabel() {
            String path = this.projectSystemFile == null ? this.structureProvider.getFullPath(this.parent) : this.projectSystemFile.getParent();
            return NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_projectLabel, (Object)this.projectName, (Object)path);
        }
    }
}

