/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui;

import com.dbeaver.model.auth.SMAuthPromptConfiguration;
import com.dbeaver.team.auth.DCConfiguration;
import com.dbeaver.team.ui.AuthProviderPromptDialog;
import com.dbeaver.team.ui.ServerAddressDialog;
import javax.security.auth.callback.TextOutputCallback;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBInterruptedException;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class TeamAuthUI {
    private static final Log log = Log.getLog(TeamAuthUI.class);

    @NotNull
    public static Shell getActiveShell() {
        Shell activeShell;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if ((activeShell = display.getActiveShell()) != null) {
            return activeShell;
        }
        Shell shell = new Shell(display, 16416);
        shell.setText(GeneralUtils.getProductTitle());
        return shell;
    }

    public static SMAuthPromptConfiguration doProviderAuthentication(final @NotNull SMAuthPromptConfiguration promptConfiguration, final @NotNull DCConfiguration dcConfiguration) throws DBInterruptedException {
        SMAuthPromptConfiguration result = (SMAuthPromptConfiguration)new UITask<SMAuthPromptConfiguration>(){

            protected SMAuthPromptConfiguration runTask() {
                Shell shell = TeamAuthUI.getActiveShell();
                AuthProviderPromptDialog dialog = new AuthProviderPromptDialog((Shell)(shell.isVisible() ? shell : null), promptConfiguration, dcConfiguration);
                SMAuthPromptConfiguration result = null;
                if (dialog.open() == 0) {
                    result = dialog.getPromptConfiguration();
                }
                return result;
            }
        }.execute();
        if (result == null) {
            throw new DBInterruptedException("Authentication has been canceled");
        }
        return result;
    }

    public static void showInformationMessage(int type, String message) {
        try {
            UIUtils.showMessageBox((Shell)WorkbenchPlugin.getSplashShell((Display)Display.getCurrent()), (String)message, (String)message, (int)type);
        }
        catch (Exception exception) {
            log.error((Object)message);
        }
    }

    public static void showInformationMessage(TextOutputCallback callback) {
        TextOutputCallback message = callback;
        int iconType = switch (message.getMessageType()) {
            case 0 -> 2;
            case 1 -> 8;
            case 2 -> 1;
            default -> 1;
        };
        try {
            UIUtils.showMessageBox((Shell)WorkbenchPlugin.getSplashShell((Display)Display.getCurrent()), (String)message.getMessage(), (String)message.getMessage(), (int)iconType);
        }
        catch (Exception exception) {
            log.error((Object)message);
        }
    }

    public static String showParameterPrompt(String serverAddr) {
        Shell shell = TeamAuthUI.getActiveShell();
        try {
            ServerAddressDialog enterNameDialog = new ServerAddressDialog(shell, serverAddr);
            if (enterNameDialog.open() != 0) {
                return null;
            }
            String string = enterNameDialog.getResult();
            return string;
        }
        finally {
            shell.dispose();
        }
    }

    public static String stripServerURL(String url) {
        int divPos = url.indexOf("://");
        if (divPos != -1) {
            url = url.substring(divPos + 3);
        }
        if ((divPos = url.indexOf(47)) != -1) {
            url = url.substring(0, divPos);
        }
        return url;
    }
}

