/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui;

import com.dbeaver.ee.runtime.auth.CredentialsCallback;
import com.dbeaver.ee.runtime.auth.URLCallback;
import com.dbeaver.team.ui.TeamAuthUI;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.dialogs.BaseAuthDialog;

public class TeamAuthCallbackHandler
implements CallbackHandler {
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        Callback[] callbackArray = callbacks;
        int n = callbacks.length;
        int n2 = 0;
        while (n2 < n) {
            Callback callback = callbackArray[n2];
            if (callback instanceof CredentialsCallback) {
                CredentialsCallback cc = (CredentialsCallback)callback;
                this.doSimpleAuthentication(cc);
            } else if (callback instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callback;
                TeamAuthUI.showInformationMessage(toc);
            } else if (callback instanceof URLCallback) {
                URLCallback urlCallback = (URLCallback)callback;
                ShellUtils.launchProgram((String)urlCallback.getUrl());
            } else {
                throw new UnsupportedCallbackException(callback);
            }
            ++n2;
        }
    }

    private void doSimpleAuthentication(CredentialsCallback credentials) throws IOException {
        DBPAuthInfo info = this.showCredentialsPrompt(credentials.getUsername(), credentials.getPassword());
        if (info == null) {
            throw new IOException("Authentication has been canceled");
        }
        credentials.setUsername(info.getUserName());
        credentials.setPassword(info.getUserPassword());
    }

    @Nullable
    private DBPAuthInfo showCredentialsPrompt(final @Nullable String username, final @Nullable String password) {
        return (DBPAuthInfo)new UITask<DBPAuthInfo>(){

            protected DBPAuthInfo runTask() {
                BaseAuthDialog authDialog = new BaseAuthDialog(TeamAuthUI.getActiveShell(), "Enter credentials", false, false);
                authDialog.setUserName(username);
                authDialog.setUserPassword(password);
                if (authDialog.open() == 0) {
                    return authDialog.getAuthInfo();
                }
                return null;
            }
        }.execute();
    }
}

