/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui;

import com.dbeaver.team.ui.SharedCredentialsManageDialog;
import com.dbeaver.team.workspace.TeamWorkspaceImpl;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.AuthModelSelector;
import org.jkiss.utils.CommonUtils;

public class SharedCredentialsConfigurator
implements IObjectPropertyConfigurator<Object, DBPDataSourceContainer> {
    protected Button sharedCredentialsCheck;

    public void createControl(final @NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        TeamWorkspaceImpl tw;
        boolean allowsSharedCredentials;
        AuthModelSelector ams;
        if (!(object instanceof AuthModelSelector) || (ams = (AuthModelSelector)object).getActiveDataSource() == null) {
            UIUtils.createEmptyLabel((Composite)parent, (int)1, (int)1);
            return;
        }
        final DBPDataSourceContainer activeDataSource = ams.getActiveDataSource();
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        boolean bl = allowsSharedCredentials = DBWorkbench.isDistributed() && !activeDataSource.getProject().isPrivateProject();
        if (!allowsSharedCredentials || !workspace.hasRealmPermission("database-developer")) {
            UIUtils.createEmptyLabel((Composite)parent, (int)1, (int)1);
            return;
        }
        Composite authModelComp = UIUtils.createComposite((Composite)parent, (int)2);
        this.sharedCredentialsCheck = UIUtils.createCheckbox((Composite)authModelComp, (String)"Share credentials", (!ams.isAuthSettingsEnabled() ? 1 : 0) != 0);
        this.sharedCredentialsCheck.setToolTipText("Saved credentials will be accessible to all users who have access to this connection configuration");
        this.sharedCredentialsCheck.setLayoutData((Object)new GridData(128));
        if (workspace instanceof TeamWorkspaceImpl && (tw = (TeamWorkspaceImpl)workspace).isAdmin()) {
            UIUtils.createPushButton((Composite)authModelComp, (String)"Manage", null, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)activeDataSource.getProject());
                        if (!CommonUtils.isBitSet((long)secretController.getSupportedFeatures(), (long)8L)) {
                            UIUtils.showMessageBox((Shell)parent.getShell(), (String)"Manage restricted", (String)"Shared credentials edit is not supported by the active secret controller", (int)1);
                            return;
                        }
                    }
                    catch (DBException ex) {
                        DBWorkbench.getPlatformUI().showError("Manage failed", null, (Throwable)ex);
                        return;
                    }
                    DBPDataSourceContainer originalDS = activeDataSource.getRegistry().getDataSource(activeDataSource.getId());
                    if (originalDS == null) {
                        UIUtils.showMessageBox((Shell)parent.getShell(), (String)"Manage restricted", (String)"You must create and save database connection before you can manage shared credentials", (int)1);
                        return;
                    }
                    if (!originalDS.isSharedCredentials()) {
                        if (!UIUtils.confirmAction((String)"Save connection", (String)"You must save connection settings to be able to manage team credentials. Confirm?")) {
                            return;
                        }
                        originalDS.setSharedCredentials(true);
                        originalDS.persistConfiguration();
                        activeDataSource.setSharedCredentials(true);
                    }
                    SharedCredentialsConfigurator.this.manageCredentials(parent.getShell(), activeDataSource);
                }
            });
        } else {
            this.sharedCredentialsCheck.setEnabled(false);
        }
        ams.enableAuthSettings(!this.sharedCredentialsCheck.getSelection(), false);
    }

    private boolean manageCredentials(Shell shell, DBPDataSourceContainer dataSource) {
        SharedCredentialsManageDialog dialog = new SharedCredentialsManageDialog(shell, dataSource);
        return dialog.open() == 0;
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        if (this.sharedCredentialsCheck != null) {
            this.sharedCredentialsCheck.setSelection(dataSourceContainer.isSharedCredentials());
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        if (this.sharedCredentialsCheck != null) {
            dataSourceContainer.setSharedCredentials(this.sharedCredentialsCheck.getSelection());
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
    }

    public boolean isComplete() {
        return true;
    }
}

