/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui;

import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.model.auth.SMServerAPI;
import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.model.license.app.DBPApplicationLicensed;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.workspace.DesktopWorkspaceRemote;
import com.dbeaver.team.application.internal.TeamAppMessages;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.auth.SMAuthConfigurationReference;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.security.user.SMAuthPermissions;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.DurationFormat;
import org.jkiss.dbeaver.utils.DurationFormatter;
import org.jkiss.utils.CommonUtils;

public class SessionInformationDialog
extends BaseDialog {
    private static final Log log = Log.getLog(DataSourceDescriptor.class);
    private final SMSession session;

    public SessionInformationDialog(@Nullable Shell shell, @NotNull SMSession session) {
        super(shell, TeamAppMessages.dialog_session_information_title, null);
        this.session = session;
    }

    protected Composite createDialogArea(Composite parent) {
        SMServerAPI serverAPI;
        Group group;
        List authInfo;
        Composite composite;
        block21: {
            DesktopWorkspaceRemote workspace;
            Map configuration;
            composite = super.createDialogArea(parent);
            authInfo = null;
            SMSession sMSession = this.session;
            if (sMSession instanceof SMSessionRemote) {
                SMSessionRemote sr = (SMSessionRemote)sMSession;
                authInfo = sr.getAuthInfos();
            }
            if (CommonUtils.isEmpty(authInfo)) {
                UIUtils.createLabel((Composite)composite, (String)"Not authenticated");
                return composite;
            }
            SMAuthPermissions authPermissions = ((SMAuthInfo)authInfo.get(0)).getAuthPermissions();
            Group group2 = UIUtils.createControlGroup((Composite)composite, (String)TeamAppMessages.dialog_session_information_general_title, (int)2, (int)1808, (int)0);
            DBPApplicationLicensed licensedApplication = DBPApplicationLicensed.getLicensedApplication();
            try {
                LMLicense license = licensedApplication.getLicenseService().getActiveProductLicense(false);
                if (license != null) {
                    UIUtils.createLabelText((Composite)group2, (String)TeamAppMessages.dialog_session_information_general_company_label, (String)CommonUtils.notEmpty((String)license.getOwnerCompany()), (int)2056);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            if (authPermissions != null) {
                UIUtils.createLabelText((Composite)group2, (String)TeamAppMessages.dialog_session_information_general_user_id_label, (String)authPermissions.getUserId(), (int)2056);
                UIUtils.createLabelText((Composite)group2, (String)"User role", (String)CommonUtils.notEmpty((String)((SMAuthInfo)authInfo.get(0)).getAuthRole()), (int)2056);
            }
            if ((configuration = (workspace = (DesktopWorkspaceRemote)this.session.getSessionSpace()).getUserConfiguration().getUserMetaParameters()).isEmpty()) break block21;
            group = UIUtils.createControlGroup((Composite)composite, (String)TeamAppMessages.dialog_session_information_user_title, (int)2, (int)1808, (int)0);
            for (Map.Entry entry : configuration.entrySet()) {
                String label = switch ((String)entry.getKey()) {
                    case "firstName" -> TeamAppMessages.dialog_session_information_user_first_name_label;
                    case "lastName" -> TeamAppMessages.dialog_session_information_user_last_name_label;
                    default -> (String)entry.getKey();
                };
                UIUtils.createLabelText((Composite)group, (String)label, (String)String.valueOf(entry.getValue()), (int)2056);
            }
        }
        group = UIUtils.createControlGroup((Composite)composite, (String)TeamAppMessages.dialog_session_information_general_session_info_label, (int)2, (int)1808, (int)0);
        DCClientConfiguration clientConfiguration = (DCClientConfiguration)DBUtils.getAdapter(DCClientConfiguration.class, (Object)this.session);
        if (clientConfiguration != null) {
            UIUtils.createLabelText((Composite)group, (String)"Domain controller", (String)clientConfiguration.getApiUrl(), (int)2056);
        }
        if ((serverAPI = (SMServerAPI)DBUtils.getAdapter(SMServerAPI.class, (Object)this.session)) != null) {
            UIUtils.createLabelText((Composite)group, (String)"Version", (String)(serverAPI.getServerVersion() + "; API " + serverAPI.getServerApiVersion()), (int)2056);
        }
        UIUtils.createLabelText((Composite)group, (String)TeamAppMessages.dialog_session_information_general_session_id_label, (String)this.session.getSessionId(), (int)2056);
        LinkedHashMap authData = new LinkedHashMap();
        for (SMAuthInfo ai : authInfo) {
            authData.putAll(ai.getAuthData());
        }
        if (!CommonUtils.isEmpty(authData)) {
            UIUtils.createLabelText((Composite)group, (String)"Authentication", (String)authData.keySet().stream().map(SMAuthConfigurationReference::getAuthProviderId).collect(Collectors.joining(",")), (int)2056);
        }
        UIUtils.createLabelText((Composite)group, (String)TeamAppMessages.dialog_session_information_general_session_duration_label, (String)DurationFormatter.format((Duration)Duration.between(this.session.getSessionStart(), LocalDateTime.now()), (DurationFormat)DurationFormat.MEDIUM), (int)2056);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

