/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui;

import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.DCRemoteSecurityController;
import com.dbeaver.team.auth.DCConfiguration;
import com.dbeaver.team.auth.DCIdentityProvider;
import com.dbeaver.team.ui.TeamAuthUI;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ServerListDialog
extends BaseDialog {
    private static final Log log = Log.getLog(ServerListDialog.class);
    private final DCConfiguration dcConfiguration;
    private Table serversTable;

    public ServerListDialog(@NotNull Shell parentShell, @NotNull DCConfiguration dcConfiguration) {
        super(parentShell, GeneralUtils.getProductTitle(), null);
        this.dcConfiguration = dcConfiguration;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Group serverGroup = UIUtils.createControlGroup((Composite)dialogArea, (String)"Servers", (int)2, (int)1808, (int)-1);
        serverGroup.setLayoutData((Object)new GridData(1808));
        this.serversTable = new Table((Composite)serverGroup, 67588);
        this.serversTable.setLayoutData((Object)new GridData(1808));
        this.serversTable.setHeaderVisible(true);
        UIUtils.createTableColumn((Table)this.serversTable, (int)16384, (String)"Server");
        UIUtils.createTableColumn((Table)this.serversTable, (int)16384, (String)"URL");
        ToolBar toolbar = new ToolBar((Composite)serverGroup, 512);
        toolbar.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)toolbar, (String)UIConnectionMessages.pref_page_drivers_button_add, (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String serverURL = EnterNameDialog.chooseName((Shell)ServerListDialog.this.getShell(), (String)"New server address or URL", (String)"");
                if (!CommonUtils.isEmpty((String)serverURL)) {
                    try {
                        String url = DCIdentityProvider.normalizeServerURL(serverURL, true);
                        ServerListDialog.this.tryServerAccessible(url);
                        ServerListDialog.this.addServerToTable(url);
                    }
                    catch (DBException ex) {
                        log.error((Object)ex);
                        UIUtils.showMessageBox((Shell)ServerListDialog.this.getShell(), (String)"Bad server address", (String)("Bad server address: " + ex.getMessage()), (int)1);
                    }
                }
            }
        });
        ToolItem removeButton = UIUtils.createToolItem((ToolBar)toolbar, (String)UIConnectionMessages.pref_page_drivers_button_remove, (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServerListDialog.this.serversTable.getSelectionIndex() < 0) {
                    return;
                }
                TableItem selItem = ServerListDialog.this.serversTable.getSelection()[0];
                if (UIUtils.confirmAction((Shell)ServerListDialog.this.getShell(), (String)"Delete server", (String)("Are you sure you want to delete server '" + selItem.getText(1) + "' from the list?"))) {
                    selItem.dispose();
                }
            }
        });
        removeButton.setEnabled(false);
        this.serversTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> removeButton.setEnabled(this.serversTable.getSelectionIndex() != -1)));
        String currentServerURL = this.dcConfiguration.getDomainControllerURL();
        ArrayList<String> serverList = new ArrayList<String>();
        serverList.add(currentServerURL);
        for (String server : this.dcConfiguration.getOtherServers()) {
            if (CommonUtils.equalObjects((Object)server, (Object)currentServerURL)) continue;
            serverList.add(server);
        }
        for (String server : serverList) {
            this.addServerToTable(server);
        }
        UIUtils.packColumns((Table)this.serversTable);
        return dialogArea;
    }

    private void addServerToTable(String server) {
        TableItem item = new TableItem(this.serversTable, 16384);
        item.setData((Object)server);
        item.setText(0, TeamAuthUI.stripServerURL(server));
        item.setText(1, server);
    }

    protected void okPressed() {
        String mainURL = null;
        ArrayList<String> otherServers = new ArrayList<String>();
        TableItem[] tableItemArray = this.serversTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String url = item.getText(1);
            if (mainURL == null) {
                mainURL = url;
            } else {
                otherServers.add(url);
            }
            ++n2;
        }
        if (mainURL == null) {
            UIUtils.showMessageBox((Shell)this.getShell(), (String)"No servers", (String)"You must specify at least one server URL", (int)1);
            return;
        }
        this.dcConfiguration.setDomainControllerURL(mainURL);
        this.dcConfiguration.setOtherServers(otherServers);
        super.okPressed();
    }

    private void tryServerAccessible(String normalizedServerURL) throws DBException {
        DCClientConfiguration clientConfig = ((DCClientConfiguration.Builder)DCClientConfiguration.builder().setApiUrl(normalizedServerURL)).build();
        DCRemoteSecurityController svc = new DCRemoteSecurityController(clientConfig);
        svc.getServerAPI();
    }
}

