/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui;

import com.dbeaver.remote.workspace.DesktopWorkspaceRemote;
import com.dbeaver.remote.workspace.RemoteProjectImpl;
import com.dbeaver.team.ui.WizardProjectsImportToTEPage;
import com.dbeaver.team.workspace.TeamProjectImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.internal.resources.ModelObject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizard;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.app.LocalSecretController;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.rcp.DesktopProjectImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.secret.DBSSecretObject;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManagerBuffer;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.SecurityUtils;

public class ImportProjectToTEHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(ImportProjectToTEHandler.class);

    public Object execute(@NotNull ExecutionEvent event) {
        ImportProjectToTEWizard importWizard = new ImportProjectToTEWizard();
        importWizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)importWizard);
        dialog.open();
        return null;
    }

    private static IStatus createRemoteProjectAndImportData(final @NotNull WizardProjectsImportToTEPage.ProjectImportParameters importParameters, @NotNull Shell shell, @NotNull IProgressMonitor mon) throws InterruptedException {
        WizardProjectsImportToTEPage.ProjectRecord importProject = importParameters.project();
        assert (importProject != null);
        log.info((Object)("Project import initiated for project '" + importParameters.newProjectName() + "'"));
        final String tempProjectName = "temp_" + SecurityUtils.generateUniqueId();
        final CompletableFuture<TeamProjectImpl> futureRemoteProject = new CompletableFuture<TeamProjectImpl>();
        final CompletableFuture futureTempProject = new CompletableFuture();
        DBPProjectListener projectListener = new DBPProjectListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void handleProjectAdd(@NotNull DBPProject project) {
                if (project instanceof DesktopProjectImpl) {
                    DesktopProjectImpl tp = (DesktopProjectImpl)project;
                    if (project.getName().equals(tempProjectName)) {
                        futureTempProject.complete(tp);
                        return;
                    }
                }
                if (!(project instanceof TeamProjectImpl)) return;
                TeamProjectImpl rp = (TeamProjectImpl)project;
                if (!project.getName().equals(importParameters.newProjectName())) return;
                futureRemoteProject.complete(rp);
            }
        };
        DBPPlatformDesktop.getInstance().getWorkspace().addProjectListener(projectListener);
        IProjectDescription descr = importProject.description;
        importProject.description = (IProjectDescription)((ModelObject)descr).clone();
        if (mon.isCanceled()) {
            throw new CancellationException();
        }
        log.info((Object)("Creating local project '" + tempProjectName + "' for import"));
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)3);
        IStatus status = ImportProjectToTEHandler.createLocalProject(importProject, importParameters.structureProvider(), tempProjectName, shell, (IProgressMonitor)subMonitor);
        if (!status.isOK()) {
            return status;
        }
        try {
            URI locationURI;
            WizardProjectsImportToTEPage.ProjectRecord record = importParameters.project();
            record.description = descr;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (record.description == null) {
                record.description = workspace.newProjectDescription(importParameters.newProjectName());
                assert (record.projectSystemFile != null);
                IPath locationPath = IPath.fromOSString((String)record.projectSystemFile.getAbsolutePath());
                if (Platform.getLocation().isPrefixOf(locationPath)) {
                    record.description.setLocation(null);
                } else {
                    record.description.setLocation(locationPath);
                }
            } else {
                record.description.setName(importParameters.newProjectName());
            }
            File importSource = null;
            if (record.projectArchiveFile == null && (locationURI = record.description.getLocationURI()) != null) {
                IStatus result = ResourcesPlugin.getWorkspace().validateProjectLocationURI(null, locationURI);
                if (!result.isOK()) {
                    IStatus iStatus = result;
                    return iStatus;
                }
                importSource = new File(locationURI);
            }
            subMonitor.setWorkRemaining(record.projectArchiveFile == null && importSource != null ? 2 : 1);
            if (subMonitor.isCanceled()) {
                throw new CancellationException();
            }
            log.info((Object)("Creating remote project '" + importParameters.newProjectName() + "' for import"));
            status = ImportProjectToTEHandler.createRemoteProject(importParameters, futureRemoteProject, subMonitor);
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            TeamProjectImpl newProject = ImportProjectToTEHandler.getFutureOrCancel(futureRemoteProject, (IProgressMonitor)subMonitor);
            newProject.ensureOpen();
            if (subMonitor.isCanceled()) {
                throw new CancellationException();
            }
            log.info((Object)("Importing resources to remote project '" + importParameters.newProjectName() + "'"));
            ImportProjectToTEHandler.importResourceContentsToRemoteProject(importSource, newProject, importParameters, subMonitor);
            DBPProject tempProject = (DBPProject)ImportProjectToTEHandler.getFutureOrCancel(futureTempProject, (IProgressMonitor)subMonitor);
            tempProject.ensureOpen();
            if (subMonitor.isCanceled()) {
                throw new CancellationException();
            }
            log.info((Object)("Importing data sources to remote project '" + importParameters.newProjectName() + "'"));
            ImportProjectToTEHandler.importDataSourcesToRemoteProject(tempProject, (DBPProject)newProject, importParameters, subMonitor);
            if (subMonitor.isCanceled()) {
                throw new CancellationException();
            }
            log.info((Object)("Importing resource properties to remote project '" + importParameters.newProjectName() + "'"));
            ImportProjectToTEHandler.importResourceProperties(tempProject, newProject, subMonitor);
            IStatus iStatus = status;
            return iStatus;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            IProgressMonitor cleanupMonitor = mon.slice(1);
            cleanupMonitor.setTaskName("Cleanup temporary data");
            cleanupMonitor.setCanceled(false);
            DBPPlatformDesktop.getInstance().getWorkspace().removeProjectListener(projectListener);
            try {
                Objects.requireNonNull(((DesktopProjectImpl)ImportProjectToTEHandler.getFutureOrCancel(futureTempProject, cleanupMonitor)).getEclipseProject()).delete(true, true, cleanupMonitor);
            }
            catch (ExecutionException | CoreException e) {
                log.error((Object)e);
            }
        }
    }

    private static <T> T getFutureOrCancel(Future<T> future, IProgressMonitor monitor) throws ExecutionException, InterruptedException {
        while (!monitor.isCanceled()) {
            try {
                return future.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {}
        }
        throw new CancellationException();
    }

    private static void importResourceProperties(@NotNull DBPProject tempProject, @NotNull TeamProjectImpl newProject, @NotNull SubMonitor subMonitor) {
        DesktopProjectImpl lp;
        DesktopProjectImpl localProject;
        DesktopProjectImpl desktopProjectImpl = localProject = tempProject instanceof DesktopProjectImpl ? (lp = (DesktopProjectImpl)tempProject) : null;
        assert (localProject != null);
        for (Map.Entry resourceEntry : localProject.getAllResourceProperties().entrySet()) {
            if (subMonitor.isCanceled()) {
                throw new CancellationException();
            }
            String resourcePath = (String)resourceEntry.getKey();
            log.info((Object)("Importing properties of resource '" + resourcePath + "' to remote project '" + newProject.getName() + "'"));
            IResource importedResource = newProject.getRootResource().findMember(resourcePath);
            if (importedResource == null || !importedResource.exists()) continue;
            newProject.setResourceProperties(resourcePath, (Map)resourceEntry.getValue());
        }
    }

    private static void importDataSourcesToRemoteProject(@NotNull DBPProject tempProject, @NotNull DBPProject newProject, @NotNull WizardProjectsImportToTEPage.ProjectImportParameters importParameters, @NotNull SubMonitor subMonitor) {
        DesktopWorkspaceRemote rw;
        DesktopWorkspaceRemote remoteWorkspace;
        RemoteProjectImpl rp;
        RemoteProjectImpl remoteProject;
        RemoteProjectImpl remoteProjectImpl = remoteProject = newProject instanceof RemoteProjectImpl ? (rp = (RemoteProjectImpl)newProject) : null;
        assert (remoteProject != null);
        DBPWorkspaceDesktop dBPWorkspaceDesktop = DBPPlatformDesktop.getInstance().getWorkspace();
        DesktopWorkspaceRemote desktopWorkspaceRemote = remoteWorkspace = dBPWorkspaceDesktop instanceof DesktopWorkspaceRemote ? (rw = (DesktopWorkspaceRemote)dBPWorkspaceDesktop) : null;
        assert (remoteWorkspace != null);
        try {
            DataSourceRegistry dsr;
            DataSourceRegistry tempProjectDsRegistry;
            DBPDataSourceRegistry dBPDataSourceRegistry = tempProject.getDataSourceRegistry();
            DataSourceRegistry dataSourceRegistry = tempProjectDsRegistry = dBPDataSourceRegistry instanceof DataSourceRegistry ? (dsr = (DataSourceRegistry)dBPDataSourceRegistry) : null;
            assert (tempProjectDsRegistry != null);
            LocalSecretController tempSecretController = tempProject instanceof DesktopProjectImpl ? LocalSecretController.INSTANCE : DBSSecretController.getProjectSecretController((DBPProject)tempProject);
            tempProjectDsRegistry.refreshConfig();
            if (!importParameters.importSecrets()) {
                for (DBPDataSourceContainer dsDescriptor : tempProjectDsRegistry.getDataSources()) {
                    if (subMonitor.isCanceled()) {
                        throw new CancellationException();
                    }
                    if (dsDescriptor instanceof DBSSecretObject) {
                        DBSSecretObject secretObject = (DBSSecretObject)dsDescriptor;
                        tempSecretController.deleteObjectSecrets(secretObject);
                        dsDescriptor.resetPassword();
                        dsDescriptor.resetAllSecrets();
                    }
                    for (DBWHandlerConfiguration handlerCfg : dsDescriptor.getConnectionConfiguration().getHandlers()) {
                        handlerCfg.setPassword(null);
                        handlerCfg.setSavePassword(false);
                        handlerCfg.setSecureProperties(Collections.emptyMap());
                    }
                }
            }
            DataSourceConfigurationManagerBuffer buffer = new DataSourceConfigurationManagerBuffer();
            tempProjectDsRegistry.saveConfigurationToManager((DBRProgressMonitor)new DefaultProgressMonitor((IProgressMonitor)subMonitor), (DataSourceConfigurationManager)buffer, null);
            String configuration = new String(buffer.getData(), StandardCharsets.UTF_8);
            remoteWorkspace.getResourceController().createProjectDataSources(newProject.getId(), configuration, null);
            if (importParameters.importSecrets()) {
                DBSSecretController remoteSecretController = DBSSecretController.getProjectSecretController((DBPProject)remoteProject);
                remoteProject.getDataSourceRegistry().refreshConfig();
                for (DBPDataSourceContainer newDs : remoteProject.getDataSourceRegistry().getDataSources()) {
                    if (subMonitor.isCanceled()) {
                        throw new CancellationException();
                    }
                    log.info((Object)("Importing data source secrets'" + newDs.getId() + "' to remote project '" + remoteProject.getName() + "'"));
                    DataSourceDescriptor oldDs = tempProjectDsRegistry.getDataSource(newDs.getId());
                    oldDs.persistSecrets(remoteSecretController);
                    newDs.resolveSecrets(remoteSecretController);
                    newDs.setSavePassword(oldDs.isSavePassword());
                    DBPConnectionConfiguration oldCfg = oldDs.getConnectionConfiguration();
                    DBPConnectionConfiguration newCfg = newDs.getConnectionConfiguration();
                    newCfg.setUserPassword(oldCfg.getUserPassword());
                    for (DBWHandlerConfiguration newHandlerCfg : newDs.getConnectionConfiguration().getHandlers()) {
                        DBWHandlerConfiguration oldHandlerCfg = oldDs.getConnectionConfiguration().getHandler(newHandlerCfg.getId());
                        newHandlerCfg.setPassword(oldHandlerCfg.getPassword());
                        newHandlerCfg.setSavePassword(oldHandlerCfg.isSavePassword());
                        newHandlerCfg.setSecureProperties(oldHandlerCfg.getSecureProperties());
                    }
                    newDs.persistConfiguration();
                }
                remoteProject.getDataSourceRegistry().refreshConfig();
            }
        }
        catch (DBException e) {
            throw new RuntimeException(e);
        }
    }

    private static void importResourceContentsToRemoteProject(@NotNull File importSource, @NotNull TeamProjectImpl newProject, @NotNull WizardProjectsImportToTEPage.ProjectImportParameters importParameters, @NotNull SubMonitor subMonitor) throws CoreException {
        FileSystemStructureProvider provider;
        List filesToImport;
        block14: {
            WizardProjectsImportToTEPage.ProjectRecord record = importParameters.project();
            assert (record != null);
            if (record.projectArchiveFile != null) {
                try {
                    Throwable throwable = null;
                    Object var8_8 = null;
                    try (ILeveledImportStructureProvider structProvider = importParameters.structureProvider();){
                        filesToImport = structProvider.getChildren(record.parent);
                        structProvider.setStrip(record.level);
                        provider = importParameters.structureProvider();
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
                }
            }
            filesToImport = FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource);
            provider = FileSystemStructureProvider.INSTANCE;
        }
        IContainer root = newProject.getRootResource();
        assert (root != null);
        ImportProjectToTEHandler.importFileSystemObjects((IImportStructureProvider)provider, filesToImport, root, (IProgressMonitor)subMonitor.split(1), Set.of(".dbeaver", ".project", ".settings"));
    }

    private static IStatus createRemoteProject(@NotNull WizardProjectsImportToTEPage.ProjectImportParameters importParameters, Future<TeamProjectImpl> futureRemoteProject, SubMonitor subMonitor) throws CoreException {
        try {
            SubMonitor subTask = subMonitor.split(1).setWorkRemaining(100);
            subTask.setTaskName(DataTransferMessages.WizardProjectsImportPage_CreateProjectsTask);
            DBPPlatformDesktop.getInstance().getWorkspace().createProject(importParameters.newProjectName(), importParameters.newProjectDescription());
            TeamProjectImpl newProject = futureRemoteProject.get();
            IProject project = newProject.getEclipseProject();
            assert (project != null);
            project.open(128, (IProgressMonitor)subTask.split(70));
            return Status.OK_STATUS;
        }
        catch (InterruptedException | ExecutionException | DBException e) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.dialog_project_create_wizard_error_cannot_create, UINavigatorMessages.dialog_project_create_wizard_error_cannot_create_message, e);
            return new Status(4, "org.eclipse.ui.ide", 2, e.getCause().getLocalizedMessage(), e);
        }
    }

    private static void importFileSystemObjects(@NotNull IImportStructureProvider provider, @NotNull List<?> filesToImport, @NotNull IContainer targetContainer, @NotNull IProgressMonitor monitor, @NotNull Set<String> rootExcludes) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)filesToImport.size());
        if (subMonitor.isCanceled()) {
            throw new CancellationException();
        }
        for (Object fileSystemObject : filesToImport) {
            SubMonitor iterationMonitor = subMonitor.split(1);
            String name = provider.getLabel(fileSystemObject);
            if (rootExcludes.contains(name)) continue;
            ImportProjectToTEHandler.importRecursivelyFrom(provider, fileSystemObject, targetContainer, (IProgressMonitor)iterationMonitor);
        }
    }

    private static void importRecursivelyFrom(@NotNull IImportStructureProvider provider, @NotNull Object fileSystemObject, @NotNull IContainer targetContainer, @NotNull IProgressMonitor mon) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        String name = provider.getLabel(fileSystemObject);
        if (subMonitor.isCanceled()) {
            throw new CancellationException();
        }
        if (name.startsWith(".")) {
            return;
        }
        try {
            GeneralUtils.validateResourceNameUnconditionally((String)name);
        }
        catch (DBException e) {
            log.warn((Object)("Skipping invalid resource '" + name + "'. " + e.getMessage()));
            return;
        }
        log.info((Object)("Importing resource '" + name + "' to remote project '" + String.valueOf(targetContainer.getProject()) + "'"));
        String fileObjectPath = provider.getFullPath(fileSystemObject);
        subMonitor.subTask(fileObjectPath);
        if (provider.isFolder(fileSystemObject)) {
            List children;
            IFolder folder = targetContainer.getFolder((IPath)new Path(name));
            try {
                if (!folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)subMonitor.split(100));
                }
            }
            catch (CoreException e) {
                log.error((Object)e);
            }
            if ((children = provider.getChildren(fileSystemObject)) != null) {
                SubMonitor loopMonitor = subMonitor.split(90).setWorkRemaining(children.size());
                for (Object child : children) {
                    ImportProjectToTEHandler.importRecursivelyFrom(provider, child, (IContainer)folder, (IProgressMonitor)loopMonitor.split(1));
                }
            }
        } else {
            IFile targetResource = targetContainer.getFile((IPath)new Path(provider.getLabel(fileSystemObject)));
            try {
                Throwable children = null;
                Object var9_16 = null;
                try (InputStream contentStream = provider.getContents(fileSystemObject);){
                    if (contentStream != null) {
                        if (targetResource.exists()) {
                            targetResource.setContents(contentStream, true, true, (IProgressMonitor)subMonitor.split(100));
                        } else {
                            targetResource.create(contentStream, true, (IProgressMonitor)subMonitor.split(100));
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (children == null) {
                        children = throwable;
                    } else if (children != throwable) {
                        children.addSuppressed(throwable);
                    }
                    throw children;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    private static IStatus createLocalProject(@NotNull WizardProjectsImportToTEPage.ProjectRecord record, @NotNull ILeveledImportStructureProvider structureProvider, @NotNull String projectName, @NotNull Shell shell, @NotNull IProgressMonitor mon) throws InterruptedException {
        URI locationURI;
        boolean copyFiles = true;
        boolean closeProjectsAfterImport = false;
        IOverwriteQuery owq = s -> "NO";
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)3);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null && record.projectSystemFile != null) {
            record.description = workspace.newProjectDescription(projectName);
            IPath locationPath = IPath.fromOSString((String)record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf(locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation(locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        if (record.projectArchiveFile != null) {
            List fileSystemObjects = structureProvider.getChildren(record.parent);
            structureProvider.setStrip(record.level);
            ImportOperation operation = new ImportOperation(project.getFullPath(), structureProvider.getRoot(), (IImportStructureProvider)structureProvider, owq, fileSystemObjects);
            operation.setContext(shell);
            try {
                operation.run((IProgressMonitor)subMonitor.split(1));
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    return ((CoreException)e.getCause()).getStatus();
                }
                return new Status(4, "org.eclipse.ui.ide", 2, e.getCause().getLocalizedMessage(), (Throwable)e);
            }
            if (closeProjectsAfterImport) {
                try {
                    project.close((IProgressMonitor)subMonitor.split(1));
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
            return operation.getStatus();
        }
        File importSource = null;
        if (copyFiles && (locationURI = record.description.getLocationURI()) != null) {
            IStatus result = ResourcesPlugin.getWorkspace().validateProjectLocationURI(project, locationURI);
            if (!result.isOK()) {
                return result;
            }
            importSource = new File(locationURI);
            IProjectDescription desc = workspace.newProjectDescription(projectName);
            desc.setBuildSpec(record.description.getBuildSpec());
            desc.setComment(record.description.getComment());
            desc.setDynamicReferences(record.description.getDynamicReferences());
            desc.setNatureIds(record.description.getNatureIds());
            desc.setReferencedProjects(record.description.getReferencedProjects());
            record.description = desc;
        }
        subMonitor.setWorkRemaining(copyFiles && importSource != null ? 2 : 1);
        try {
            SubMonitor subTask = subMonitor.split(1).setWorkRemaining(100);
            subTask.setTaskName(DataTransferMessages.WizardProjectsImportPage_CreateProjectsTask);
            project.create(record.description, (IProgressMonitor)subTask.split(30));
            project.open(128, (IProgressMonitor)subTask.split(70));
            subTask.setTaskName("");
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        IStatus result = Status.OK_STATUS;
        if (copyFiles && importSource != null) {
            List filesToImport = FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource);
            ImportOperation operation = new ImportOperation(project.getFullPath(), (Object)importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, owq, filesToImport);
            operation.setContext(shell);
            operation.setOverwriteResources(true);
            operation.setCreateContainerStructure(false);
            try {
                operation.run((IProgressMonitor)subMonitor.split(1));
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    return ((CoreException)e.getCause()).getStatus();
                }
                return new Status(4, "org.eclipse.ui.ide", 2, e.getCause().getLocalizedMessage(), (Throwable)e);
            }
        }
        if (closeProjectsAfterImport) {
            try {
                project.close((IProgressMonitor)subMonitor.split(1));
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        return result;
    }

    private static class ImportProjectToTEWizard
    extends ExternalProjectImportWizard {
        @Nullable
        private WizardProjectsImportToTEPage mainPage;

        public void addPages() {
            this.mainPage = new WizardProjectsImportToTEPage("wizardExternalProjectsToTEPage");
            this.addPage((IWizardPage)this.mainPage);
        }

        public void init(@NotNull IWorkbench workbench, @Nullable IStructuredSelection selection) {
            this.setWindowTitle(DataTransferMessages.DataTransfer_importTitle);
            this.setDefaultPageImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor((String)"wizban/importproj_wiz.png"));
        }

        public boolean performCancel() {
            if (this.mainPage != null) {
                this.mainPage.performCancel();
            }
            return true;
        }

        public boolean performFinish() {
            if (this.mainPage == null) {
                return false;
            }
            this.mainPage.saveWidgetValues();
            if (this.mainPage.updateStatus()) {
                return this.createProject(this.mainPage.getImportParameters(), this.getShell());
            }
            String statusMessage = this.mainPage.getStatusMessage();
            if (statusMessage != null) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"Cannot import project", null, (IStatus)Status.warning((String)statusMessage));
            }
            return false;
        }

        private boolean createProject(final @NotNull WizardProjectsImportToTEPage.ProjectImportParameters importParameters, final @NotNull Shell shell) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IStatus status = ImportProjectToTEHandler.createRemoteProjectAndImportData(importParameters, shell, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                    if (!status.isOK()) {
                        throw new InvocationTargetException(new CoreException(status));
                    }
                }
            };
            try {
                try {
                    this.getContainer().run(true, true, (IRunnableWithProgress)op);
                }
                catch (InterruptedException interruptedException) {
                    ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)importParameters.structureProvider(), (Shell)this.getShell());
                    return false;
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    String message = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
                    Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, message, t);
                    ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
                    ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)importParameters.structureProvider(), (Shell)this.getShell());
                    return false;
                }
            }
            finally {
                ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)importParameters.structureProvider(), (Shell)this.getShell());
            }
            return true;
        }
    }
}

