/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui;

import com.dbeaver.model.auth.SMAuthPromptConfiguration;
import com.dbeaver.model.auth.SMServerAPI;
import com.dbeaver.team.application.internal.TeamAppImages;
import com.dbeaver.team.auth.DCConfiguration;
import com.dbeaver.team.ui.ServerListDialog;
import com.dbeaver.team.ui.TeamAuthUI;
import com.dbeaver.team.ui.internal.TeamMessages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.auth.AuthPropertyDescriptor;
import org.jkiss.dbeaver.model.auth.AuthPropertyEncryption;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.security.SMAuthCredentialsProfile;
import org.jkiss.dbeaver.model.security.SMAuthProviderCustomConfiguration;
import org.jkiss.dbeaver.model.security.SMAuthProviderDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class AuthProviderPromptDialog
extends BaseDialog {
    private static final Log log = Log.getLog(AuthProviderPromptDialog.class);
    public static final String WEB_SITE_LINK = "https://dbeaver.com/";
    public static final String WEB_SITE_TITLE = "dbeaver.com";
    private static final String DATA_PROVIDER = "provider";
    private static final String DATA_PROFILE = "profile";
    private static final String DATA_CONFIGURATION = "configuration";
    private static final Object WEB_CONFIG = new Object();
    private final SMAuthPromptConfiguration configuration;
    private final DCConfiguration dcConfiguration;
    private final List<String> serverList = new ArrayList<String>();
    private final List<ConfigurationControlWrapper> controlWrappers = new ArrayList<ConfigurationControlWrapper>();
    private CTabFolder tabFolder;
    private Control focusControl;
    private int profileComboIndex = -1;

    public AuthProviderPromptDialog(@Nullable Shell parentShell, @NotNull SMAuthPromptConfiguration configuration, @NotNull DCConfiguration dcConfiguration) {
        super(parentShell, GeneralUtils.getProductTitle(), null);
        this.setShellStyle(0x870 | (parentShell != null ? 65536 : 128));
        this.configuration = configuration;
        this.dcConfiguration = dcConfiguration;
        if (this.configuration.getMainSession() != null) {
            this.setTitle(this.configuration.getAuthTitle());
        }
        dcConfiguration.setNewServerURL(null);
    }

    private boolean isAdditionalAuth() {
        return this.configuration.getMainSession() != null;
    }

    protected Composite createDialogArea(Composite parent) {
        this.initializeBounds();
        boolean additionalAuth = this.isAdditionalAuth();
        Composite authGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(additionalAuth ? 1 : 2, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        authGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        authGroup.setLayoutData((Object)gd);
        if (!additionalAuth) {
            Composite logoPanel = new Composite(authGroup, 0);
            logoPanel.setLayout((Layout)new GridLayout(1, false));
            logoPanel.setLayoutData((Object)new GridData(34));
            ImageDescriptor imageDescriptor = TeamAppImages.getImageDescriptor("icons/dbeaver_intro.png");
            if (imageDescriptor != null) {
                Image image = imageDescriptor.createImage();
                Label logoLabel = new Label(logoPanel, 0);
                logoLabel.setImage(image);
                logoLabel.addDisposeListener(e -> image.dispose());
                gd = new GridData(66);
                gd.grabExcessVerticalSpace = true;
                gd.grabExcessHorizontalSpace = true;
                logoLabel.setLayoutData((Object)gd);
            }
            Link proLink = new Link(logoPanel, 0);
            proLink.setText("<a>dbeaver.com</a>");
            proLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                boolean bl = ShellUtils.launchProgram((String)WEB_SITE_LINK);
            }));
            proLink.setLayoutData((Object)new GridData(64));
        }
        boolean focusWasSet = false;
        Composite credGroup = UIUtils.createComposite((Composite)authGroup, (int)1);
        credGroup.setLayoutData((Object)new GridData(768));
        ArrayList<SMAuthProviderDescriptor> configurableProviders = new ArrayList<SMAuthProviderDescriptor>();
        this.tabFolder = new CTabFolder(credGroup, 128);
        this.tabFolder.setLayoutData((Object)new GridData(770));
        SMAuthProviderDescriptor[] sMAuthProviderDescriptorArray = this.configuration.getProviders();
        int n = sMAuthProviderDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            SMAuthProviderDescriptor apd = sMAuthProviderDescriptorArray[n2];
            if (!CommonUtils.isEmpty((Collection)apd.getCustomConfigurations()) && !apd.hasUserParameters()) {
                configurableProviders.add(apd);
            } else if (!(CommonUtils.isEmpty((Collection)apd.getCredentialProfiles()) || apd.getCredentialProfiles().size() == 1 && !this.hasProfileControls((SMAuthCredentialsProfile)apd.getCredentialProfiles().get(0)) || additionalAuth && apd.getId().equals("local"))) {
                this.createAuthProviderTab(apd);
            }
            ++n2;
        }
        if (!configurableProviders.isEmpty()) {
            CTabItem item = new CTabItem(this.tabFolder, 0);
            item.setData(DATA_PROVIDER, WEB_CONFIG);
            item.setText(TeamMessages.auth_provider_dialog_tab_item_federated);
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_KEY));
            Composite faPanel = new Composite((Composite)this.tabFolder, 0);
            gl = new GridLayout(1, false);
            faPanel.setLayout((Layout)gl);
            item.setControl((Control)faPanel);
            Composite buttonsPanel = UIUtils.createComposite((Composite)faPanel, (int)1);
            buttonsPanel.setLayout((Layout)new GridLayout(1, false));
            buttonsPanel.setLayoutData((Object)new GridData(1808));
            Label hint = new Label(buttonsPanel, 0);
            gd = new GridData(768);
            gd.widthHint = 400;
            gd.heightHint = 5;
            hint.setLayoutData((Object)gd);
            for (SMAuthProviderDescriptor apd : configurableProviders) {
                for (SMAuthProviderCustomConfiguration cc : apd.getCustomConfigurations()) {
                    Button authButton = new Button(buttonsPanel, 16392);
                    authButton.setText("    " + cc.getDisplayName());
                    authButton.setToolTipText(apd.getDescription());
                    authButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.doFederatedAuthentication(apd, cc)));
                    gd = new GridData(64);
                    gd.widthHint = 200;
                    authButton.setLayoutData((Object)gd);
                    ImageDescriptor imageDescriptor = AuthProviderPromptDialog.getIdpIcon(apd);
                    if (imageDescriptor != null) {
                        Image image = imageDescriptor.createImage();
                        authButton.setImage(image);
                        authButton.addDisposeListener(e -> image.dispose());
                    }
                    if (!cc.getId().equals(this.configuration.getSelectedConfigurationId())) continue;
                    UIUtils.asyncExec(() -> ((Button)authButton).setFocus());
                    focusWasSet = true;
                }
            }
            if (this.configuration.getSelectedProvider() != null && !CommonUtils.isEmpty((Collection)this.configuration.getSelectedProvider().getCustomConfigurations())) {
                this.tabFolder.setSelection(item);
                UIUtils.asyncExec(() -> this.enableButton(0, false));
            }
            this.tabFolder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                CTabItem tabItem = this.tabFolder.getSelection();
                this.enableButton(0, tabItem != null && tabItem.getData(DATA_PROVIDER) != WEB_CONFIG);
            }));
            final DBPPreferenceStore preferences = DBeaverActivator.getInstance().getPreferences();
            final Button authorizeInInternalBrowser = UIUtils.createCheckbox((Composite)faPanel, (String)CoreMessages.pref_page_ui_general_check_browser_auth, (boolean)preferences.getBoolean("ui.use.redirect.auth"));
            authorizeInInternalBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    preferences.setValue("ui.use.redirect.auth", authorizeInInternalBrowser.getSelection());
                    try {
                        preferences.save();
                    }
                    catch (IOException ex) {
                        log.error((Object)"Error saving embedded auth status", (Throwable)ex);
                    }
                }
            });
        }
        if (!focusWasSet) {
            if (this.focusControl == null) {
                this.focusControl = this.tabFolder;
            }
            UIUtils.asyncExec(() -> ((Control)this.focusControl).setFocus());
        }
        if (!additionalAuth) {
            Composite serverGroup = UIUtils.createComposite((Composite)credGroup, (int)4);
            serverGroup.setLayoutData((Object)new GridData(768));
            final Combo serverSelector = UIUtils.createLabelCombo((Composite)serverGroup, (String)"Server", (int)12);
            serverSelector.setLayoutData((Object)new GridData(768));
            serverSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AuthProviderPromptDialog.this.switchServer(AuthProviderPromptDialog.this.serverList.get(serverSelector.getSelectionIndex()));
                }
            });
            UIUtils.createPushButton((Composite)serverGroup, null, (Image)DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_INFO), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AuthProviderPromptDialog.this.showCurrentServerInfo();
                }
            });
            UIUtils.createPushButton((Composite)serverGroup, (String)"Edit ...", null, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AuthProviderPromptDialog.this.editServerList();
                }
            });
            String currentServerURL = this.dcConfiguration.getDomainControllerURL();
            serverSelector.add(TeamAuthUI.stripServerURL(currentServerURL));
            serverSelector.setText(TeamAuthUI.stripServerURL(currentServerURL));
            this.serverList.add(currentServerURL);
            List<String> otherServers = this.dcConfiguration.getOtherServers();
            if (!CommonUtils.isEmpty(otherServers)) {
                for (String server : otherServers) {
                    if (CommonUtils.equalObjects((Object)server, (Object)currentServerURL)) continue;
                    this.serverList.add(server);
                    serverSelector.add(TeamAuthUI.stripServerURL(server));
                }
            }
        }
        AuthProviderPromptDialog.applyDialogFont((Control)authGroup);
        return authGroup;
    }

    private void editServerList() {
        ServerListDialog serverListDialog = new ServerListDialog(this.getShell(), this.dcConfiguration);
        if (serverListDialog.open() == 0) {
            this.dcConfiguration.setNewServerURL(this.dcConfiguration.getDomainControllerURL());
            this.okPressed();
        }
    }

    private void switchServer(String serverURL) {
        this.dcConfiguration.setNewServerURL(serverURL);
        this.okPressed();
    }

    private void showCurrentServerInfo() {
        new BaseDialog(this.getShell(), TeamMessages.auth_provider_dialog_composite_text_server_info, null){

            protected Composite createDialogArea(Composite parent) {
                Composite dialogArea = super.createDialogArea(parent);
                Composite serverInfoPanel = UIUtils.createComposite((Composite)dialogArea, (int)2);
                SMServerAPI apiInfo = AuthProviderPromptDialog.this.getPromptConfiguration().getApiInfo();
                UIUtils.createLabelText((Composite)serverInfoPanel, (String)TeamMessages.auth_provider_dialog_composite_label_company, (String)apiInfo.getCompanyName(), (int)2056);
                UIUtils.createLabelText((Composite)serverInfoPanel, (String)TeamMessages.auth_provider_dialog_composite_label_address, (String)apiInfo.getServerId(), (int)2056);
                UIUtils.createLabelText((Composite)serverInfoPanel, (String)TeamMessages.auth_provider_dialog_composite_label_version, (String)apiInfo.getServerVersion(), (int)2056);
                return dialogArea;
            }
        }.open();
    }

    private void createAuthProviderTab(SMAuthProviderDescriptor apd) {
        if (!CommonUtils.isEmpty((Collection)apd.getCustomConfigurations())) {
            for (SMAuthProviderCustomConfiguration cc : apd.getCustomConfigurations()) {
                this.createAuthProviderTab(apd, cc);
            }
        } else {
            this.createAuthProviderTab(apd, null);
        }
    }

    private void createAuthProviderTab(@NotNull SMAuthProviderDescriptor provider, @Nullable SMAuthProviderCustomConfiguration customConfig) {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setData(DATA_PROVIDER, (Object)provider);
        if (customConfig != null) {
            item.setData(DATA_CONFIGURATION, (Object)customConfig);
        }
        item.setText(customConfig == null ? provider.getLabel() : customConfig.getDisplayName());
        if (provider.getIcon() != null) {
            Image image = DBeaverIcons.getImageByLocation((String)provider.getIcon());
            if (image != null) {
                item.setImage(image);
            } else {
                ImageDescriptor imageDescriptor = AuthProviderPromptDialog.getIdpIcon(provider);
                if (imageDescriptor != null) {
                    Image imageFromDescriptor = imageDescriptor.createImage();
                    item.setImage(imageFromDescriptor);
                    item.addDisposeListener(e -> imageFromDescriptor.dispose());
                }
            }
        }
        item.setToolTipText(CommonUtils.notEmpty((String)(customConfig == null ? provider.getDescription() : customConfig.getDescription())));
        this.createAuthProviderControls(item, provider, customConfig);
        if (this.configuration.getSelectedProviderId() != null && this.configuration.getSelectedProviderId().equals(provider.getId())) {
            this.tabFolder.setSelection(item);
        }
    }

    private static ImageDescriptor getIdpIcon(SMAuthProviderDescriptor apd) {
        String noExtensionPath = "platform:/plugin/com.dbeaver.model/icons/idp/" + apd.getId();
        ImageDescriptor image = TeamAppImages.getImageDescriptor(noExtensionPath + ".png");
        if (image == null || image.getImageData(100) == null) {
            image = TeamAppImages.getImageDescriptor(noExtensionPath + ".svg");
        }
        return image;
    }

    private void doFederatedAuthentication(SMAuthProviderDescriptor apd, SMAuthProviderCustomConfiguration cc) {
        this.configuration.setSelectedProviderId(apd.getId());
        this.configuration.setSelectedConfigurationId(cc.getId());
        this.okPressed();
    }

    private void createAuthProviderControls(@NotNull CTabItem item, @NotNull SMAuthProviderDescriptor provider, @Nullable SMAuthProviderCustomConfiguration customConfig) {
        Composite panel = new Composite((Composite)item.getParent(), 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 10;
        panel.setLayout((Layout)gl);
        item.setControl((Control)panel);
        List profiles = provider.getCredentialProfiles();
        if (profiles.size() == 1) {
            this.createProfileControls(panel, provider, (SMAuthCredentialsProfile)profiles.get(0), customConfig);
        } else {
            final Combo profileCombo = UIUtils.createLabelCombo((Composite)panel, (String)TeamMessages.auth_provider_dialog_combo_label_type, (int)12);
            profileCombo.setLayoutData((Object)new GridData(768));
            final Composite stackComp = new Composite(panel, 0);
            final StackLayout stackLayout = new StackLayout();
            stackComp.setLayout((Layout)stackLayout);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            stackComp.setLayoutData((Object)gd);
            HashMap<SMAuthCredentialsProfile, Composite> panelMap = new HashMap<SMAuthCredentialsProfile, Composite>();
            for (SMAuthCredentialsProfile profile : profiles) {
                profileCombo.add(profile.getLabel());
                Composite profilePanel = new Composite(stackComp, 0);
                profilePanel.setLayout((Layout)new GridLayout(2, false));
                panelMap.put(profile, profilePanel);
                this.createProfileControls(profilePanel, provider, profile, customConfig);
            }
            profileCombo.select(0);
            stackLayout.topControl = (Control)panelMap.get(profiles.get(0));
            profileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AuthProviderPromptDialog.this.profileComboIndex = profileCombo.getSelectionIndex();
                    stackLayout.topControl = stackComp.getChildren()[AuthProviderPromptDialog.this.profileComboIndex];
                    stackComp.layout();
                }
            });
        }
    }

    private boolean hasProfileControls(SMAuthCredentialsProfile profile) {
        for (AuthPropertyDescriptor prop : profile.getCredentialParameters()) {
            if (!prop.isUser()) continue;
            return true;
        }
        return false;
    }

    private void createProfileControls(@NotNull Composite panel, @NotNull SMAuthProviderDescriptor provider, @NotNull SMAuthCredentialsProfile profile, @Nullable SMAuthProviderCustomConfiguration customConfig) {
        boolean prevValueSet = false;
        for (AuthPropertyDescriptor prop : profile.getCredentialParameters()) {
            if (!prop.isUser()) continue;
            UIUtils.createControlLabel((Composite)panel, (String)prop.getDisplayName());
            boolean isPassword = prop.getEncryption() != AuthPropertyEncryption.none;
            Text text = new Text(panel, 0x800 | (isPassword ? 0x400000 : 0));
            if (!CommonUtils.isEmpty((String)prop.getDescription())) {
                text.setToolTipText(prop.getDescription());
            }
            GridData gd = new GridData(768);
            gd.widthHint = 200;
            text.setLayoutData((Object)gd);
            Object value = this.configuration.getAuthCredentials().get(prop.getId());
            if (value != null) {
                text.setText(CommonUtils.toString(value));
                prevValueSet = true;
            } else {
                if (prevValueSet) {
                    this.focusControl = text;
                }
                prevValueSet = false;
            }
            this.controlWrappers.add(new ConfigurationControlWrapper(provider, profile, customConfig, prop, text));
        }
    }

    protected void okPressed() {
        this.saveCredentials();
        super.okPressed();
    }

    private void saveCredentials() {
        if (this.tabFolder.getSelection() == null) {
            return;
        }
        CTabItem selectedTabs = this.tabFolder.getSelection();
        if (selectedTabs.getData(DATA_PROVIDER) == WEB_CONFIG) {
            return;
        }
        SMAuthProviderDescriptor provider = (SMAuthProviderDescriptor)selectedTabs.getData(DATA_PROVIDER);
        SMAuthCredentialsProfile profile = (SMAuthCredentialsProfile)selectedTabs.getData(DATA_PROFILE);
        SMAuthProviderCustomConfiguration authConfiguration = (SMAuthProviderCustomConfiguration)selectedTabs.getData(DATA_CONFIGURATION);
        if (profile == null) {
            profile = this.profileComboIndex > -1 && this.profileComboIndex < provider.getCredentialProfiles().size() ? (SMAuthCredentialsProfile)provider.getCredentialProfiles().get(this.profileComboIndex) : (SMAuthCredentialsProfile)provider.getCredentialProfiles().get(0);
        }
        this.configuration.setSelectedProviderId(provider.getId());
        this.configuration.setSelectedProfileId(profile.getId());
        this.configuration.setSelectedConfigurationId(authConfiguration == null ? null : authConfiguration.getId());
        LinkedHashMap<String, String> authCredentials = new LinkedHashMap<String, String>();
        SMAuthCredentialsProfile finalProfile = profile;
        for (AuthPropertyDescriptor prop : profile.getCredentialParameters()) {
            Text text = null;
            ConfigurationControlWrapper controlWrapper = this.controlWrappers.stream().filter(e -> e.provider() == provider && e.profile() == finalProfile && (authConfiguration == null || e.customConfig() == authConfiguration) && e.property() == prop).findFirst().orElse(null);
            if (controlWrapper != null) {
                text = controlWrapper.text();
            }
            if (text == null) {
                log.debug((Object)("Can't find a text field for the property " + prop.getDisplayName()));
                continue;
            }
            String controlValue = text.getText().trim();
            authCredentials.put(prop.getId(), controlValue);
        }
        this.configuration.setAuthCredentials(authCredentials);
    }

    public SMAuthPromptConfiguration getPromptConfiguration() {
        return this.configuration;
    }

    private record ConfigurationControlWrapper(@NotNull SMAuthProviderDescriptor provider, @NotNull SMAuthCredentialsProfile profile, @Nullable SMAuthProviderCustomConfiguration customConfig, @NotNull AuthPropertyDescriptor property, @NotNull Text text) {
    }
}

