/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui;

import com.dbeaver.model.auth.SMAuthProcessInteractive;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class AuthProgressDialog
extends BaseDialog {
    private static final Log log = Log.getLog(AuthProgressDialog.class);
    private final SMAuthProcessInteractive<?> callback;
    private boolean authFinished;
    private ProgressBar progressBar;
    private int tickCount;

    public AuthProgressDialog(Shell parentShell, SMAuthProcessInteractive<?> callback) {
        super(parentShell, callback.getTitle(), callback.getImage());
        this.callback = callback;
    }

    protected Composite createDialogArea(Composite parent) {
        this.initializeBounds();
        Composite authGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        authGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        authGroup.setLayoutData((Object)gd);
        String authenticationURL = this.callback.getAuthenticationURL();
        if (DBeaverActivator.getInstance().getPreferences().getBoolean("ui.use.redirect.auth")) {
            try {
                gd = new GridData(1808);
                gd.widthHint = 600;
                gd.heightHint = 500;
                Browser faBrowser = new Browser(authGroup, 2048);
                faBrowser.setLayoutData((Object)gd);
                faBrowser.setUrl(authenticationURL);
            }
            catch (Exception exception) {
                log.warn((Object)"Error launching embedded browser", (Throwable)exception);
                ShellUtils.launchProgram((String)authenticationURL);
            }
        } else {
            ShellUtils.launchProgram((String)authenticationURL);
        }
        Label titleLabel = new Label(authGroup, 0);
        titleLabel.setText(this.callback.getTitle());
        titleLabel.setLayoutData((Object)new GridData(64));
        this.progressBar = new ProgressBar(authGroup, 65792);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.progressBar.setLayoutData((Object)gd);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        Label hintLabel = new Label(authGroup, 0);
        hintLabel.setText("Waiting for authentication result. Press cancel to interrupt.");
        hintLabel.setLayoutData((Object)new GridData(64));
        gd = new GridData(64);
        gd.widthHint = 120;
        Button cancelButton = new Button(authGroup, 8);
        cancelButton.setLayoutData((Object)gd);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.cancelPressed()));
        new UpdateJob().schedule(this.callback.getUpdatePeriod());
        new AbstractJob("Progress bar"){

            public IStatus run(DBRProgressMonitor monitor) {
                UIUtils.syncExec(() -> {
                    if (!AuthProgressDialog.this.progressBar.isDisposed()) {
                        ++AuthProgressDialog.this.tickCount;
                        AuthProgressDialog.this.progressBar.setSelection(AuthProgressDialog.this.tickCount % 100);
                        this.schedule(100L);
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule(100L);
        return authGroup;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Control createButtonBar(Composite parent) {
        return UIUtils.createPlaceholder((Composite)parent, (int)1);
    }

    void updateStatus(DBRProgressMonitor monitor) {
        if (this.authFinished) {
            return;
        }
        try {
            this.authFinished = this.callback.checkForCompletion(monitor);
        }
        catch (DBException e) {
            UIUtils.syncExec(() -> UIUtils.showMessageBox((Shell)this.getShell(), (String)"Authentication error", (String)CommonUtils.notEmpty((String)e.getMessage()), (int)1));
            log.error((Object)e);
            this.authFinished = true;
        }
        if (this.authFinished) {
            UIUtils.asyncExec(() -> ((AuthProgressDialog)this).okPressed());
        }
    }

    protected void cancelPressed() {
        this.callback.setCanceled(true);
        super.cancelPressed();
    }

    private class UpdateJob
    extends AbstractJob {
        protected UpdateJob() {
            super("Update authentication status");
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            AuthProgressDialog.this.updateStatus(monitor);
            if (!AuthProgressDialog.this.authFinished) {
                this.schedule(AuthProgressDialog.this.callback.getUpdatePeriod());
            }
            return Status.OK_STATUS;
        }
    }
}

