/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.auth;

import com.dbeaver.model.auth.SMAuthProcessInteractive;
import com.dbeaver.remote.client.dc.json.DCClientUtils;
import com.google.gson.Gson;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMAuthStatus;
import org.jkiss.dbeaver.model.websocket.event.session.WSAuthEvent;

public class DCWebsocketAuth
extends Endpoint {
    private static final Log log = Log.getLog(DCWebsocketAuth.class);
    @NotNull
    private final SMAuthProcessInteractive<SMAuthInfo> authProcess;
    @Nullable
    private Session session;

    public DCWebsocketAuth(@NotNull SMAuthProcessInteractive<SMAuthInfo> authProcess) {
        this.authProcess = authProcess;
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        session.addMessageHandler(String.class, (MessageHandler.Whole)new AuthEventHandler());
    }

    public void onClose(Session session, CloseReason closeReason) {
        log.debug((Object)("Authentication websocket closed: " + closeReason.getReasonPhrase()));
    }

    public void onError(Session session, Throwable thr) {
        log.error((Object)("Error during auth websocket connection: " + thr.getMessage()), thr);
        this.authProcess.setError(thr);
    }

    private class AuthEventHandler
    implements MessageHandler.Whole<String> {
        private final Gson gson = DCClientUtils.buildDCGson();

        private AuthEventHandler() {
        }

        public void onMessage(String s) {
            log.debug((Object)"Auth event received");
            if (s.startsWith(DCClientUtils.WS_ERROR_PREFIX)) {
                DCWebsocketAuth.this.authProcess.setError((Throwable)new DBException(s));
                return;
            }
            WSAuthEvent event = (WSAuthEvent)this.gson.fromJson(s, WSAuthEvent.class);
            SMAuthInfo authInfo = event.getAuthInfo();
            DCWebsocketAuth.this.authProcess.setResult((Object)event.getAuthInfo());
            if (authInfo.getAuthStatus() != SMAuthStatus.IN_PROGRESS && DCWebsocketAuth.this.session != null && DCWebsocketAuth.this.session.isOpen()) {
                try {
                    DCWebsocketAuth.this.session.close(new CloseReason((CloseReason.CloseCode)new AuthFinished(), "authentication finished"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class AuthFinished
    implements CloseReason.CloseCode {
        private AuthFinished() {
        }

        public int getCode() {
            return 42;
        }
    }

    public static class Configurator
    extends ClientEndpointConfig.Configurator {
        @NotNull
        private final String appSessionId;

        public Configurator(@NotNull String appSessionId) {
            this.appSessionId = appSessionId;
        }

        public void beforeRequest(Map<String, List<String>> headers) {
            headers.put(DCClientUtils.WS_AUTH_SESSION_ID_HEADER, List.of(this.appSessionId));
        }
    }
}

