/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.application;

import com.dbeaver.application.EnterpriseWorkbenchAdvisor;
import com.dbeaver.application.EnterpriseWorkbenchWindowAdvisor;
import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.team.application.TeamWorkbenchAdvisor;
import com.dbeaver.team.ui.TeamAuthUI;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class TeamWorkbenchWindowAdvisor
extends EnterpriseWorkbenchWindowAdvisor {
    private static final Log log = Log.getLog(TeamWorkbenchWindowAdvisor.class);

    public TeamWorkbenchWindowAdvisor(TeamWorkbenchAdvisor advisor, IWorkbenchWindowConfigurer configurer) {
        super((EnterpriseWorkbenchAdvisor)advisor, configurer);
    }

    public void postWindowRestore() throws WorkbenchException {
        super.postWindowRestore();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        IWorkbenchPage activePage = window.getActivePage();
        IEditorReference[] editorReferences = activePage.getEditorReferences();
        ArrayList<IEditorReference> brokenEditors = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorInput editorInput;
            IEditorReference er = iEditorReferenceArray[n2];
            if ("org.eclipse.ui.part.FileEditorInputFactory".equals(er.getFactoryId()) && (editorInput = er.getEditorInput()) instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)editorInput).getFile();
                try {
                    file.getLocationURI();
                }
                catch (Exception e) {
                    log.debug((Object)("Close editor " + er.getName() + ": " + e.getMessage()));
                    brokenEditors.add(er);
                }
            }
            ++n2;
        }
        if (!brokenEditors.isEmpty()) {
            activePage.closeEditors(brokenEditors.toArray(new IEditorReference[0]), false);
        }
    }

    protected String computeTitle() {
        Object title = super.computeTitle();
        SMSession session = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
        if (session instanceof SMSessionRemote) {
            SMSessionRemote sr = (SMSessionRemote)session;
            title = (String)title + " @" + TeamAuthUI.stripServerURL(sr.getServerApi().getServerId());
        }
        return title;
    }
}

