/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.application;

import com.dbeaver.application.DBeaverApplicationAdvanced;
import com.dbeaver.cloud.registry.CPCloudSessionProvider;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import com.dbeaver.ee.runtime.auth.IdentityProviderRegistry;
import com.dbeaver.model.ai.RAGEmbeddingStorage;
import com.dbeaver.model.auth.SMApplicationIdentityProvider;
import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.model.auth.SMFederatedAuthProvider;
import com.dbeaver.model.auth.SMSessionAuthCredentials;
import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.qm.QMService;
import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.DCRemoteLicenseService;
import com.dbeaver.remote.client.rm.RMClientConfiguration;
import com.dbeaver.remote.client.rm.RemoteConfigurationController;
import com.dbeaver.remote.client.rm.RemoteFileController;
import com.dbeaver.remote.client.rm.RemoteTaskController;
import com.dbeaver.remote.workspace.DesktopWorkspaceRemote;
import com.dbeaver.remote.workspace.RemoteUserPreferenceStore;
import com.dbeaver.team.application.LMRoleFeatures;
import com.dbeaver.team.application.TeamApplicationPolicyProvider;
import com.dbeaver.team.application.TeamWorkbenchAdvisor;
import com.dbeaver.team.application.internal.TeamAppMessages;
import com.dbeaver.team.ui.TeamAuthCallbackHandler;
import com.dbeaver.team.workspace.TeamWorkspaceImpl;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.DBConfigurationController;
import org.jkiss.dbeaver.model.DBFileController;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPApplicationConfigurator;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.qm.QMConfigurationProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.model.secret.DBSDefaultTeamProvider;
import org.jkiss.dbeaver.model.security.exception.SMRefreshTokenExpiredException;
import org.jkiss.dbeaver.model.task.DBTTaskController;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.IOUtils;

public class DBeaverApplicationTeam
extends DBeaverApplicationAdvanced
implements DBPApplicationConfigurator,
QMConfigurationProvider,
SMFederatedAuthProvider,
DBSDefaultTeamProvider {
    private static final Log log = Log.getLog(DBeaverApplicationTeam.class);
    public static final String TEAM_WORKSPACE_NAME = "team-workspace";
    public static final String TEAM_WORKSPACES_CONFIG_FILE = ".team-workspaces";
    private LMRoleFeatures roleFeatures;
    private volatile boolean logoutPromoted;
    private TeamAuthCallbackHandler teamAuthCallbackHandler;
    private volatile RemoteUserPreferenceStore preferenceStore;

    public DBeaverApplicationTeam() {
        super("DBeaverData", TEAM_WORKSPACE_NAME, TEAM_WORKSPACES_CONFIG_FILE);
        AbstractRemoteClient.setRunRequestsInAsyncMode((boolean)true);
        AbstractRemoteClient.addExceptionHandler(exception -> {
            if (exception instanceof SMRefreshTokenExpiredException && !this.logoutPromoted) {
                this.logoutPromoted = true;
                UIUtils.asyncExec(() -> {
                    do {
                        DBWorkbench.getPlatformUI().showMessageBox(TeamAppMessages.dialog_session_expired_title, TeamAppMessages.dialog_session_expired_message, false);
                    } while (!PlatformUI.getWorkbench().restart());
                });
            }
        });
    }

    @NotNull
    public RAGEmbeddingStorage getEmbeddingStorage() throws DBException {
        return ((DesktopWorkspaceRemote)DBWorkbench.getPlatform().getWorkspace()).getEmbeddingStorage();
    }

    private void cleanupPreviousWorkspace() throws Exception {
        Location instanceLoc = Platform.getInstanceLocation();
        URL url = instanceLoc.getURL();
        Path workspacePath = Path.of(url.toURI());
        this.cleanupFolder(workspacePath.resolve(".remote"));
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Path> wsFiles = Files.list(workspacePath);){
            wsFiles.forEach(path -> {
                if (!path.getFileName().toString().startsWith(".")) {
                    this.cleanupFolder((Path)path);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Path metadataPath = workspacePath.resolve(".metadata");
        Path pluginsFolder = metadataPath.resolve(".plugins");
        this.cleanupFolder(pluginsFolder.resolve("org.eclipse.core.filesystem"));
        this.cleanupFolder(pluginsFolder.resolve("org.eclipse.core.resources"));
    }

    private void cleanupFolder(Path folder) {
        if (!Files.exists(folder, new LinkOption[0])) {
            return;
        }
        try {
            IOUtils.deleteDirectory((Path)folder);
        }
        catch (IOException e) {
            log.error((Object)("Error deleting folder " + String.valueOf(folder)), (Throwable)e);
        }
    }

    public boolean isDistributed() {
        return true;
    }

    public boolean hasProductFeature(@NotNull String featureName) {
        if ("multi-fs".equals(featureName)) {
            return true;
        }
        if (this.roleFeatures == null) {
            SMAuthInfo authInfo = (SMAuthInfo)GeneralUtils.adapt((Object)DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession(), SMAuthInfo.class);
            if (authInfo != null) {
                this.roleFeatures = LMRoleFeatures.valueOf(authInfo.getAuthRole());
            } else {
                log.error((Object)"Cannot determine current auth info");
            }
        }
        return this.roleFeatures != null && !this.roleFeatures.getDisabledFeatures().contains(featureName);
    }

    @NotNull
    protected ApplicationWorkbenchAdvisor createWorkbenchAdvisor() {
        return new TeamWorkbenchAdvisor((DBPApplication)this);
    }

    public void beforeWorkspaceInitialization() {
        super.beforeWorkspaceInitialization();
        try {
            this.cleanupPreviousWorkspace();
        }
        catch (Exception e) {
            log.error((Object)"Error while cleaning workspace", (Throwable)e);
        }
        ApplicationPolicyProvider.setInstance((ApplicationPolicyProvider)new TeamApplicationPolicyProvider());
    }

    @NotNull
    public TeamWorkspaceImpl createWorkspace(@NotNull DBPPlatform platform) {
        this.teamAuthCallbackHandler = new TeamAuthCallbackHandler();
        return new TeamWorkspaceImpl(platform, this.loadEclipseWorkspace(), this.teamAuthCallbackHandler);
    }

    @Nullable
    private SMSessionRemote getRemoteSession() {
        SMSession spaceSession = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
        return (SMSessionRemote)DBUtils.getAdapter(SMSessionRemote.class, (Object)spaceSession);
    }

    protected DBPLicenseService createLicenseService() {
        SMSessionRemote sessionRemote = this.getRemoteSession();
        if (sessionRemote != null) {
            DCClientConfiguration clientConfig = DCClientConfiguration.builder((SMSessionRemote)sessionRemote).build();
            return new DCRemoteLicenseService(clientConfig);
        }
        return super.createLicenseService();
    }

    public QMService getQueryManagerService() {
        QMService remoteService = ((DesktopWorkspaceRemote)DBWorkbench.getPlatform().getWorkspace()).getActiveQueryManagerService();
        if (remoteService != null) {
            return remoteService;
        }
        return super.getQueryManagerService();
    }

    @NotNull
    public DBConfigurationController createConfigurationController(@Nullable String pluginId) {
        Path configPath = DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(".config");
        RMClientConfiguration rmClientConfiguration = this.getRmClientConfiguration();
        return new RemoteConfigurationController(rmClientConfiguration, configPath);
    }

    @NotNull
    public DBFileController createFileController() {
        return new RemoteFileController(this.getRmClientConfiguration());
    }

    @NotNull
    public DBTTaskController createTaskController() {
        return new RemoteTaskController(this.getRmClientConfiguration());
    }

    private RMClientConfiguration getRmClientConfiguration() {
        DesktopWorkspaceRemote workspace = (DesktopWorkspaceRemote)DBWorkbench.getPlatform().getWorkspace();
        return workspace.getRmClientConfiguration();
    }

    protected boolean tryMigrateFromPreviousVersion(Path homeDir) {
        return true;
    }

    public long getEventDispatchPeriod() {
        return 1000L;
    }

    public boolean updateFederatedCredentialsFromSession(final @NotNull DBRProgressMonitor monitor, final @NotNull String authContextType, final @NotNull String authSpaceTitle, final @NotNull SMSessionAuthCredentials credentials) throws DBException {
        return Boolean.TRUE.equals(UIUtils.syncExec((RunnableWithResult)new RunnableWithResult<Object>(){

            public Boolean runWithResult() {
                try {
                    return DBeaverApplicationTeam.this.askFederatedAuth(monitor, authContextType, authSpaceTitle, credentials);
                }
                catch (DBException e) {
                    log.debug((Object)e);
                    return false;
                }
            }
        }));
    }

    public boolean isWorkspaceSwitchingAllowed() {
        return true;
    }

    public boolean isEarlyAccessProgram() {
        return false;
    }

    public boolean isEarlyAccessBuild() {
        return false;
    }

    private boolean askFederatedAuth(@NotNull DBRProgressMonitor monitor, @NotNull String authContextType, @NotNull String authSpaceTitle, @NotNull SMSessionAuthCredentials credentials) throws DBException {
        CPCloudSessionProvider sessionProvider;
        SMSessionRemote sa;
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        SMApplicationIdentityProvider identityProvider = IdentityProviderRegistry.getInstance().getGlobalIdentityProvider();
        SMSession mainSession = SMAuthUtils.getPrimarySession((DBRProgressMonitor)monitor, (DBPWorkspace)workspace);
        SMSession extraSession = identityProvider.acquireApplicationSession(monitor, authSpaceTitle, mainSession, workspace, (CallbackHandler)this.teamAuthCallbackHandler);
        if (mainSession instanceof SMSessionRemote && (sa = (SMSessionRemote)mainSession).aggregateSubSession(authContextType, extraSession) && (sessionProvider = CloudProviderRegistry.getInstance().getSessionProvider(authContextType)) != null) {
            return sessionProvider.updateCredentialsFromSession(mainSession, (DBAAuthCredentials)credentials);
        }
        return false;
    }

    public String getDefaultTeamId() {
        return ((DesktopWorkspaceRemote)DBWorkbench.getPlatform().getWorkspace()).getAppConfiguration().getDefaultTeamId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RemoteUserPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            DBeaverApplicationTeam dBeaverApplicationTeam = this;
            synchronized (dBeaverApplicationTeam) {
                if (this.preferenceStore == null) {
                    this.preferenceStore = new RemoteUserPreferenceStore(DBeaverActivator.getInstance().getPreferences());
                }
            }
        }
        return this.preferenceStore;
    }

    @Nullable
    public String defaultDistributedDriversFolderName() {
        return "team";
    }
}

