/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui.admin;

import com.dbeaver.team.model.TeamManager;
import com.dbeaver.team.ui.admin.SelectSubjectDialog;
import com.dbeaver.team.ui.admin.SubjectsFolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.security.SMSubjectType;
import org.jkiss.dbeaver.model.security.user.SMSubject;
import org.jkiss.dbeaver.model.security.user.SMTeam;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.utils.CommonUtils;

class TeamsFolder
extends SubjectsFolder<SMTeam> {
    private Text teamNameText;
    private Text teamDescriptionText;
    private TableViewer usersViewer;
    private SMTeam currentTeam;

    public TeamsFolder(IWorkbenchPart part) {
        super(part);
    }

    @Override
    @NotNull
    protected SMSubjectType getSubjectType() {
        return SMSubjectType.team;
    }

    @Override
    protected SMSubject getCurrentSubject() {
        return this.currentTeam;
    }

    @Override
    protected Collection<SMTeam> loadObjects(DBRProgressMonitor monitor) throws DBException {
        ArrayList<SMTeam> teams = new ArrayList<SMTeam>(TeamManager.getInstance().getAllTTeams());
        teams.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return teams;
    }

    @Override
    protected DBPImage getObjectImage(SMTeam item) {
        return DBIcon.TREE_USER_GROUP;
    }

    @Override
    protected boolean isObjectMatches(SMTeam element, String searchString) {
        return element.getName().toUpperCase().contains(searchString.toUpperCase());
    }

    @Override
    protected void contributeToToolbar(IContributionManager contributionManager) {
        contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Create"){
            {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ADD));
                this.setToolTipText("Create new team");
            }

            public void run() {
                TeamsFolder.this.createNewTeam();
            }
        }, (boolean)true));
        Action deleteAction = new Action("Delete"){
            {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DELETE));
                this.setToolTipText("Delete team");
            }

            public void run() {
                TeamsFolder.this.deleteSelectedTeams();
            }
        };
        deleteAction.setEnabled(false);
        contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)deleteAction, (boolean)true));
        super.contributeToToolbar(contributionManager);
        this.getObjectList().getItemsViewer().addSelectionChangedListener(event -> deleteAction.setEnabled(!event.getStructuredSelection().isEmpty()));
    }

    @Override
    public void createDetailsPanel(Composite parent) {
        Composite main = UIUtils.createComposite((Composite)parent, (int)2);
        ((GridLayout)main.getLayout()).makeColumnsEqualWidth = true;
        main.setLayoutData((Object)new GridData(1808));
        Group infoPanel = UIUtils.createControlGroup((Composite)main, (String)"Information", (int)2, (int)768, (int)-1);
        infoPanel.setLayoutData((Object)new GridData(770));
        this.teamNameText = UIUtils.createLabelText((Composite)infoPanel, (String)"Name", null, (int)2056);
        this.teamDescriptionText = UIUtils.createLabelText((Composite)infoPanel, (String)"Description", null, (int)2056);
        this.createMetaParams(main);
        Group usersPanel = UIUtils.createControlGroup((Composite)main, (String)"Users", (int)1, (int)768, (int)-1);
        usersPanel.setLayoutData((Object)new GridData(1808));
        this.usersViewer = new TableViewer((Composite)usersPanel, 2);
        this.usersViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.usersViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.usersViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_USER);
            }
        });
        ToolBar usersToolbar = new ToolBar((Composite)usersPanel, 131328);
        UIUtils.createToolItem((ToolBar)usersToolbar, (String)"Add", (String)"Add", (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamsFolder.this.addUserAccess();
            }
        });
        ToolItem removeTeamItem = UIUtils.createToolItem((ToolBar)usersToolbar, (String)"Remove", (String)"Remove", (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamsFolder.this.removeUserAccess(TeamsFolder.this.usersViewer.getStructuredSelection().toList());
            }
        });
        removeTeamItem.setEnabled(false);
        this.usersViewer.addSelectionChangedListener(event -> removeTeamItem.setEnabled(!event.getSelection().isEmpty()));
        this.createProjectsPanel(main);
    }

    @Override
    public void fillDetailsPanel(SMTeam object) {
        this.currentTeam = object;
        this.teamNameText.setText(object.getTeamName());
        this.teamDescriptionText.setText(CommonUtils.notEmpty((String)object.getDescription()));
        this.loadMetaParams((SMSubject)object);
        this.usersViewer.setInput(Collections.emptyList());
        try {
            this.usersViewer.setInput(TeamManager.getInstance().getTeamUsers(object));
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error reading team users", null, (Throwable)e);
        }
        this.loadProjectsDetails((SMSubject)object);
    }

    private void addUserAccess() {
        SelectSubjectDialog dialog = new SelectSubjectDialog(this.getObjectList().getShell(), SelectSubjectDialog.SubjectType.USER);
        List currentUsers = (List)this.usersViewer.getInput();
        dialog.setExcludeSubjects(currentUsers);
        if (dialog.open() == 0) {
            List<SMSubject> selectedUsers = dialog.getSelectedSubjects();
            HashSet newUserList = new HashSet(currentUsers);
            newUserList.addAll(selectedUsers.stream().map(SMSubject::getSubjectId).collect(Collectors.toList()));
            try {
                for (String userID : newUserList) {
                    List<String> userTeams = Arrays.stream(TeamManager.getInstance().getAdminController().getUserTeams(userID)).map(SMTeam::getTeamId).collect(Collectors.toList());
                    if (userTeams.contains(this.currentTeam.getTeamId())) continue;
                    userTeams.add(this.currentTeam.getTeamId());
                    TeamManager.getInstance().getAdminController().setUserTeams(userID, userTeams.toArray(new String[0]), TeamManager.getInstance().getCurrentUserId());
                }
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error changing user teams", null, (Throwable)e);
                return;
            }
            this.fillDetailsPanel(this.currentTeam);
        }
    }

    private void removeUserAccess(List<String> userIDs) {
        if (!UIUtils.confirmAction((Shell)this.getObjectList().getShell(), (String)"Remove from team", (String)("Are you sure you want to remove user '" + String.valueOf(userIDs) + "' from team '" + this.currentTeam.getTeamId() + "'?"))) {
            return;
        }
        try {
            for (String userID : userIDs) {
                List<String> userTeams = Arrays.stream(TeamManager.getInstance().getAdminController().getUserTeams(userID)).map(SMTeam::getTeamId).collect(Collectors.toList());
                if (!userTeams.contains(this.currentTeam.getTeamId())) continue;
                userTeams.remove(this.currentTeam.getTeamId());
                TeamManager.getInstance().getAdminController().setUserTeams(userID, userTeams.toArray(new String[0]), TeamManager.getInstance().getCurrentUserId());
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error changing user teams", null, (Throwable)e);
            return;
        }
        this.fillDetailsPanel(this.currentTeam);
    }

    private void createNewTeam() {
        EnterNameDialog dialog = new EnterNameDialog(this.getObjectList().getShell(), "Team name", null);
        if (dialog.open() == 0) {
            String teamName = dialog.getResult();
            try {
                this.currentTeam = TeamManager.getInstance().getAdminController().createTeam(teamName, teamName, null, TeamManager.getInstance().getCurrentUserId());
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error creating new team", null, (Throwable)e);
                return;
            }
            this.getObjectList().appendListData(Collections.singletonList(this.currentTeam));
            this.getObjectList().getItemsViewer().setSelection((ISelection)new StructuredSelection((Object)this.currentTeam));
            this.fillDetailsPanel(this.currentTeam);
        }
    }

    private void deleteSelectedTeams() {
        List selectedTeams = this.getObjectList().getItemsViewer().getStructuredSelection().toList();
        if (selectedTeams.isEmpty()) {
            return;
        }
        String teamIds = selectedTeams.stream().map(SMTeam::getTeamId).collect(Collectors.joining(" "));
        if (!UIUtils.confirmAction((Shell)this.getObjectList().getShell(), (String)"Delete team(s)", (String)("Are you sure you want to delete team(s) '" + teamIds + "'?"))) {
            return;
        }
        DBSSecretController secretController = null;
        try {
            secretController = DBSSecretController.getGlobalSecretController();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Error getting secret controller", null, (Throwable)e);
        }
        for (SMTeam team : selectedTeams) {
            try {
                if (secretController != null) {
                    secretController.deleteSubjectSecrets(team.getTeamId());
                }
                TeamManager.getInstance().getAdminController().deleteTeam(team.getTeamId(), false);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error deleting team " + team.getTeamId(), null, (Throwable)e);
            }
        }
        this.currentTeam = null;
        this.getObjectList().loadData();
    }
}

