/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui.admin;

import com.dbeaver.team.model.TeamManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPPage;
import org.jkiss.dbeaver.model.security.user.SMSubject;
import org.jkiss.dbeaver.model.security.user.SMUser;
import org.jkiss.dbeaver.model.security.user.SMUserFilter;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

class SelectSubjectDialog
extends BaseDialog {
    private final SubjectType subjectType;
    private List<String> excludedSubjects;
    private List<SMSubject> selectedSubjects;

    public SelectSubjectDialog(Shell parentShell, SubjectType subjectType) {
        super(parentShell, "Add " + subjectType.title, (DBPImage)DBIcon.TREE_FOLDER_USER);
        this.subjectType = subjectType;
    }

    public void setExcludeSubjects(List<String> subjects) {
        this.excludedSubjects = subjects;
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)this.subjectType.subTitle, (int)1, (int)1808, (int)-1);
        group.setLayoutData((Object)new GridData(1808));
        TableViewer subjectViewer = new TableViewer((Composite)group, 2);
        subjectViewer.getTable().setLayoutData((Object)new GridData(1808));
        subjectViewer.setContentProvider((IContentProvider)new ListContentProvider());
        subjectViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((SMSubject)element).getSubjectId();
            }

            public Image getImage(Object element) {
                if (element instanceof SMUser) {
                    return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_USER);
                }
                return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_USER_GROUP);
            }
        });
        ArrayList<Object> allSubjects = new ArrayList<Object>();
        try {
            if (this.subjectType == SubjectType.TEAM || this.subjectType == SubjectType.ALL) {
                allSubjects.addAll(TeamManager.getInstance().getAllTTeams());
            }
            if (this.subjectType == SubjectType.USER || this.subjectType == SubjectType.ALL) {
                allSubjects.addAll(TeamManager.getInstance().getUsers(new SMUserFilter(new DBPPage(0, Integer.MAX_VALUE))));
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error reading subjects", null, (Throwable)e);
        }
        if (!CommonUtils.isEmpty(this.excludedSubjects)) {
            allSubjects.removeIf(subject -> this.excludedSubjects.contains(subject.getSubjectId()));
        }
        subjectViewer.setInput(allSubjects);
        subjectViewer.addSelectionChangedListener(event -> {
            this.selectedSubjects = event.getStructuredSelection().toList();
        });
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public List<SMSubject> getSelectedSubjects() {
        return this.selectedSubjects;
    }

    public static enum SubjectType {
        USER("user", "Users"),
        TEAM("team", "Teams"),
        ALL("access", "Subjects");

        public final String title;
        public final String subTitle;

        private SubjectType(String title, String subTitle) {
            this.title = title;
            this.subTitle = subTitle;
        }
    }
}

