/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui.admin;

import com.dbeaver.team.model.TeamManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.rm.RMProjectType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

class SelectProjectDialog
extends BaseDialog {
    private List<String> excludedProjects;
    private List<RMProject> selectedProjects;

    public SelectProjectDialog(Shell parentShell) {
        super(parentShell, "Add project", (DBPImage)DBIcon.TREE_FOLDER_USER);
    }

    public void setExcludeProjects(List<String> projects) {
        this.excludedProjects = projects;
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)"Projects", (int)1, (int)1808, (int)-1);
        group.setLayoutData((Object)new GridData(1808));
        TableViewer projectViewer = new TableViewer((Composite)group, 2);
        projectViewer.getTable().setLayoutData((Object)new GridData(1808));
        projectViewer.setContentProvider((IContentProvider)new ListContentProvider());
        projectViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((RMProject)element).getDisplayName();
            }

            public Image getImage(Object element) {
                return DBeaverIcons.getImage((DBPImage)DBIcon.PROJECT);
            }
        });
        try {
            ArrayList<RMProject> allSubjects = new ArrayList<RMProject>(TeamManager.getInstance().getProjects(null));
            allSubjects.removeIf(p -> p.getType() != RMProjectType.SHARED);
            if (!CommonUtils.isEmpty(this.excludedProjects)) {
                allSubjects.removeIf(p -> this.excludedProjects.contains(p.getId()));
            }
            projectViewer.setInput(allSubjects);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error reading projects", null, (Throwable)e);
        }
        projectViewer.addSelectionChangedListener(event -> {
            this.selectedProjects = event.getStructuredSelection().toList();
        });
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public List<RMProject> getSelectedProjects() {
        return this.selectedProjects;
    }
}

