/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.license;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseFormat;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMSubscription;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.license.app.LMAppUtils;
import com.dbeaver.ui.license.LMUIConstants;
import com.dbeaver.ui.license.LicenseManagementDialog;
import com.dbeaver.ui.license.LicenseUIUtils;
import com.dbeaver.ui.license.internal.LMUIMessages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class LicenseInfoDialog
extends BaseDialog {
    private static final int MANAGER_BUTTON_ID = 3000;
    private static final int EXPORT_BUTTON_ID = 3001;
    private LMLicense viewLicense = null;
    private LMException validateException = null;

    public LicenseInfoDialog(Shell parentShell) {
        super(parentShell, LMUIMessages.dialog_area_title_text_license_information, null);
    }

    void setViewLicense(LMLicense viewLicense) {
        this.viewLicense = viewLicense;
    }

    protected Composite createDialogArea(Composite parent) {
        LMLicense productLicense = this.getProductLicense();
        Composite composite = super.createDialogArea(parent);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)LMUIMessages.dialog_area_control_group_license, (int)2, (int)1808, (int)0);
        if (productLicense == null) {
            Label naLabel = new Label((Composite)group, 0);
            GridData gd = new GridData(64);
            gd.horizontalSpan = 2;
            naLabel.setLayoutData((Object)gd);
            naLabel.setText(this.validateException == null ? "No Valid License Found" : this.validateException.getMessage());
        } else {
            try {
                String productName;
                DBPLicenseService licenseService = LMAppUtils.getLicenseService();
                LMProduct product = LMAppUtils.getActiveProduct();
                LMSubscription subscription = null;
                if (productLicense.isSubscription()) {
                    subscription = licenseService.getSubscriptionInfo(productLicense);
                }
                if ((productName = productLicense.getProductId()).equals(product.getId())) {
                    productName = product.getName();
                }
                UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_product, (String)productName, (int)2056);
                GridData gd = new GridData(768);
                gd.horizontalSpan = 2;
                gd.minimumWidth = 300;
                new Label((Composite)group, 258).setLayoutData((Object)gd);
                UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_license_id, (String)productLicense.getLicenseId(), (int)2056);
                UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_license_type, (String)productLicense.getLicenseTypeFull(), (int)2056);
                UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_license_to, (String)productLicense.getOwnerFull(), (int)2056);
                if (productLicense.getFormat() != LMLicenseFormat.STANDARD) {
                    UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_license_email, (String)productLicense.getOwnerEmail(), (int)2056);
                }
                if (!DBWorkbench.isDistributed()) {
                    this.showLicenseExpireAndUsers(productLicense, group, subscription);
                }
            }
            catch (LMException e) {
                DBWorkbench.getPlatformUI().showError("Error getting license info", "Error getting license info from LM service", (Throwable)e);
            }
        }
        return parent;
    }

    private void showLicenseExpireAndUsers(LMLicense productLicense, Group group, LMSubscription subscription) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.minimumWidth = 300;
        new Label((Composite)group, 258).setLayoutData((Object)gd);
        if (productLicense.getFormat() != LMLicenseFormat.STANDARD && subscription == null) {
            UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_users, (String)LicenseUIUtils.getLicenseUserNumber(productLicense), (int)2056);
            if (productLicense.getYearsNumber() > 0 && productLicense.getLicenseType() != LMLicenseType.EAP) {
                UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_support_period, (String)LicenseUIUtils.getLicenseSupportPeriod(productLicense), (int)2056);
            }
        }
        if (subscription != null) {
            UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_renew_time, (String)LMUIConstants.DATE_FORMAT.format(subscription.getLastRenewDate()), (int)2056);
            UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_expire_time, (String)LMUIConstants.DATE_FORMAT.format(subscription.getExpirationDate()), (int)2056);
        } else {
            UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_issue_time, (String)LMUIConstants.DATE_FORMAT.format(productLicense.getLicenseIssueTime()), (int)2056);
            UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_renew_time, (String)LMUIConstants.DATE_FORMAT.format(productLicense.getLicenseStartTime()), (int)2056);
            UIUtils.createLabelText((Composite)group, (String)LMUIMessages.dialog_area_label_text_end_time, (String)(productLicense.getLicenseEndTime() == null ? LMUIMessages.dialog_area_label_text_perpetual : LMUIConstants.DATE_FORMAT.format(productLicense.getLicenseEndTime())), (int)2056);
        }
    }

    private LMLicense getProductLicense() {
        LMLicense productLicense = this.viewLicense;
        if (productLicense == null) {
            try {
                return LMAppUtils.getLicenseService().getActiveProductLicense(true);
            }
            catch (LMException e) {
                this.validateException = e;
            }
        }
        return productLicense;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridData)parent.getLayoutData()).grabExcessHorizontalSpace = true;
        boolean isDistributed = DBWorkbench.isDistributed();
        if (this.viewLicense == null && !isDistributed) {
            Button lmButton = this.createButton(parent, 3000, LMUIMessages.dialog_area_button_license_manager, false);
            ((GridData)lmButton.getLayoutData()).horizontalAlignment = 1;
            ((GridData)lmButton.getLayoutData()).grabExcessHorizontalSpace = true;
        }
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        ((GridData)okButton.getLayoutData()).horizontalAlignment = 3;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 3000: {
                super.buttonPressed(0);
                LicenseManagementDialog dialog = new LicenseManagementDialog(this.getShell());
                dialog.open();
                break;
            }
            case 3001: {
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }
}

