/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.license;

import com.dbeaver.ui.license.internal.LMUIMessages;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;

public final class EapAgreementDialog
extends Dialog {
    private Button nonCommercialUsageCheck;
    private Button usageStatisticsCheck;
    private final String defaultWorkspaceName;
    private final String defaultProjectName = DBWorkbench.getPlatform().getApplication().getDefaultProjectName();
    private final int maxDatabaseConnections;
    private final int maxTasks;
    private final int maxDaysUse;

    public EapAgreementDialog(@NotNull Shell shell) {
        super(shell);
        this.defaultWorkspaceName = "workspace6";
        this.maxDatabaseConnections = 3;
        this.maxTasks = 5;
        this.maxDaysUse = 31;
    }

    public void create() {
        super.create();
        this.getShell().setText(LMUIMessages.dialog_eap_agreement_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        FormToolkit toolkit = new FormToolkit(composite.getDisplay());
        Composite form = toolkit.createComposite(composite, 2048);
        form.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        form.setLayout((Layout)new GridLayout());
        String body = MessageFormat.format(LMUIMessages.dialog_eap_agreement_body, this.maxDatabaseConnections, this.maxTasks, this.defaultWorkspaceName, this.defaultProjectName, this.maxDaysUse);
        FormText text = toolkit.createFormText(form, false);
        text.setFont("header", JFaceResources.getFont((String)"org.eclipse.jface.headerfont"));
        text.setFont("banner", JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        text.setText(body, true, false);
        text.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
        text.addHyperlinkListener(IHyperlinkListener.linkActivatedAdapter(hyperlinkEvent -> {
            Object href = hyperlinkEvent.getHref();
            if (href != null) {
                ShellUtils.launchProgram((String)href.toString());
            }
        }));
        text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(640, -1).create());
        LabelFactory.newLabel((int)64).text(LMUIMessages.dialog_eap_agreement_body_confirm_label).create((Widget)composite);
        this.nonCommercialUsageCheck = (Button)ButtonFactory.newButton((int)32).text(LMUIMessages.dialog_eap_agreement_body_confirm_non_commercial_use_check).onSelect(e -> this.updateButtonEnablement()).create((Widget)composite);
        this.usageStatisticsCheck = (Button)ButtonFactory.newButton((int)32).text(LMUIMessages.dialog_eap_agreement_body_confirm_usage_statistics_check).onSelect(e -> this.updateButtonEnablement()).create((Widget)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.PROCEED_LABEL, true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void updateButtonEnablement() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(this.nonCommercialUsageCheck.getSelection() && this.usageStatisticsCheck.getSelection());
        }
    }
}

