/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ReservationOffering;

public class ListReservationOfferingsIterable
implements SdkIterable<ListReservationOfferingsResponse> {
    private final RedshiftServerlessClient client;
    private final ListReservationOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReservationOfferingsIterable(RedshiftServerlessClient client, ListReservationOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReservationOfferingsResponseFetcher();
    }

    public Iterator<ListReservationOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservationOffering> reservationOfferingsList() {
        Function<ListReservationOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservationOfferingsList() != null) {
                return response.reservationOfferingsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReservationOfferingsResponseFetcher
    implements SyncPageFetcher<ListReservationOfferingsResponse> {
        private ListReservationOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(ListReservationOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReservationOfferingsResponse nextPage(ListReservationOfferingsResponse previousPage) {
            if (previousPage == null) {
                return ListReservationOfferingsIterable.this.client.listReservationOfferings(ListReservationOfferingsIterable.this.firstRequest);
            }
            return ListReservationOfferingsIterable.this.client.listReservationOfferings((ListReservationOfferingsRequest)((Object)ListReservationOfferingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

