/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.dataset.storage;

import com.dbeaver.model.dataset.DBDDataSet;
import com.dbeaver.model.dataset.DBDDataSetQuery;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatasetStorage {
    private static final String TAG_DATASET = "dataset";
    private static final String TAG_QUERIES = "queries";
    private static final String TAG_QUERY = "query";
    private static final String TAG_TEXT = "text";
    private static final String TAG_FILTERS = "filters";
    private static final String TAG_CONSTRAINT = "constraint";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_QUERY_TEXT = "queryText";
    private static final String ATTR_DRAFT = "draft";
    private static final String ATTR_DATA_SOURCE = "data-source";
    private static final String ATTR_CATALOG = "catalog";
    private static final String ATTR_SCHEMA = "schema";
    private static final String ATTR_ORDER = "order";
    private static final String ATTR_WHERE = "where";
    private static final String ATTR_ANY_CONSTRAINT = "anyConstraint";
    private static final String ATTR_LABEL = "attributeLabel";
    private static final String ATTR_PLAIN_NAME = "plainNameReference";
    private static final String ATTR_VISUAL_POSITION = "originalVisualPosition";
    private static final String ATTR_ORDER_POSITION = "originalOrderPosition";
    private static final String ATTR_ORDER_DESCENDING = "orderDescending";
    private static final String ATTR_CRITERIA = "criteria";
    private static final String ATTR_OPERATOR = "operator";
    private static final String ATTR_REVERSE_OPERATOR = "reverseOperator";
    private final DBDDataSet dataSet;

    public DatasetStorage(DBDDataSet dataSet) {
        this.dataSet = dataSet;
    }

    public DatasetStorage(String datasetName, byte[] xmlData, DBPDataSourceRegistry dataSourceRegistry) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayInputStream contents = new ByteArrayInputStream(xmlData);){
                Document document = XMLUtils.parseDocument((InputStream)contents);
                Element root = document.getDocumentElement();
                this.dataSet = new DBDDataSet(datasetName);
                this.dataSet.setDescription(root.getAttribute(ATTR_DESCRIPTION));
                this.dataSet.setDraft(CommonUtils.toBoolean((Object)root.getAttribute(ATTR_DRAFT)));
                this.deserializeQueries(root, this.dataSet, dataSourceRegistry);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBException("IO Error reading dataset '" + datasetName + "'", (Throwable)e);
        }
    }

    private void deserializeQueries(Element root, DBDDataSet dataSet, DBPDataSourceRegistry dataSourceRegistry) throws DBException {
        Element queriesElement = this.getSingleChildElement(root, TAG_QUERIES);
        if (queriesElement == null) {
            return;
        }
        NodeList allQueries = queriesElement.getElementsByTagName(TAG_QUERY);
        int i = 0;
        while (i < allQueries.getLength()) {
            Element queryElement = (Element)allQueries.item(i);
            dataSet.addQuery(this.deserializeQuery(queryElement, dataSourceRegistry));
            ++i;
        }
    }

    @Nullable
    private Element getSingleChildElement(Element root, String tagName) {
        NodeList elementsList = root.getElementsByTagName(tagName);
        if (elementsList.getLength() == 0) {
            return null;
        }
        if (elementsList.getLength() > 1) {
            try {
                throw new DBException("Error reading dataset: dataset contains multiple '" + tagName + "'  tag");
            }
            catch (DBException e) {
                throw new RuntimeException(e);
            }
        }
        return (Element)elementsList.item(0);
    }

    private DBDDataSetQuery deserializeQuery(Element queryElement, DBPDataSourceRegistry dataSourceRegistry) {
        DBDDataSetQuery query = new DBDDataSetQuery(queryElement.getAttribute(ATTR_ID));
        query.setDescription(CommonUtils.nullIfEmpty((String)queryElement.getAttribute(ATTR_DESCRIPTION)));
        Element textElement = this.getSingleChildElement(queryElement, TAG_TEXT);
        if (textElement != null) {
            query.setQueryText(textElement.getTextContent());
        } else {
            query.setQueryText(queryElement.getAttribute(ATTR_QUERY_TEXT));
        }
        query.setDataSourceContainer(dataSourceRegistry.getDataSource(queryElement.getAttribute(ATTR_DATA_SOURCE)));
        query.setCatalog(CommonUtils.nullIfEmpty((String)queryElement.getAttribute(ATTR_CATALOG)));
        query.setSchema(CommonUtils.nullIfEmpty((String)queryElement.getAttribute(ATTR_SCHEMA)));
        Element filtersElement = this.getSingleChildElement(queryElement, TAG_FILTERS);
        if (filtersElement != null) {
            DBDDataFilter filter = this.deserializeFilter(filtersElement);
            query.setDataFilters(filter);
        }
        return query;
    }

    public DBDDataSet getDataSet() {
        return this.dataSet;
    }

    public ByteArrayInputStream serialize() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(5000);
        XMLBuilder xml = new XMLBuilder((OutputStream)buffer, GeneralUtils.getDefaultFileEncoding());
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLBuilder.Element datasetXmlElement = xml.startElement(TAG_DATASET);){
            if (this.dataSet.getDescription() != null) {
                xml.addAttribute(ATTR_DESCRIPTION, this.dataSet.getDescription());
            }
            xml.addAttribute(ATTR_DRAFT, String.valueOf(this.dataSet.isDraft()));
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (XMLBuilder.Element queriesXmlElement = xml.startElement(TAG_QUERIES);){
                for (DBDDataSetQuery query : this.dataSet.getQueries()) {
                    this.serializeQuery(xml, query);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        xml.flush();
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    private void serializeQuery(XMLBuilder xml, DBDDataSetQuery query) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLBuilder.Element queryXmlElement = xml.startElement(TAG_QUERY);){
            xml.addAttribute(ATTR_ID, query.getId());
            xml.addAttribute(ATTR_DATA_SOURCE, query.getDataSourceContainer().getId());
            this.addAttributeIfNotEmpty(xml, ATTR_CATALOG, query.getCatalog());
            this.addAttributeIfNotEmpty(xml, ATTR_SCHEMA, query.getSchema());
            this.addAttributeIfNotEmpty(xml, ATTR_DESCRIPTION, query.getDescription());
            this.serializeQueryFilters(xml, query.getDataFilters());
            this.serializeQueryText(xml, query.getQueryText());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void serializeQueryText(@NotNull XMLBuilder xml, @NotNull String queryText) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLBuilder.Element ignored = xml.startElement(TAG_TEXT);){
            xml.addTextData(queryText);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void serializeQueryFilters(XMLBuilder xml, DBDDataFilter dataFilters) throws IOException {
        if (dataFilters == null || !dataFilters.hasFilters()) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLBuilder.Element filtersXmlElement = xml.startElement(TAG_FILTERS);){
            this.addAttributeIfNotEmpty(xml, ATTR_ORDER, dataFilters.getOrder());
            this.addAttributeIfNotEmpty(xml, ATTR_WHERE, dataFilters.getWhere());
            this.addAttributeIfNotEmpty(xml, ATTR_ANY_CONSTRAINT, String.valueOf(dataFilters.isAnyConstraint()));
            for (DBDAttributeConstraint constraint : dataFilters.getConstraints()) {
                this.serializeFilterConstraint(xml, constraint);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private DBDDataFilter deserializeFilter(Element filtersElement) {
        DBDDataFilter filter = new DBDDataFilter();
        filter.setOrder(CommonUtils.nullIfEmpty((String)filtersElement.getAttribute(ATTR_ORDER)));
        filter.setWhere(CommonUtils.nullIfEmpty((String)filtersElement.getAttribute(ATTR_WHERE)));
        filter.setAnyConstraint(CommonUtils.toBoolean((Object)filtersElement.getAttribute(ATTR_ANY_CONSTRAINT)));
        NodeList constraints = filtersElement.getElementsByTagName(TAG_CONSTRAINT);
        int i = 0;
        while (i < constraints.getLength()) {
            Element constraintElement = (Element)constraints.item(i);
            DBDAttributeConstraint constraint = new DBDAttributeConstraint(constraintElement.getAttribute(ATTR_NAME), constraintElement.getAttribute(ATTR_LABEL), CommonUtils.toInt((Object)constraintElement.getAttribute(ATTR_VISUAL_POSITION)));
            constraint.setPlainNameReference(CommonUtils.toBoolean((Object)constraintElement.getAttribute(ATTR_PLAIN_NAME)));
            constraint.setOrderPosition(CommonUtils.toInt((Object)constraintElement.getAttribute(ATTR_ORDER_POSITION)));
            constraint.setOrderDescending(CommonUtils.toBoolean((Object)constraintElement.getAttribute(ATTR_ORDER_DESCENDING)));
            constraint.setCriteria(CommonUtils.nullIfEmpty((String)constraintElement.getAttribute(ATTR_CRITERIA)));
            String operatorId = CommonUtils.nullIfEmpty((String)constraintElement.getAttribute(ATTR_OPERATOR));
            if (operatorId != null) {
                constraint.setOperator(DBCLogicalOperator.valueOf((String)operatorId));
                constraint.setReverseOperator(CommonUtils.toBoolean((Object)constraintElement.getAttribute(ATTR_REVERSE_OPERATOR)));
            }
            filter.addConstraints(List.of(constraint));
            ++i;
        }
        return filter;
    }

    private void serializeFilterConstraint(XMLBuilder xml, DBDAttributeConstraint constraint) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLBuilder.Element constraintXmlElement = xml.startElement(TAG_CONSTRAINT);){
            this.addAttributeIfNotEmpty(xml, ATTR_NAME, constraint.getAttributeName());
            this.addAttributeIfNotEmpty(xml, ATTR_VISUAL_POSITION, String.valueOf(constraint.getOriginalVisualPosition()));
            this.addAttributeIfNotEmpty(xml, ATTR_LABEL, constraint.getAttributeLabel());
            this.addAttributeIfNotEmpty(xml, ATTR_PLAIN_NAME, String.valueOf(constraint.isPlainNameReference()));
            this.addAttributeIfNotEmpty(xml, ATTR_ORDER_POSITION, String.valueOf(constraint.getOrderPosition()));
            this.addAttributeIfNotEmpty(xml, ATTR_ORDER_DESCENDING, String.valueOf(constraint.isOrderDescending()));
            this.addAttributeIfNotEmpty(xml, ATTR_CRITERIA, constraint.getCriteria());
            if (constraint.getOperator() != null) {
                this.addAttributeIfNotEmpty(xml, ATTR_OPERATOR, constraint.getOperator().getId());
                this.addAttributeIfNotEmpty(xml, ATTR_REVERSE_OPERATOR, String.valueOf(constraint.isReverseOperator()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addAttributeIfNotEmpty(XMLBuilder xmlBuilder, String attrName, String attrValue) throws IOException {
        if (CommonUtils.isEmpty((String)attrValue)) {
            return;
        }
        xmlBuilder.addAttribute(attrName, attrValue);
    }
}

