/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.js;

import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.exec.js.MongoJSClient;
import com.dbeaver.db.mongodb.exec.js.MongoJSDatabase;
import com.dbeaver.db.mongodb.exec.js.MongoJSSafeScriptableProxy;
import com.dbeaver.db.mongodb.exec.js.MongoJSUtils;
import com.dbeaver.db.mongodb.model.MGDatabase;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.script.SimpleScriptContext;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCScriptContext;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

public class MongoJSProcessor {
    private static final Log log = Log.getLog(MongoJSProcessor.class);
    private final MongoJSClient jsClient = new MongoJSClient(this);
    private final MGSession session;
    private final MGDatabase database;
    private Scriptable jsScope;

    public MongoJSProcessor(MGSession session, MGDatabase database) {
        this.session = session;
        this.database = database;
        SimpleScriptContext context = new SimpleScriptContext();
        context.setAttribute("db", new MongoJSDatabase(this, database), 100);
        context.setAttribute("ObjectId", ObjectId::new, 100);
    }

    public MongoJSClient getJsClient() {
        return this.jsClient;
    }

    public MGSession getSession() {
        return this.session;
    }

    public Scriptable getScope() {
        return this.jsScope;
    }

    public static MongoJSProcessor forStatement(MGSession session, DBCStatement statement, MGDatabase database) {
        DBCScriptContext scriptContext;
        DBCExecutionSource statementSource = statement.getStatementSource();
        if (statementSource != null && (scriptContext = statementSource.getScriptContext()) != null) {
            MongoJSProcessor processor = (MongoJSProcessor)scriptContext.getData("mongoEngine");
            if (processor == null) {
                processor = new MongoJSProcessor(session, database);
                scriptContext.setData("mongoEngine", (Object)processor);
            }
            return processor;
        }
        return new MongoJSProcessor(session, database);
    }

    public Object eval(String code) throws DBCException {
        try {
            return this.runInRhino(code);
        }
        catch (Throwable e) {
            throw new DBCException("JS eval failed", e);
        }
    }

    private Object runInRhino(String code) {
        Context cx = Context.enter();
        cx.setWrapFactory((WrapFactory)new MongoWrapFactory());
        this.jsScope = cx.initSafeStandardObjects();
        this.jsScope.put("db", this.jsScope, (Object)new MongoJSDatabase(this, this.database));
        try {
            Method member = MongoJSUtils.class.getMethod("createObjectId", String.class);
            FunctionObject objectIdFunction = new FunctionObject("ObjectId", (Member)member, this.jsScope);
            this.jsScope.put("ObjectId", this.jsScope, (Object)objectIdFunction);
        }
        catch (Throwable e) {
            log.debug((Object)"Error mapping ObjectId function", e);
        }
        Object result = cx.evaluateString(this.jsScope, code, "js", 1, null);
        return MongoJSUtils.unwrapObject(result);
    }

    private static class MongoDatabaseWrapper
    extends NativeJavaObject {
        private final MongoJSDatabase database;

        public MongoDatabaseWrapper(@NotNull Scriptable scope, @NotNull MongoJSDatabase database) {
            super(scope, (Object)database, database.getClass());
            this.database = database;
        }

        public String getClassName() {
            return "MongoDatabase";
        }

        public boolean has(String name, Scriptable start) {
            return true;
        }

        public Object get(String name, Scriptable start) {
            if (super.has(name, start)) {
                return super.get(name, start);
            }
            try {
                Context cx = Context.getCurrentContext();
                Object obj = this.database.getCollection(name);
                return cx.getWrapFactory().wrap(cx, (Scriptable)this, obj, obj.getClass());
            }
            catch (DBCException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class MongoWrapFactory
    extends WrapFactory {
        private MongoWrapFactory() {
        }

        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
            MongoDatabaseWrapper scriptable = MongoJSDatabase.class.isAssignableFrom(javaObject.getClass()) ? new MongoDatabaseWrapper(scope, (MongoJSDatabase)javaObject) : super.wrapAsJavaObject(cx, scope, javaObject, staticType);
            return new MongoJSSafeScriptableProxy((Scriptable)scriptable);
        }
    }
}

